/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.hsmcleaner;

import java.io.PrintWriter;
import java.util.Arrays;

public class EventHistogram {
    private int[] _counters;
    private long _period;
    private long _time;
    private final String _format;

    public EventHistogram(int slots, long period) {
        this(slots, period, "%1$tD %1$tR %2$-50s [ %3$d events ]%n");
    }

    public EventHistogram(int slots, long period, String format) {
        this._period = period;
        this._counters = new int[slots];
        this._format = format;
        this._time = System.currentTimeMillis() / this._period * this._period + this._period;
    }

    private void shift() {
        long now = System.currentTimeMillis();
        if (now > this._time) {
            int slots = this._counters.length;
            double d = now - this._time;
            int shift = (int)Math.ceil(d / (double)this._period);
            System.arraycopy(this._counters, 0, this._counters, Math.min(shift, slots), Math.max(0, slots - shift));
            Arrays.fill(this._counters, 0, Math.min(shift, slots), 0);
            this._time += (long)shift * this._period;
        }
    }

    private int getMax() {
        int value = 0;
        for (int counter : this._counters) {
            value = Math.max(value, counter);
        }
        return value;
    }

    private String repeat(char c, int count) {
        StringBuilder builder = new StringBuilder(count);
        for (int i = 0; i < count; ++i) {
            builder.append(c);
        }
        return builder.toString();
    }

    public void write(PrintWriter out) {
        this.shift();
        int max = Math.max(1, this.getMax());
        int slots = this._counters.length;
        long time = this._time - (long)slots * this._period;
        for (int i = 0; i < slots; ++i) {
            int events = this._counters[slots - i - 1];
            out.printf(this._format, time + (long)i * this._period, this.repeat('#', events / max), events);
        }
    }

    public void add() {
        this.shift();
        this._counters[0] = this._counters[0] + 1;
    }
}

