/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.plots.jaida;

import hep.aida.IAnalysisFactory;
import hep.aida.IHistogram1D;
import hep.aida.IHistogramFactory;
import hep.aida.ITree;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.dcache.services.billing.histograms.AbstractTimeFrameHistogramFactory;
import org.dcache.services.billing.histograms.TimeFrame;
import org.dcache.services.billing.histograms.config.HistogramWrapper;
import org.dcache.services.billing.histograms.data.IHistogramData;
import org.dcache.services.billing.histograms.data.TimeFrameHistogramData;
import org.dcache.services.billing.plots.jaida.JaidaTimeFramePlot;
import org.dcache.services.billing.plots.util.ITimeFramePlot;
import org.dcache.services.billing.plots.util.ITimeFramePlotGenerator;
import org.dcache.services.billing.plots.util.PlotGridPosition;

public final class JaidaTimeFramePlotGenerator
extends AbstractTimeFrameHistogramFactory<IHistogram1D>
implements ITimeFramePlotGenerator<IHistogram1D> {
    private static final String JAIDA_PROPERTIES = "org/dcache/services/billing/plot/jaida.properties";
    private IAnalysisFactory af;
    private IHistogramFactory factory;
    private ITree tree;

    @Override
    public IHistogram1D create(HistogramWrapper<IHistogram1D> configuration) {
        TimeFrame timeFrame = configuration.getTimeFrame();
        String title = configuration.getTitle();
        double del = timeFrame.getBinWidth() / 2.0;
        IHistogram1D histogram = this.factory.createHistogram1D(title, timeFrame.getBinCount(), (double)TimeUnit.MILLISECONDS.toSeconds(timeFrame.getLowTime()) - del, (double)TimeUnit.MILLISECONDS.toSeconds(timeFrame.getHighTime()) - del);
        TimeFrameHistogramData data = configuration.getData();
        String field = data.getField();
        Double dfactor = data.getDfactor();
        Collection<IHistogramData> binData = data.getData();
        if (field != null) {
            double df = dfactor == null ? 1.0 : dfactor;
            for (IHistogramData d : binData) {
                histogram.fill((double)TimeUnit.MILLISECONDS.toSeconds(d.timestamp().getTime()), d.data().get(field) / df);
            }
        } else {
            for (IHistogramData d : binData) {
                histogram.fill((double)TimeUnit.MILLISECONDS.toSeconds(d.timestamp().getTime()));
            }
        }
        return histogram;
    }

    @Override
    public ITimeFramePlot createPlot(String plotName, String[] subtitles, PlotGridPosition position, List<HistogramWrapper<IHistogram1D>> histogram) {
        JaidaTimeFramePlot plot = new JaidaTimeFramePlot(this.af, this.tree, plotName, subtitles, this.properties);
        for (HistogramWrapper<IHistogram1D> h : histogram) {
            h.setHistogram(this.create(h));
            plot.addHistogram(position, h);
        }
        return plot;
    }

    @Override
    public String getPropertiesResource() {
        return JAIDA_PROPERTIES;
    }

    @Override
    public void initialize(Properties properties) {
        this.setProperties(properties);
        this.af = IAnalysisFactory.create();
        this.tree = this.af.createTreeFactory().create();
        this.factory = this.af.createHistogramFactory(this.tree);
    }
}

