/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.plots.jaida;

import hep.aida.IAnalysisFactory;
import hep.aida.IBaseHistogram;
import hep.aida.IHistogram1D;
import hep.aida.IPlotter;
import hep.aida.IPlotterFactory;
import hep.aida.IPlotterStyle;
import hep.aida.ITree;
import hep.aida.ref.plotter.PlotterUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.dcache.services.billing.histograms.config.HistogramWrapper;
import org.dcache.services.billing.plots.util.AbstractTimeFramePlot;
import org.dcache.services.billing.plots.util.PlotGridPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JaidaTimeFramePlot
extends AbstractTimeFramePlot {
    private static final Logger logger = LoggerFactory.getLogger(JaidaTimeFramePlot.class);
    private final IPlotterFactory factory;
    private final IPlotter plotter;
    private String[] titles;

    public JaidaTimeFramePlot(IAnalysisFactory af, ITree tree, String name, String[] titles, Properties properties) {
        super(name, properties);
        this.factory = af.createPlotterFactory();
        this.plotter = this.factory.create(name);
        this.titles = titles == null ? new String[0] : Arrays.copyOf(titles, titles.length);
    }

    @Override
    public void plot() {
        this.plotter.createRegions(this.rows, this.cols);
        int region = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.cols; ++col) {
                PlotGridPosition p = new PlotGridPosition(row, col);
                List histograms = this.getHistogramsForPosition(p);
                for (HistogramWrapper<IHistogram1D> histogramWrapper : histograms) {
                    try {
                        IPlotterStyle style = this.factory.createPlotterStyle();
                        this.normalizeTitleStyle(style);
                        this.normalizeDataStyle(style, histogramWrapper);
                        this.normalizeXAxisStyle(style, histogramWrapper);
                        this.normalizeYAxisStyle(style, histogramWrapper);
                        if (region < this.titles.length) {
                            this.plotter.region(region).setTitle(this.titles[region]);
                        }
                        this.plotter.region(region).plot((IBaseHistogram)histogramWrapper.getHistogram(), style);
                    }
                    catch (Exception t) {
                        logger.error("the following plot could not be written: {}", (Object)histogramWrapper.getTitle());
                    }
                    catch (Throwable t) {
                        logger.error("the following plot could not be written: {}", (Object)histogramWrapper.getTitle(), (Object)t);
                    }
                }
                ++region;
            }
        }
        if (this.exportSubdir != null) {
            this.exportPlot();
        } else {
            this.plotter.show();
        }
    }

    private void exportPlot() {
        File path = new File(this.exportSubdir, this.name + this.extension);
        try {
            PlotterUtilities.writeToFile((IPlotter)this.plotter, (String)path.getAbsolutePath(), (String)this.imageType, (Properties)this.properties);
        }
        catch (IOException e) {
            logger.error("Cannot write billing plot: {}", (Object)e.getMessage());
        }
    }

    private void normalizeDataStyle(IPlotterStyle histogramStyle, HistogramWrapper<IHistogram1D> histogram) {
        histogramStyle.dataStyle().errorBarStyle().setVisible(false);
        histogramStyle.dataStyle().showInStatisticsBox(false);
        String color = histogram.getColor();
        String markerShape = this.properties.getProperty("marker.shape");
        Integer curveThickness = Integer.parseInt(this.properties.getProperty("curve.thickness"));
        Integer markerSize = Integer.parseInt(this.properties.getProperty("marker.size"));
        Integer outlineThickness = Integer.parseInt(this.properties.getProperty("outline.thickness"));
        Double opacity = Double.parseDouble(this.properties.getProperty("opacity"));
        switch (histogram.getStyle()) {
            case CONNECTED: {
                histogramStyle.dataStyle().fillStyle().setVisible(false);
                histogramStyle.dataStyle().outlineStyle().setVisible(true);
                histogramStyle.dataStyle().outlineStyle().setColor(color);
                histogramStyle.dataStyle().outlineStyle().setThickness(curveThickness.intValue());
                histogramStyle.dataStyle().markerStyle().setSize(markerSize.intValue());
                histogramStyle.dataStyle().markerStyle().setShape(markerShape);
                histogramStyle.dataStyle().markerStyle().setColor(color);
                histogramStyle.dataStyle().markerStyle().setVisible(true);
                histogramStyle.dataStyle().lineStyle().setVisible(false);
                break;
            }
            case OUTLINE: {
                histogramStyle.dataStyle().fillStyle().setVisible(false);
                histogramStyle.dataStyle().outlineStyle().setVisible(false);
                histogramStyle.dataStyle().markerStyle().setVisible(false);
                histogramStyle.dataStyle().lineStyle().setColor(color);
                histogramStyle.dataStyle().lineStyle().setThickness(outlineThickness.intValue());
                histogramStyle.dataStyle().lineStyle().setVisible(true);
                break;
            }
            case FILLED: {
                histogramStyle.dataStyle().fillStyle().setVisible(true);
                histogramStyle.dataStyle().fillStyle().setColor(color);
                histogramStyle.dataStyle().fillStyle().setOpacity(opacity.doubleValue());
                histogramStyle.dataStyle().outlineStyle().setVisible(false);
                histogramStyle.dataStyle().markerStyle().setVisible(false);
                histogramStyle.dataStyle().lineStyle().setColor(color);
                histogramStyle.dataStyle().lineStyle().setVisible(true);
            }
        }
    }

    private void normalizeTitleStyle(IPlotterStyle style) {
        style.titleStyle().textStyle().setFontSize((double)Integer.parseInt(this.properties.getProperty("plot.title.size")));
        style.titleStyle().textStyle().setBold(true);
        style.titleStyle().textStyle().setColor(this.properties.getProperty("plot.title.color"));
        style.titleStyle().textStyle().setVisible(true);
    }

    private void normalizeXAxisStyle(IPlotterStyle histogramStyle, HistogramWrapper<IHistogram1D> histogram) {
        histogramStyle.xAxisStyle().setParameter("type", this.properties.getProperty("x.axis.type"));
        histogramStyle.xAxisStyle().setLabel(histogram.getXLabel());
        histogramStyle.xAxisStyle().labelStyle().setBold(true);
        histogramStyle.xAxisStyle().labelStyle().setFontSize((double)Integer.parseInt(this.properties.getProperty("x.axis.size")));
        histogramStyle.xAxisStyle().labelStyle().setItalic(true);
        histogramStyle.xAxisStyle().labelStyle().setColor(this.properties.getProperty("x.axis.label.color"));
        histogramStyle.xAxisStyle().tickLabelStyle().setFontSize((double)Integer.parseInt(this.properties.getProperty("x.axis.tick.size")));
        histogramStyle.xAxisStyle().tickLabelStyle().setBold(true);
        histogramStyle.xAxisStyle().tickLabelStyle().setColor(this.properties.getProperty("x.axis.tick.label.color"));
    }

    private void normalizeYAxisStyle(IPlotterStyle histogramStyle, HistogramWrapper<IHistogram1D> histogram) {
        histogramStyle.yAxisStyle().setLabel(histogram.getYLabel());
        histogramStyle.yAxisStyle().labelStyle().setBold(true);
        histogramStyle.yAxisStyle().labelStyle().setFontSize((double)Integer.parseInt(this.properties.getProperty("y.axis.size")));
        histogramStyle.yAxisStyle().labelStyle().setItalic(true);
        histogramStyle.yAxisStyle().labelStyle().setColor(this.properties.getProperty("y.axis.label.color"));
        histogramStyle.yAxisStyle().tickLabelStyle().setFontSize((double)Integer.parseInt(this.properties.getProperty("y.axis.tick.size")));
        histogramStyle.yAxisStyle().tickLabelStyle().setBold(true);
        histogramStyle.yAxisStyle().tickLabelStyle().setColor(this.properties.getProperty("y.axis.tick.label.color"));
        histogramStyle.yAxisStyle().setScaling(histogram.getScaling());
        histogramStyle.yAxisStyle().setParameter("allowZeroSuppression", this.properties.getProperty("y.axis.allow.zero.suppression"));
    }
}

