/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.histograms.data;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.dcache.cells.CellStub;
import org.dcache.services.billing.histograms.TimeFrame;
import org.dcache.vehicles.billing.HistogramRequestMessage;

public class TimeFrameHistogramDataProxy
implements InvocationHandler {
    private static final Class[] ONE_PARAM = new Class[]{TimeFrame.class};
    private static final Class[] TWO_PARAM = new Class[]{TimeFrame.class, Boolean.class};
    private final CellStub cell;

    public TimeFrameHistogramDataProxy(CellStub cell) {
        Preconditions.checkNotNull((Object)cell);
        this.cell = cell;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        HistogramRequestMessage request = TimeFrameHistogramDataProxy.createRequestMessage(method, args);
        request = this.cell.sendAndWait(request, HistogramRequestMessage.class);
        return request.getReturnValue();
    }

    private static HistogramRequestMessage createRequestMessage(Method method, Object[] args) {
        Serializable[] serializable;
        Class[] types;
        if (args.length == 1) {
            types = ONE_PARAM;
            serializable = new Serializable[]{(TimeFrame)args[0]};
        } else {
            types = TWO_PARAM;
            serializable = new Serializable[]{(TimeFrame)args[0], (Boolean)args[1]};
        }
        return new HistogramRequestMessage(method.getName(), types, serializable);
    }
}

