/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.histograms.data;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.dcache.services.billing.db.IBillingInfoAccess;
import org.dcache.services.billing.db.data.BaseEntry;
import org.dcache.services.billing.db.data.DcacheReadsDaily;
import org.dcache.services.billing.db.data.DcacheReadsHourly;
import org.dcache.services.billing.db.data.DcacheTimeDaily;
import org.dcache.services.billing.db.data.DcacheTimeHourly;
import org.dcache.services.billing.db.data.DcacheWritesDaily;
import org.dcache.services.billing.db.data.DcacheWritesHourly;
import org.dcache.services.billing.db.data.HSMReadsDaily;
import org.dcache.services.billing.db.data.HSMReadsHourly;
import org.dcache.services.billing.db.data.HSMWritesDaily;
import org.dcache.services.billing.db.data.HSMWritesHourly;
import org.dcache.services.billing.db.data.HitsDaily;
import org.dcache.services.billing.db.data.HitsHourly;
import org.dcache.services.billing.db.data.MissesHourly;
import org.dcache.services.billing.db.data.PoolToPoolTransfersDaily;
import org.dcache.services.billing.db.data.PoolToPoolTransfersHourly;
import org.dcache.services.billing.histograms.TimeFrame;
import org.dcache.services.billing.histograms.data.IHistogramData;
import org.dcache.services.billing.histograms.data.ITimeFrameHistogramDataService;
import org.dcache.services.billing.histograms.data.TimeFrameHistogramData;

public final class JDOTimeFrameHistogramDataService
implements ITimeFrameHistogramDataService {
    private IBillingInfoAccess access;

    @Override
    public TimeFrameHistogramData[] getDcBytesHistogram(TimeFrame timeFrame, Boolean write) {
        TimeFrameHistogramData[] histogram = new TimeFrameHistogramData[]{new TimeFrameHistogramData()};
        histogram[0].setType(write != false ? TimeFrameHistogramData.HistogramDataType.BYTES_UPLOADED : TimeFrameHistogramData.HistogramDataType.BYTES_DOWNLOADED);
        Collection<IHistogramData> plotData = TimeFrame.BinType.HOUR == timeFrame.getTimebin() ? (write.booleanValue() ? this.getViewData(DcacheWritesHourly.class) : this.getViewData(DcacheReadsHourly.class)) : (write != false ? this.getCoarseGrainedData(DcacheWritesDaily.class, timeFrame) : this.getCoarseGrainedData(DcacheReadsDaily.class, timeFrame));
        histogram[0].setData(plotData);
        histogram[0].setDfactor(1.073741824E9);
        histogram[0].setField("size");
        return histogram;
    }

    @Override
    public TimeFrameHistogramData[] getDcConnectTimeHistograms(TimeFrame timeFrame) {
        Collection<IHistogramData> plotData = TimeFrame.BinType.HOUR == timeFrame.getTimebin() ? this.getViewData(DcacheTimeHourly.class) : this.getCoarseGrainedData(DcacheTimeDaily.class, timeFrame);
        TimeFrameHistogramData.HistogramDataType[] type = new TimeFrameHistogramData.HistogramDataType[]{TimeFrameHistogramData.HistogramDataType.TIME_MAX, TimeFrameHistogramData.HistogramDataType.TIME_AVG, TimeFrameHistogramData.HistogramDataType.TIME_MIN};
        String[] field = new String[]{"maximum", "average", "minimum"};
        TimeFrameHistogramData[] histogram = new TimeFrameHistogramData[]{new TimeFrameHistogramData(), new TimeFrameHistogramData(), new TimeFrameHistogramData()};
        for (int h = 0; h < histogram.length; ++h) {
            histogram[h].setData(plotData);
            histogram[h].setField(field[h]);
            histogram[h].setDfactor(1.0 * (double)TimeUnit.SECONDS.toMillis(1L));
            histogram[h].setType(type[h]);
        }
        return histogram;
    }

    @Override
    public TimeFrameHistogramData[] getDcTransfersHistogram(TimeFrame timeFrame, Boolean write) {
        TimeFrameHistogramData[] histogram = new TimeFrameHistogramData[]{new TimeFrameHistogramData()};
        histogram[0].setType(write != false ? TimeFrameHistogramData.HistogramDataType.TRANSFERS_UPLOADED : TimeFrameHistogramData.HistogramDataType.TRANSFERS_DOWNLOADED);
        Collection<IHistogramData> plotData = TimeFrame.BinType.HOUR == timeFrame.getTimebin() ? (write.booleanValue() ? this.getViewData(DcacheWritesHourly.class) : this.getViewData(DcacheReadsHourly.class)) : (write != false ? this.getCoarseGrainedData(DcacheWritesDaily.class, timeFrame) : this.getCoarseGrainedData(DcacheReadsDaily.class, timeFrame));
        histogram[0].setData(plotData);
        histogram[0].setField("count");
        return histogram;
    }

    @Override
    public TimeFrameHistogramData[] getHitHistograms(TimeFrame timeFrame) {
        Collection<IHistogramData> plotData = TimeFrame.BinType.HOUR == timeFrame.getTimebin() ? this.getHourlyAggregateForHits() : this.getCoarseGrainedData(HitsDaily.class, timeFrame);
        TimeFrameHistogramData[] histogram = new TimeFrameHistogramData[]{new TimeFrameHistogramData(), new TimeFrameHistogramData()};
        histogram[0].setData(plotData);
        histogram[0].setField("cached");
        histogram[0].setType(TimeFrameHistogramData.HistogramDataType.CACHED);
        histogram[1].setData(plotData);
        histogram[1].setField("notcached");
        histogram[1].setType(TimeFrameHistogramData.HistogramDataType.NOT_CACHED);
        return histogram;
    }

    @Override
    public TimeFrameHistogramData[] getHsmBytesHistogram(TimeFrame timeFrame, Boolean write) {
        TimeFrameHistogramData[] histogram = new TimeFrameHistogramData[]{new TimeFrameHistogramData()};
        histogram[0].setType(write != false ? TimeFrameHistogramData.HistogramDataType.BYTES_STORED : TimeFrameHistogramData.HistogramDataType.BYTES_RESTORED);
        Collection<IHistogramData> plotData = TimeFrame.BinType.HOUR == timeFrame.getTimebin() ? (write.booleanValue() ? this.getViewData(HSMWritesHourly.class) : this.getViewData(HSMReadsHourly.class)) : (write != false ? this.getCoarseGrainedData(HSMWritesDaily.class, timeFrame) : this.getCoarseGrainedData(HSMReadsDaily.class, timeFrame));
        histogram[0].setData(plotData);
        histogram[0].setField("size");
        histogram[0].setDfactor(1.073741824E9);
        return histogram;
    }

    @Override
    public TimeFrameHistogramData[] getHsmTransfersHistogram(TimeFrame timeFrame, Boolean write) {
        TimeFrameHistogramData[] histogram = new TimeFrameHistogramData[]{new TimeFrameHistogramData()};
        histogram[0].setType(write != false ? TimeFrameHistogramData.HistogramDataType.TRANSFERS_STORED : TimeFrameHistogramData.HistogramDataType.TRANSFERS_RESTORED);
        Collection<IHistogramData> plotData = TimeFrame.BinType.HOUR == timeFrame.getTimebin() ? (write.booleanValue() ? this.getViewData(HSMWritesHourly.class) : this.getViewData(HSMReadsHourly.class)) : (write != false ? this.getCoarseGrainedData(HSMWritesDaily.class, timeFrame) : this.getCoarseGrainedData(HSMReadsDaily.class, timeFrame));
        histogram[0].setData(plotData);
        histogram[0].setField("count");
        return histogram;
    }

    @Override
    public TimeFrameHistogramData[] getP2pBytesHistogram(TimeFrame timeFrame) {
        TimeFrameHistogramData[] histogram = new TimeFrameHistogramData[]{new TimeFrameHistogramData()};
        histogram[0].setType(TimeFrameHistogramData.HistogramDataType.BYTES_P2P);
        Collection<IHistogramData> plotData = TimeFrame.BinType.HOUR == timeFrame.getTimebin() ? this.getViewData(PoolToPoolTransfersHourly.class) : this.getCoarseGrainedData(PoolToPoolTransfersDaily.class, timeFrame);
        histogram[0].setData(plotData);
        histogram[0].setField("size");
        histogram[0].setDfactor(1.073741824E9);
        return histogram;
    }

    @Override
    public TimeFrameHistogramData[] getP2pTransfersHistogram(TimeFrame timeFrame) {
        TimeFrameHistogramData[] histogram = new TimeFrameHistogramData[]{new TimeFrameHistogramData()};
        histogram[0].setType(TimeFrameHistogramData.HistogramDataType.TRANSFERS_P2P);
        Collection<IHistogramData> plotData = TimeFrame.BinType.HOUR == timeFrame.getTimebin() ? this.getViewData(PoolToPoolTransfersHourly.class) : this.getCoarseGrainedData(PoolToPoolTransfersDaily.class, timeFrame);
        histogram[0].setData(plotData);
        histogram[0].setField("count");
        return histogram;
    }

    public void setAccess(IBillingInfoAccess access) {
        this.access = access;
    }

    private <T extends IHistogramData> Collection<IHistogramData> getCoarseGrainedData(Class<T> clzz, TimeFrame timeFrame) {
        return this.getData(clzz, "date >= date1 && date <= date2", "java.util.Date date1, java.util.Date date2", timeFrame.getLow(), timeFrame.getHigh());
    }

    private <T extends IHistogramData> Collection<IHistogramData> getViewData(Class<T> clzz) {
        Collection<T> c = this.access.get(clzz);
        ArrayList<IHistogramData> plotData = new ArrayList<IHistogramData>();
        plotData.addAll(c);
        return plotData;
    }

    private <T extends IHistogramData> Collection<IHistogramData> getData(Class<T> clzz, String filter, String params, Object ... values) {
        Collection<T> c = this.access.get(clzz, filter, params, values);
        ArrayList<IHistogramData> plotData = new ArrayList<IHistogramData>();
        plotData.addAll(c);
        return plotData;
    }

    private Collection<IHistogramData> getHourlyAggregateForHits() {
        HourlyHitData hourlyHitData;
        long count;
        HourlyHitData hourlyData;
        String key;
        Date date;
        TreeMap<String, HourlyHitData> hourlyAggregate = new TreeMap<String, HourlyHitData>();
        Collection<IHistogramData> histogramData = this.getViewData(HitsHourly.class);
        for (IHistogramData d : histogramData) {
            date = this.normalizeForHour(d.timestamp());
            key = date.toString();
            hourlyData = (HourlyHitData)hourlyAggregate.get(key);
            if (hourlyData == null) {
                hourlyData = new HourlyHitData();
                hourlyData.setDate(date);
                hourlyAggregate.put(key, hourlyData);
            }
            count = d.data().get("count").longValue();
            hourlyHitData = hourlyData;
            hourlyHitData.cached = hourlyHitData.cached + count;
        }
        histogramData = this.getViewData(MissesHourly.class);
        for (IHistogramData d : histogramData) {
            date = this.normalizeForHour(d.timestamp());
            key = date.toString();
            hourlyData = (HourlyHitData)hourlyAggregate.get(key);
            if (hourlyData == null) {
                hourlyData = new HourlyHitData();
                hourlyData.setDate(date);
                hourlyAggregate.put(key, hourlyData);
            }
            count = d.data().get("count").longValue();
            hourlyHitData = hourlyData;
            hourlyHitData.notcached = hourlyHitData.notcached + count;
        }
        histogramData = new ArrayList<IHistogramData>();
        histogramData.addAll(hourlyAggregate.values());
        return histogramData;
    }

    private Date normalizeForHour(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private static class HourlyHitData
    extends BaseEntry {
        private static final long serialVersionUID = -4776963573729329237L;
        private Long cached = 0L;
        private Long notcached = 0L;

        private HourlyHitData() {
        }

        @Override
        public Map<String, Double> data() {
            Map<String, Double> dataMap = super.data();
            dataMap.put("cached", this.cached.doubleValue());
            dataMap.put("notcached", this.notcached.doubleValue());
            return dataMap;
        }

        public String toString() {
            return "(" + this.dateString() + "," + this.cached + "," + this.notcached + ")";
        }
    }
}

