/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.histograms;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;

public final class TimeFrame
implements Serializable {
    private static final long serialVersionUID = 3114577177366772739L;
    private int binCount;
    private double binWidth;
    private Type timeframe;
    private BinType timebin;
    private final Calendar highDate = Calendar.getInstance();
    private final Calendar lowDate;

    public static Calendar computeHighTimeFromNow(BinType type) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(System.currentTimeMillis());
        int hh = 0;
        int dd = cal.get(5);
        if (type == BinType.HOUR) {
            hh = cal.get(11) < 12 ? 12 : 24;
        }
        cal.set(5, dd);
        cal.set(11, hh);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal;
    }

    public TimeFrame() {
        this(System.currentTimeMillis());
    }

    public TimeFrame(long upperBound) {
        this.highDate.setTime(new Date(upperBound));
        this.lowDate = Calendar.getInstance();
        this.binCount = 1;
        this.timeframe = Type.DAY;
    }

    public void configure() {
        Calendar tmp = Calendar.getInstance();
        tmp.setTime(this.highDate.getTime());
        switch (this.timeframe) {
            case DAY: {
                this.lowDate.setTime(new Date(this.highDate.getTimeInMillis() - TimeUnit.DAYS.toMillis(1L)));
                break;
            }
            case WEEK: {
                this.lowDate.setTime(new Date(this.highDate.getTimeInMillis() - TimeUnit.DAYS.toMillis(7L)));
                break;
            }
            case MONTH: {
                this.lowDate.setTime(new Date(this.highDate.getTimeInMillis() - TimeUnit.DAYS.toMillis(30L)));
                break;
            }
            case YEAR: {
                this.lowDate.setTime(new Date(this.highDate.getTimeInMillis() - TimeUnit.DAYS.toMillis(365L)));
                break;
            }
            case THIS_DAY: {
                tmp.set(12, 0);
                tmp.set(13, 0);
                tmp.set(11, 0);
                this.lowDate.setTime(new Date(tmp.getTimeInMillis()));
                tmp.set(12, 59);
                tmp.set(13, 59);
                tmp.set(11, 23);
                this.highDate.setTime(new Date(tmp.getTimeInMillis()));
                break;
            }
            case THIS_WEEK: {
                tmp.set(7, 1);
                tmp.set(13, 0);
                tmp.set(12, 0);
                tmp.set(11, 0);
                this.lowDate.setTime(new Date(tmp.getTimeInMillis()));
                tmp.set(13, 59);
                tmp.set(12, 59);
                tmp.set(11, 23);
                tmp.set(7, 7);
                this.highDate.setTime(new Date(tmp.getTimeInMillis()));
                break;
            }
            case THIS_MONTH: {
                tmp.set(5, 1);
                tmp.set(13, 0);
                tmp.set(12, 0);
                tmp.set(11, 0);
                this.lowDate.setTime(new Date(tmp.getTimeInMillis()));
                tmp.set(13, 59);
                tmp.set(12, 59);
                tmp.set(11, 23);
                tmp.set(5, tmp.getActualMaximum(5));
                this.highDate.setTime(new Date(tmp.getTimeInMillis()));
                break;
            }
            case THIS_YEAR: {
                tmp.set(5, 1);
                tmp.set(2, 0);
                tmp.set(13, 0);
                tmp.set(12, 0);
                tmp.set(11, 0);
                this.lowDate.setTime(new Date(tmp.getTimeInMillis()));
                tmp.set(2, 11);
                tmp.set(13, 59);
                tmp.set(12, 59);
                tmp.set(11, 23);
                tmp.set(5, tmp.getActualMaximum(5));
                this.highDate.setTime(new Date(tmp.getTimeInMillis()));
                break;
            }
        }
        switch (this.timebin) {
            case TEN_MINUTE: {
                this.binWidth = 600.0;
                break;
            }
            case HOUR: {
                this.binWidth = 3600.0;
                break;
            }
            case DAY: {
                this.binWidth = 86400.0;
                break;
            }
            case WEEK: {
                this.binWidth = 604800.0;
                break;
            }
            case MONTH: {
                this.binWidth = 2592000.0;
                break;
            }
            default: {
                this.binWidth = 3600.0;
            }
        }
        this.binCount = (int)((this.getHighTime().doubleValue() / 1000.0 - this.getLowTime().doubleValue() / 1000.0) / this.binWidth);
    }

    public int getBinCount() {
        return this.binCount;
    }

    public double getBinWidth() {
        return this.binWidth;
    }

    public Date getHigh() {
        return this.highDate.getTime();
    }

    public Calendar getHighDate() {
        return this.highDate;
    }

    public Long getHighTime() {
        return this.highDate.getTimeInMillis();
    }

    public Date getLow() {
        return this.lowDate.getTime();
    }

    public Calendar getLowDate() {
        return this.lowDate;
    }

    public Long getLowTime() {
        return this.lowDate.getTimeInMillis();
    }

    public BinType getTimebin() {
        return this.timebin;
    }

    public Type getTimeframe() {
        return this.timeframe;
    }

    public void setTimebin(BinType timebin) {
        this.timebin = timebin;
    }

    public void setTimeframe(Type timeframe) {
        this.timeframe = timeframe;
    }

    public static enum Type {
        DAY,
        WEEK,
        MONTH,
        YEAR,
        THIS_DAY,
        THIS_WEEK,
        THIS_MONTH,
        THIS_YEAR;

    }

    public static enum BinType {
        TEN_MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH;

    }
}

