/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.histograms;

import java.util.Properties;
import org.dcache.services.billing.histograms.ITimeFrameHistogramFactory;
import org.dcache.services.billing.histograms.TimeFrame;
import org.dcache.services.billing.histograms.config.HistogramWrapper;
import org.dcache.services.billing.histograms.data.TimeFrameHistogramData;

public abstract class AbstractTimeFrameHistogramFactory<H>
implements ITimeFrameHistogramFactory<H> {
    protected Properties properties;

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public HistogramWrapper<H> getConfigurationFor(TimeFrame timeframe, TimeFrameHistogramData data, ITimeFrameHistogramFactory.Style style, String scaling) {
        TimeFrameHistogramData.HistogramDataType type = data.getType();
        HistogramWrapper config = new HistogramWrapper();
        config.setStyle(style);
        config.setScaling(scaling);
        config.setData(data);
        config.setTimeFrame(timeframe);
        config.setXLabel(this.getProperty("label.x.axis"));
        switch (type) {
            case BYTES_UPLOADED: {
                config.setTitle(this.getProperty("label.dcache.writes"));
                config.setColor(this.getProperty("color.dcache"));
                this.configureBytes(config);
                break;
            }
            case BYTES_DOWNLOADED: {
                config.setTitle(this.getProperty("label.dcache.reads"));
                config.setColor(this.getProperty("color.dcache"));
                this.configureBytes(config);
                break;
            }
            case BYTES_P2P: {
                config.setTitle(this.getProperty("label.dcache.p2p"));
                config.setColor(this.getProperty("color.dcache"));
                this.configureBytes(config);
                break;
            }
            case BYTES_STORED: {
                config.setTitle(this.getProperty("label.hsm.writes"));
                config.setColor(this.getProperty("color.hsm"));
                this.configureBytes(config);
                break;
            }
            case BYTES_RESTORED: {
                config.setTitle(this.getProperty("label.hsm.reads"));
                config.setColor(this.getProperty("color.hsm"));
                this.configureBytes(config);
                break;
            }
            case TRANSFERS_UPLOADED: {
                config.setTitle(this.getProperty("label.dcache.writes"));
                config.setColor(this.getProperty("color.dcache"));
                this.configureTransfers(config);
                break;
            }
            case TRANSFERS_DOWNLOADED: {
                config.setTitle(this.getProperty("label.dcache.reads"));
                config.setColor(this.getProperty("color.dcache"));
                this.configureTransfers(config);
                break;
            }
            case TRANSFERS_P2P: {
                config.setTitle(this.getProperty("label.dcache.p2p"));
                config.setColor(this.getProperty("color.dcache"));
                this.configureTransfers(config);
                break;
            }
            case TRANSFERS_STORED: {
                config.setTitle(this.getProperty("label.hsm.writes"));
                config.setColor(this.getProperty("color.hsm"));
                this.configureTransfers(config);
                break;
            }
            case TRANSFERS_RESTORED: {
                config.setTitle(this.getProperty("label.hsm.reads"));
                config.setColor(this.getProperty("color.hsm"));
                this.configureTransfers(config);
                break;
            }
            case TIME_AVG: {
                config.setTitle(this.getProperty("label.average"));
                config.setColor(this.getProperty("color.avg"));
                this.configureConnectTime(config);
                break;
            }
            case TIME_MAX: {
                config.setTitle(this.getProperty("label.maximum"));
                config.setColor(this.getProperty("color.max"));
                this.configureConnectTime(config);
                break;
            }
            case TIME_MIN: {
                config.setTitle(this.getProperty("label.minimum"));
                config.setColor(this.getProperty("color.min"));
                this.configureConnectTime(config);
                break;
            }
            case CACHED: {
                config.setTitle(this.getProperty("label.cached"));
                config.setColor(this.getProperty("color.cached"));
                this.configureHitMiss(config);
                break;
            }
            case NOT_CACHED: {
                config.setTitle(this.getProperty("label.ncached"));
                config.setColor(this.getProperty("color.ncached"));
                this.configureHitMiss(config);
            }
        }
        return config;
    }

    private void configureBytes(HistogramWrapper<?> config) {
        if (TimeFrame.BinType.HOUR == config.getTimeFrame().getTimebin()) {
            config.setYLabel(this.getProperty("label.y.axis.gbytes.hourly"));
        } else {
            config.setYLabel(this.getProperty("label.y.axis.gbytes.daily"));
        }
    }

    private void configureConnectTime(HistogramWrapper<?> config) {
        config.setYLabel(this.getProperty("label.y.axis.connection.time"));
    }

    private void configureHitMiss(HistogramWrapper<?> config) {
        config.setYLabel(this.getProperty("label.y.axis.hits.hourly"));
    }

    private void configureTransfers(HistogramWrapper<?> config) {
        if (TimeFrame.BinType.HOUR == config.getTimeFrame().getTimebin()) {
            config.setYLabel(this.getProperty("label.y.axis.transfers.hourly"));
        } else {
            config.setYLabel(this.getProperty("label.y.axis.transfers.daily"));
        }
    }

    private String getProperty(String name) {
        return this.properties.getProperty(name);
    }
}

