/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.db.impl.datanucleus;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import javax.jdo.JDOCanRetryException;
import javax.jdo.JDOHelper;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.dcache.services.billing.db.exceptions.RetryException;
import org.dcache.services.billing.db.impl.BaseBillingInfoAccess;
import org.dcache.services.billing.histograms.data.IHistogramData;

public class DataNucleusBillingInfo
extends BaseBillingInfoAccess {
    public static final String DEFAULT_PROPERTIES = "org/dcache/services/billing/db/datanucleus.properties";
    private PersistenceManagerFactory pmf;

    private static Query createQuery(PersistenceManager pm, Class<?> type, String filter, String parameters) {
        Query query = pm.newQuery(type);
        if (filter != null) {
            query.setFilter(filter);
        }
        if (parameters != null) {
            query.declareParameters(parameters);
        }
        query.addExtension("datanucleus.rdbms.query.resultSetType", (Object)"scroll-insensitive");
        query.addExtension("datanucleus.query.resultCacheType", (Object)"none");
        query.getFetchPlan().setFetchSize(0);
        return query;
    }

    private static void rollbackIfActive(Transaction tx) {
        if (tx != null && tx.isActive()) {
            tx.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Collection<IHistogramData> data) {
        PersistenceManager insertManager = this.pmf.getPersistenceManager();
        Transaction tx = insertManager.currentTransaction();
        try {
            tx.begin();
            insertManager.makePersistentAll(data);
            tx.commit();
        }
        catch (JDOCanRetryException t) {
            throw new RetryException(t);
        }
        finally {
            try {
                DataNucleusBillingInfo.rollbackIfActive(tx);
            }
            finally {
                insertManager.close();
            }
        }
    }

    @Override
    public <T> Collection<T> get(Class<T> type) {
        return this.get(type, null, null, new Object[]{null});
    }

    @Override
    public <T> Collection<T> get(Class<T> type, String filter, Object ... values) {
        return this.get(type, filter, null, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> Collection<T> get(Class<T> type, String filter, String parameters, Object ... values) {
        PersistenceManager readManager = this.pmf.getPersistenceManager();
        Transaction tx = readManager.currentTransaction();
        try {
            tx.begin();
            Query query = DataNucleusBillingInfo.createQuery(readManager, type, filter, parameters);
            this.logger.trace("created query {}", (Object)query);
            Collection c = values == null ? (Collection)query.execute() : (Collection)query.executeWithArray(values);
            this.logger.trace("collection size = {}", (Object)c.size());
            Collection detached = readManager.detachCopyAll(c);
            this.logger.trace("got detatched collection {}", (Object)detached);
            tx.commit();
            this.logger.trace("successfully executed {}", new Object[]{"get: {}, {}. {}. {}", type, filter, parameters, values == null ? null : Arrays.asList(values)});
            Collection collection = detached;
            return collection;
        }
        finally {
            try {
                DataNucleusBillingInfo.rollbackIfActive(tx);
            }
            finally {
                readManager.close();
            }
        }
    }

    @Override
    public void initializeInternal() {
        this.addJdbcDNProperties();
        try {
            if (this.propertiesPath != null && !"".equals(this.propertiesPath.trim())) {
                File file = new File(this.propertiesPath);
                if (!file.exists()) {
                    throw new RuntimeException("Cannot run BillingInfoCell for properties file: " + file);
                }
                try (FileInputStream stream = new FileInputStream(file);){
                    this.properties.load(stream);
                }
            } else {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                URL resource = classLoader.getResource(DEFAULT_PROPERTIES);
                if (resource == null) {
                    throw new RuntimeException("Cannot run BillingInfoCell; cannot find resource org/dcache/services/billing/db/datanucleus.properties");
                }
                this.properties.load(resource.openStream());
            }
            this.pmf = JDOHelper.getPersistenceManagerFactory((Map)this.properties);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot run BillingInfoCell", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> long remove(Class<T> type) {
        PersistenceManager deleteManager = this.pmf.getPersistenceManager();
        Transaction tx = deleteManager.currentTransaction();
        this.logger.trace("remove all instances of {}", type);
        try {
            tx.begin();
            Query query = deleteManager.newQuery("DELETE FROM " + type.getName());
            long removed = (Long)query.execute();
            tx.commit();
            this.logger.trace("successfully removed " + removed + " entries of type " + type);
            long l = removed;
            return l;
        }
        finally {
            try {
                DataNucleusBillingInfo.rollbackIfActive(tx);
            }
            finally {
                deleteManager.close();
            }
        }
    }

    @Override
    public <T> long remove(Class<T> type, String filter, Object ... values) {
        return this.remove(type, filter, null, values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> long remove(Class<T> type, String filter, String parameters, Object ... values) {
        PersistenceManager deleteManager = this.pmf.getPersistenceManager();
        Transaction tx = deleteManager.currentTransaction();
        try {
            tx.begin();
            Query query = DataNucleusBillingInfo.createQuery(deleteManager, type, filter, parameters);
            long removed = values == null ? query.deletePersistentAll() : query.deletePersistentAll(values);
            tx.commit();
            this.logger.trace("successfully removed {} entries of type {}", (Object)removed, type);
            long l = removed;
            return l;
        }
        finally {
            try {
                DataNucleusBillingInfo.rollbackIfActive(tx);
            }
            finally {
                deleteManager.close();
            }
        }
    }

    @Override
    public void setPropertiesPath(String propetiesPath) {
        this.propertiesPath = propetiesPath;
    }

    private void addJdbcDNProperties() {
        if (this.jdbcDriver != null && !"".equals(this.jdbcDriver)) {
            this.properties.setProperty("datanucleus.ConnectionDriverName", this.jdbcDriver);
        }
        if (!Strings.isNullOrEmpty((String)this.jdbcUrl)) {
            this.properties.setProperty("datanucleus.ConnectionURL", this.jdbcUrl);
        }
        if (!Strings.isNullOrEmpty((String)this.jdbcUser)) {
            this.properties.setProperty("datanucleus.ConnectionUserName", this.jdbcUser);
        }
        if (!Strings.isNullOrEmpty((String)this.jdbcPassword)) {
            this.properties.setProperty("datanucleus.ConnectionPassword", this.jdbcPassword);
        }
        this.setPropertyIfValueSet(this.properties, "datanucleus.connectionPool.minPoolSize", this.minConnectionsPerPartition);
        this.setPropertyIfValueSet(this.properties, "datanucleus.connectionPool.maxPoolSize", this.maxConnectionsPerPartition);
    }

    private void setPropertyIfValueSet(Properties properties, String key, int value) {
        if (value != -1) {
            properties.setProperty(key, String.valueOf(value));
        }
    }
}

