/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.db.impl;

import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.dcache.services.billing.db.data.DoorRequestData;
import org.dcache.services.billing.db.data.MoverData;
import org.dcache.services.billing.db.data.PoolHitData;
import org.dcache.services.billing.db.data.StorageData;
import org.dcache.services.billing.db.exceptions.RetryException;
import org.dcache.services.billing.db.impl.BaseBillingInfoAccess;
import org.dcache.services.billing.histograms.data.IHistogramData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueueDelegate {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected int maxBatchSize;
    protected int maxQueueSize;
    protected boolean dropMessagesAtLimit;
    protected AtomicLong dropped = new AtomicLong(0L);
    protected AtomicLong committed = new AtomicLong(0L);
    protected BlockingQueue moverQueue;
    protected BlockingQueue doorQueue;
    protected BlockingQueue storageQueue;
    protected BlockingQueue hitQueue;
    private Thread moverConsumer;
    private Thread doorConsumer;
    private Thread storageConsumer;
    private Thread hitConsumer;
    private BaseBillingInfoAccess callback;
    private boolean running;

    public void close() {
        this.setRunning(false);
        if (this.moverConsumer != null) {
            this.moverConsumer.interrupt();
            try {
                this.moverConsumer.join();
            }
            catch (InterruptedException e) {
                this.logger.trace("join on moverConsumer interrupted");
            }
        }
        if (this.doorConsumer != null) {
            this.doorConsumer.interrupt();
            try {
                this.doorConsumer.join();
            }
            catch (InterruptedException e) {
                this.logger.trace("join on doorConsumer interrupted");
            }
        }
        if (this.storageConsumer != null) {
            this.storageConsumer.interrupt();
            try {
                this.storageConsumer.join();
            }
            catch (InterruptedException e) {
                this.logger.trace("join on storageConsumer interrupted");
            }
        }
        if (this.hitConsumer != null) {
            this.hitConsumer.interrupt();
            try {
                this.hitConsumer.join();
            }
            catch (InterruptedException e) {
                this.logger.trace("join on hitConsumer interrupted");
            }
        }
        this.logger.trace("{} close exiting", (Object)this);
    }

    public long getCommitted() {
        return this.committed.get();
    }

    public long getDropped() {
        return this.dropped.get();
    }

    public long getQueueSize() {
        return this.moverQueue.size() + this.doorQueue.size() + this.storageQueue.size() + this.hitQueue.size();
    }

    public void handlePut(IHistogramData data) {
        if (data instanceof MoverData) {
            this.handlePut((MoverData)data);
        } else if (data instanceof StorageData) {
            this.handlePut((StorageData)data);
        } else if (data instanceof DoorRequestData) {
            this.handlePut((DoorRequestData)data);
        } else if (data instanceof PoolHitData) {
            this.handlePut((PoolHitData)data);
        }
    }

    public void initialize() {
        this.initializeInternal();
        this.moverQueue = new LinkedBlockingQueue(this.maxQueueSize);
        this.doorQueue = new LinkedBlockingQueue(this.maxQueueSize);
        this.storageQueue = new LinkedBlockingQueue(this.maxQueueSize);
        this.hitQueue = new LinkedBlockingQueue(this.maxQueueSize);
        this.setRunning(true);
        this.moverConsumer = new Consumer("mover data consumer", this.moverQueue);
        this.doorConsumer = new Consumer("door requeust data consumer", this.doorQueue);
        this.storageConsumer = new Consumer("storage data consumer", this.storageQueue);
        this.hitConsumer = new Consumer("cache hit data consumer", this.hitQueue);
        this.moverConsumer.start();
        this.doorConsumer.start();
        this.storageConsumer.start();
        this.hitConsumer.start();
    }

    public void setCallback(BaseBillingInfoAccess callback) {
        this.callback = callback;
    }

    public void setDropMessagesAtLimit(boolean dropMessagesAtLimit) {
        this.dropMessagesAtLimit = dropMessagesAtLimit;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    protected abstract void handlePut(DoorRequestData var1);

    protected abstract void handlePut(MoverData var1);

    protected abstract void handlePut(PoolHitData var1);

    protected abstract void handlePut(StorageData var1);

    protected abstract void initializeInternal();

    protected synchronized boolean isRunning() {
        return this.running;
    }

    protected synchronized void setRunning(boolean running) {
        this.running = running;
    }

    private class Consumer
    extends Thread {
        private BlockingQueue queue;

        private Consumer(String name, BlockingQueue queue) {
            super(name);
            this.queue = queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block11: {
                block9: while (true) {
                    try {
                        while (QueueDelegate.this.isRunning()) {
                            ArrayList<IHistogramData> data = new ArrayList<IHistogramData>();
                            QueueDelegate.this.logger.trace("calling queue.take()");
                            data.add((IHistogramData)this.queue.take());
                            QueueDelegate.this.logger.trace("calling queue.drainTo(), queue size {}", (Object)this.queue.size());
                            this.queue.drainTo(data, QueueDelegate.this.maxBatchSize);
                            try {
                                QueueDelegate.this.logger.trace("calling commit");
                                QueueDelegate.this.callback.commit(data);
                                QueueDelegate.this.committed.addAndGet(data.size());
                                continue block9;
                            }
                            catch (RetryException t) {
                                QueueDelegate.this.logger.warn("commit failed; retrying once ...");
                                try {
                                    QueueDelegate.this.callback.commit(data);
                                    continue block9;
                                }
                                catch (RetryException t1) {
                                    QueueDelegate.this.logger.error("commit retry failed, {} inserts have been lost", (Object)data.size());
                                    QueueDelegate.this.logger.debug("exception in run(), commit", (Throwable)t1);
                                }
                            }
                        }
                        break block11;
                    }
                    catch (InterruptedException t) {
                        QueueDelegate.this.logger.warn("queue take() was interrupted; this is probably due to cell shutdown; exiting thread ...");
                        break block11;
                    }
                }
                finally {
                    QueueDelegate.this.setRunning(false);
                }
            }
        }
    }
}

