/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.db.impl;

import org.dcache.services.billing.db.data.DoorRequestData;
import org.dcache.services.billing.db.data.MoverData;
import org.dcache.services.billing.db.data.PoolHitData;
import org.dcache.services.billing.db.data.StorageData;
import org.dcache.services.billing.db.impl.QueueDelegate;
import org.dcache.services.billing.histograms.data.IHistogramData;

public class DirectQueueDelegate
extends QueueDelegate {
    @Override
    protected void handlePut(DoorRequestData data) {
        if (!this.dropMessagesAtLimit) {
            try {
                this.doorQueue.put(data);
            }
            catch (InterruptedException t) {
                this.processInterrupted(data);
            }
        } else if (!this.doorQueue.offer(data)) {
            this.processDroppedData(data);
        }
    }

    @Override
    protected void handlePut(MoverData data) {
        if (!this.dropMessagesAtLimit) {
            try {
                this.moverQueue.put(data);
            }
            catch (InterruptedException t) {
                this.processInterrupted(data);
            }
        } else if (!this.moverQueue.offer(data)) {
            this.processDroppedData(data);
        }
    }

    @Override
    protected void handlePut(PoolHitData data) {
        if (!this.dropMessagesAtLimit) {
            try {
                this.hitQueue.put(data);
            }
            catch (InterruptedException t) {
                this.processInterrupted(data);
            }
        } else if (!this.hitQueue.offer(data)) {
            this.processDroppedData(data);
        }
    }

    @Override
    protected void handlePut(StorageData data) {
        if (!this.dropMessagesAtLimit) {
            try {
                this.storageQueue.put(data);
            }
            catch (InterruptedException t) {
                this.processInterrupted(data);
            }
        } else if (!this.storageQueue.offer(data)) {
            this.processDroppedData(data);
        }
    }

    @Override
    protected void initializeInternal() {
    }

    private void processDroppedData(IHistogramData data) {
        this.dropped.incrementAndGet();
        this.logger.info("encountered max queue limit; {} entries have been dropped", (Object)this.dropped.get());
        this.logger.debug("queue limit prevented storage of {}", (Object)data);
    }

    private void processInterrupted(IHistogramData data) {
        this.dropped.incrementAndGet();
        this.logger.warn("queueing of data was interrupted; {} entries have been dropped", (Object)this.dropped.get());
        this.logger.debug("failed to store {}", (Object)data);
    }
}

