/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.db.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Properties;
import org.dcache.services.billing.db.IBillingInfoAccess;
import org.dcache.services.billing.db.exceptions.RetryException;
import org.dcache.services.billing.db.impl.QueueDelegate;
import org.dcache.services.billing.histograms.data.IHistogramData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseBillingInfoAccess
implements IBillingInfoAccess {
    protected static final int DUMMY_VALUE = -1;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Properties properties;
    protected String propertiesPath;
    protected String jdbcDriver;
    protected String jdbcUrl;
    protected String jdbcUser;
    protected String jdbcPassword;
    protected int partitionCount = -1;
    protected int maxConnectionsPerPartition = -1;
    protected int minConnectionsPerPartition = -1;
    private String delegateType;
    private QueueDelegate delegate;
    private int maxQueueSize;
    private int maxBatchSize;
    private boolean dropMessagesAtLimit;

    @Override
    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
        this.logger.trace("close exiting");
    }

    public abstract void commit(Collection<IHistogramData> var1) throws RetryException;

    public long getCommittedMessages() {
        if (this.delegate == null) {
            return 0L;
        }
        return this.delegate.getCommitted();
    }

    public long getDroppedMessages() {
        if (this.delegate == null) {
            return 0L;
        }
        return this.delegate.getDropped();
    }

    public long getInsertQueueSize() {
        if (this.delegate == null) {
            return 0L;
        }
        return this.delegate.getQueueSize();
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void initialize() {
        this.logger.debug("access type: {}", (Object)this.getClass().getName());
        this.properties = new Properties();
        this.initializeInternal();
        if (this.delegateType != null) {
            Class<?> clzz;
            try {
                clzz = Class.forName(this.delegateType);
            }
            catch (ClassNotFoundException t) {
                throw new RuntimeException(t);
            }
            try {
                this.delegate = (QueueDelegate)clzz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException t) {
                throw new RuntimeException(t);
            }
            this.delegate.setDropMessagesAtLimit(this.dropMessagesAtLimit);
            this.delegate.setMaxQueueSize(this.maxQueueSize);
            this.delegate.setMaxBatchSize(this.maxBatchSize);
            this.delegate.setCallback(this);
            this.delegate.initialize();
            this.logger.debug("delegate type: {}", clzz);
        }
    }

    @Override
    public void put(IHistogramData data) {
        if (this.delegate == null) {
            this.logger.warn("attempting to insert data but database access has not been initialized to handle inserts; please set the billing.db.inserts.queue-delegate.type property");
            return;
        }
        this.delegate.handlePut(data);
    }

    public void setDelegateType(String delegateType) {
        this.delegateType = Strings.emptyToNull((String)delegateType);
    }

    public void setDropMessagesAtLimit(boolean dropMessagesAtLimit) {
        this.dropMessagesAtLimit = dropMessagesAtLimit;
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.jdbcDriver = jdbcDriver;
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPassword = jdbcPassword;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUser = jdbcUser;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public void setMaxConnectionsPerPartition(int count) {
        this.maxConnectionsPerPartition = count;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public void setMinConnectionsPerPartition(int count) {
        this.minConnectionsPerPartition = count;
    }

    public void setPartitionCount(int count) {
        this.partitionCount = count;
    }

    public void setPropertiesPath(String propetiesPath) {
        this.propertiesPath = propetiesPath;
    }

    protected abstract void initializeInternal();
}

