/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.db.data;

import diskCacheV111.vehicles.PnfsFileInfoMessage;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jdo.JDOFatalInternalException;
import javax.jdo.PersistenceManager;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dcache.services.billing.histograms.data.IHistogramData;

public abstract class PnfsBaseInfo
implements IHistogramData,
PersistenceCapable {
    private static final long serialVersionUID = 2446765220571171468L;
    static final String DATE_FORMAT = "yyyy/MM/dd hh:MM:ss.SSS";
    protected Date dateStamp = new Date(System.currentTimeMillis());
    protected Integer errorCode = 0;
    protected String cellName;
    protected String action;
    protected String transaction;
    protected String pnfsID;
    protected String errorMessage;
    protected transient StateManager jdoStateManager;
    protected transient byte jdoFlags;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    protected PnfsBaseInfo() {
    }

    protected PnfsBaseInfo(PnfsFileInfoMessage info) {
        this.dateStamp = new Date(info.getTimestamp());
        this.cellName = info.getCellName();
        this.action = info.getMessageType();
        this.transaction = info.getTransaction();
        if (info.getPnfsId() != null) {
            this.pnfsID = info.getPnfsId().getId();
        }
        this.errorCode = info.getResultCode();
        this.errorMessage = info.getMessage();
    }

    public String getCellName() {
        return PnfsBaseInfo.jdoGetcellName(this);
    }

    public void setCellName(String cellName) {
        PnfsBaseInfo.jdoSetcellName(this, cellName);
    }

    public String getAction() {
        return PnfsBaseInfo.jdoGetaction(this);
    }

    public void setAction(String action) {
        PnfsBaseInfo.jdoSetaction(this, action);
    }

    public String getTransaction() {
        return PnfsBaseInfo.jdoGettransaction(this);
    }

    public void setTransaction(String transaction) {
        PnfsBaseInfo.jdoSettransaction(this, transaction);
    }

    public String getPfsID() {
        return PnfsBaseInfo.jdoGetpnfsID(this);
    }

    public void setPnfsID(String pnfsID) {
        PnfsBaseInfo.jdoSetpnfsID(this, pnfsID);
    }

    public Integer getErrorCode() {
        return PnfsBaseInfo.jdoGeterrorCode(this);
    }

    public void setErrorCode(Integer errorCode) {
        PnfsBaseInfo.jdoSeterrorCode(this, errorCode);
    }

    public String getErrorMessage() {
        return PnfsBaseInfo.jdoGeterrorMessage(this);
    }

    public void setErrorMessage(String errorMessage) {
        PnfsBaseInfo.jdoSeterrorMessage(this, errorMessage);
    }

    public Date getDateStamp() {
        return PnfsBaseInfo.jdoGetdateStamp(this);
    }

    public void setDateStamp(Date dateStamp) {
        PnfsBaseInfo.jdoSetdateStamp(this, dateStamp);
    }

    public Date timestamp() {
        return PnfsBaseInfo.jdoGetdateStamp(this);
    }

    @Override
    public Map<String, Double> data() {
        Map<String, Double> dataMap = Collections.synchronizedMap(new HashMap());
        return dataMap;
    }

    protected String dateString() {
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_FORMAT);
        return formatter.format(PnfsBaseInfo.jdoGetdateStamp(this));
    }

    static {
        jdoFieldNames = PnfsBaseInfo.__jdoFieldNamesInit();
        jdoFieldTypes = PnfsBaseInfo.__jdoFieldTypesInit();
        jdoFieldFlags = PnfsBaseInfo.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = PnfsBaseInfo.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = PnfsBaseInfo.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)PnfsBaseInfo.___jdo$loadClass("org.dcache.services.billing.db.data.PnfsBaseInfo"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, null);
    }

    public void jdoCopyKeyFieldsFromObjectId(PersistenceCapable.ObjectIdFieldConsumer fc, Object oid) {
    }

    protected void jdoCopyKeyFieldsFromObjectId(Object oid) {
    }

    public void jdoCopyKeyFieldsToObjectId(Object oid) {
    }

    public void jdoCopyKeyFieldsToObjectId(PersistenceCapable.ObjectIdFieldSupplier fs, Object oid) {
    }

    public final Object jdoGetObjectId() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getObjectId((PersistenceCapable)this);
        }
        return null;
    }

    public final Object jdoGetVersion() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.getVersion((PersistenceCapable)this);
        }
        return null;
    }

    protected final void jdoPreSerialize() {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.preSerialize((PersistenceCapable)this);
        }
    }

    public final PersistenceManager jdoGetPersistenceManager() {
        return this.jdoStateManager != null ? this.jdoStateManager.getPersistenceManager((PersistenceCapable)this) : null;
    }

    public final Object jdoGetTransactionalObjectId() {
        return this.jdoStateManager != null ? this.jdoStateManager.getTransactionalObjectId((PersistenceCapable)this) : null;
    }

    public final boolean jdoIsDeleted() {
        return this.jdoStateManager != null ? this.jdoStateManager.isDeleted((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsDirty() {
        if (this.jdoStateManager != null) {
            return this.jdoStateManager.isDirty((PersistenceCapable)this);
        }
        return false;
    }

    public final boolean jdoIsNew() {
        return this.jdoStateManager != null ? this.jdoStateManager.isNew((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsPersistent() {
        return this.jdoStateManager != null ? this.jdoStateManager.isPersistent((PersistenceCapable)this) : false;
    }

    public final boolean jdoIsTransactional() {
        return this.jdoStateManager != null ? this.jdoStateManager.isTransactional((PersistenceCapable)this) : false;
    }

    public void jdoMakeDirty(String fieldName) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager.makeDirty((PersistenceCapable)this, fieldName);
        }
    }

    public Object jdoNewObjectIdInstance() {
        return null;
    }

    public Object jdoNewObjectIdInstance(Object key) {
        return null;
    }

    public final void jdoProvideFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argment is null");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoProvideField(indices[i]);
            } while (--i >= 0);
        }
    }

    public final void jdoReplaceFields(int[] indices) {
        if (indices == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int i = indices.length;
        if (i > 0) {
            int j = 0;
            do {
                this.jdoReplaceField(indices[j]);
            } while (++j < i);
        }
    }

    public final void jdoReplaceFlags() {
        if (this.jdoStateManager != null) {
            this.jdoFlags = this.jdoStateManager.replacingFlags((PersistenceCapable)this);
        }
    }

    public final synchronized void jdoReplaceStateManager(StateManager sm) {
        if (this.jdoStateManager != null) {
            this.jdoStateManager = this.jdoStateManager.replacingStateManager((PersistenceCapable)this, sm);
        } else {
            JDOImplHelper.checkAuthorizedStateManager((StateManager)sm);
            this.jdoStateManager = sm;
            this.jdoFlags = 1;
        }
    }

    public boolean jdoIsDetached() {
        return false;
    }

    public PersistenceCapable jdoNewInstance(StateManager sm) {
        throw new JDOFatalInternalException("Cannot instantiate abstract class.");
    }

    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        throw new JDOFatalInternalException("Cannot instantiate abstract class.");
    }

    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.action = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.cellName = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.dateStamp = (Date)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.errorCode = (Integer)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.errorMessage = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.pnfsID = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 6: {
                this.transaction = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.action);
                break;
            }
            case 1: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.cellName);
                break;
            }
            case 2: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.dateStamp);
                break;
            }
            case 3: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.errorCode);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.errorMessage);
                break;
            }
            case 5: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.pnfsID);
                break;
            }
            case 6: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.transaction);
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    protected final void jdoCopyField(PnfsBaseInfo obj, int index) {
        switch (index) {
            case 0: {
                this.action = obj.action;
                break;
            }
            case 1: {
                this.cellName = obj.cellName;
                break;
            }
            case 2: {
                this.dateStamp = obj.dateStamp;
                break;
            }
            case 3: {
                this.errorCode = obj.errorCode;
                break;
            }
            case 4: {
                this.errorMessage = obj.errorMessage;
                break;
            }
            case 5: {
                this.pnfsID = obj.pnfsID;
                break;
            }
            case 6: {
                this.transaction = obj.transaction;
                break;
            }
            default: {
                throw new IllegalArgumentException(new StringBuffer("out of field index :").append(index).toString());
            }
        }
    }

    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof PnfsBaseInfo)) {
            throw new IllegalArgumentException("object is not an object of type org.dcache.services.billing.db.data.PnfsBaseInfo");
        }
        PnfsBaseInfo other = (PnfsBaseInfo)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"action", "cellName", "dateStamp", "errorCode", "errorMessage", "pnfsID", "transaction"};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{PnfsBaseInfo.___jdo$loadClass("java.lang.String"), PnfsBaseInfo.___jdo$loadClass("java.lang.String"), PnfsBaseInfo.___jdo$loadClass("java.util.Date"), PnfsBaseInfo.___jdo$loadClass("java.lang.Integer"), PnfsBaseInfo.___jdo$loadClass("java.lang.String"), PnfsBaseInfo.___jdo$loadClass("java.lang.String"), PnfsBaseInfo.___jdo$loadClass("java.lang.String")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 21, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return 0;
    }

    protected static int jdoGetManagedFieldCount() {
        return 7;
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return null;
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        PnfsBaseInfo o = (PnfsBaseInfo)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.jdoPreSerialize();
        out.defaultWriteObject();
    }

    protected static String jdoGetaction(PnfsBaseInfo objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 0, objPC.action);
        }
        return objPC.action;
    }

    protected static void jdoSetaction(PnfsBaseInfo objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0, objPC.action, val);
        } else {
            objPC.action = val;
        }
    }

    protected static String jdoGetcellName(PnfsBaseInfo objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 1, objPC.cellName);
        }
        return objPC.cellName;
    }

    protected static void jdoSetcellName(PnfsBaseInfo objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 1, objPC.cellName, val);
        } else {
            objPC.cellName = val;
        }
    }

    protected static Date jdoGetdateStamp(PnfsBaseInfo objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2)) {
            return (Date)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 2, (Object)objPC.dateStamp);
        }
        return objPC.dateStamp;
    }

    protected static void jdoSetdateStamp(PnfsBaseInfo objPC, Date val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 2, (Object)objPC.dateStamp, (Object)val);
        } else {
            objPC.dateStamp = val;
        }
    }

    protected static Integer jdoGeterrorCode(PnfsBaseInfo objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3)) {
            return (Integer)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 3, (Object)objPC.errorCode);
        }
        return objPC.errorCode;
    }

    protected static void jdoSeterrorCode(PnfsBaseInfo objPC, Integer val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 3, (Object)objPC.errorCode, (Object)val);
        } else {
            objPC.errorCode = val;
        }
    }

    protected static String jdoGeterrorMessage(PnfsBaseInfo objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4, objPC.errorMessage);
        }
        return objPC.errorMessage;
    }

    protected static void jdoSeterrorMessage(PnfsBaseInfo objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4, objPC.errorMessage, val);
        } else {
            objPC.errorMessage = val;
        }
    }

    protected static String jdoGetpnfsID(PnfsBaseInfo objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 5, objPC.pnfsID);
        }
        return objPC.pnfsID;
    }

    protected static void jdoSetpnfsID(PnfsBaseInfo objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 5, objPC.pnfsID, val);
        } else {
            objPC.pnfsID = val;
        }
    }

    protected static String jdoGettransaction(PnfsBaseInfo objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 6)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 6, objPC.transaction);
        }
        return objPC.transaction;
    }

    protected static void jdoSettransaction(PnfsBaseInfo objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 6, objPC.transaction, val);
        } else {
            objPC.transaction = val;
        }
    }
}

