/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.db.data;

import diskCacheV111.vehicles.IpProtocolInfo;
import diskCacheV111.vehicles.MoverInfoMessage;
import diskCacheV111.vehicles.StorageInfo;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.jdo.spi.JDOImplHelper;
import javax.jdo.spi.PersistenceCapable;
import javax.jdo.spi.StateManager;
import org.dcache.services.billing.db.data.PnfsBaseInfo;
import org.dcache.services.billing.db.data.PnfsConnectInfo;
import org.dcache.services.billing.db.data.PnfsStorageInfo;

public final class MoverData
extends PnfsStorageInfo
implements PersistenceCapable {
    private static final long serialVersionUID = 2538217391486197578L;
    public static final String TRANSFER_SIZE = "transferSize";
    private static final String DEFAULT_PROTOCOL = "<unknown>";
    private Long transferSize;
    private Boolean isNew;
    private String client;
    private String protocol;
    private String initiator;
    private Boolean p2p;
    private static final byte[] jdoFieldFlags;
    private static final Class jdoPersistenceCapableSuperclass;
    private static final Class[] jdoFieldTypes;
    private static final String[] jdoFieldNames;
    private static final int jdoInheritedFieldCount;

    public String toString() {
        return "(" + this.dateString() + "," + PnfsBaseInfo.jdoGetcellName(this) + "," + PnfsBaseInfo.jdoGetaction(this) + "," + PnfsBaseInfo.jdoGettransaction(this) + "," + PnfsBaseInfo.jdoGetpnfsID(this) + "," + PnfsStorageInfo.jdoGetfullSize(this) + "," + MoverData.jdoGettransferSize(this) + "," + PnfsStorageInfo.jdoGetstorageClass(this) + "," + MoverData.jdoGetisNew(this) + "," + MoverData.jdoGetclient(this) + "," + PnfsConnectInfo.jdoGetconnectionTime(this) + "," + PnfsBaseInfo.jdoGeterrorCode(this) + "," + PnfsBaseInfo.jdoGeterrorMessage(this) + "," + MoverData.jdoGetprotocol(this) + "," + MoverData.jdoGetinitiator(this) + "," + MoverData.jdoGetp2p(this) + ")";
    }

    public MoverData() {
        this.transferSize = 0L;
        this.isNew = false;
        this.protocol = DEFAULT_PROTOCOL;
        this.client = DEFAULT_PROTOCOL;
        this.p2p = false;
    }

    public MoverData(MoverInfoMessage info) {
        super(info, info.getConnectionTime(), info.getFileSize());
        this.transferSize = info.getDataTransferred();
        this.isNew = info.isFileCreated();
        if (info.getProtocolInfo() instanceof IpProtocolInfo) {
            this.protocol = info.getProtocolInfo().getVersionString();
            this.client = ((IpProtocolInfo)info.getProtocolInfo()).getSocketAddress().getAddress().getHostAddress();
        } else {
            this.protocol = DEFAULT_PROTOCOL;
            this.client = DEFAULT_PROTOCOL;
        }
        StorageInfo sinfo = info.getStorageInfo();
        if (sinfo != null) {
            this.storageClass = sinfo.getStorageClass() + "@" + sinfo.getHsm();
        }
        this.initiator = info.getInitiator();
        this.p2p = info.isP2P();
    }

    public Long getTransferSize() {
        return MoverData.jdoGettransferSize(this);
    }

    public void setTransferSize(Long transferSize) {
        MoverData.jdoSettransferSize(this, transferSize);
    }

    public Boolean getIsNew() {
        return MoverData.jdoGetisNew(this);
    }

    public void setIsNew(Boolean isNew) {
        MoverData.jdoSetisNew(this, isNew);
    }

    public Boolean isP2p() {
        return MoverData.jdoGetp2p(this);
    }

    public void setP2p(Boolean p2p) {
        MoverData.jdoSetp2p(this, p2p);
    }

    public String getClient() {
        return MoverData.jdoGetclient(this);
    }

    public void setClient(String client) {
        MoverData.jdoSetclient(this, client);
    }

    public String getProtocol() {
        return MoverData.jdoGetprotocol(this);
    }

    public void setProtocol(String protocol) {
        MoverData.jdoSetprotocol(this, protocol);
    }

    public String getInitiator() {
        return MoverData.jdoGetinitiator(this);
    }

    public void setInitiator(String initiator) {
        MoverData.jdoSetinitiator(this, initiator);
    }

    @Override
    public Map<String, Double> data() {
        Map<String, Double> dataMap = super.data();
        dataMap.put(TRANSFER_SIZE, MoverData.jdoGettransferSize(this).doubleValue());
        return dataMap;
    }

    static {
        jdoFieldNames = MoverData.__jdoFieldNamesInit();
        jdoFieldTypes = MoverData.__jdoFieldTypesInit();
        jdoFieldFlags = MoverData.__jdoFieldFlagsInit();
        jdoInheritedFieldCount = MoverData.__jdoGetInheritedFieldCount();
        jdoPersistenceCapableSuperclass = MoverData.__jdoPersistenceCapableSuperclassInit();
        JDOImplHelper.registerClass((Class)MoverData.___jdo$loadClass("org.dcache.services.billing.db.data.MoverData"), (String[])jdoFieldNames, (Class[])jdoFieldTypes, (byte[])jdoFieldFlags, (Class)jdoPersistenceCapableSuperclass, (PersistenceCapable)new MoverData());
    }

    @Override
    public boolean jdoIsDetached() {
        return false;
    }

    @Override
    public PersistenceCapable jdoNewInstance(StateManager sm) {
        MoverData result = new MoverData();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        return result;
    }

    @Override
    public PersistenceCapable jdoNewInstance(StateManager sm, Object obj) {
        MoverData result = new MoverData();
        result.jdoFlags = 1;
        result.jdoStateManager = sm;
        result.jdoCopyKeyFieldsFromObjectId(obj);
        return result;
    }

    @Override
    public void jdoReplaceField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - jdoInheritedFieldCount) {
            case 0: {
                this.client = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 1: {
                this.initiator = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 2: {
                this.isNew = (Boolean)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 3: {
                this.p2p = (Boolean)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            case 4: {
                this.protocol = this.jdoStateManager.replacingStringField((PersistenceCapable)this, index);
                break;
            }
            case 5: {
                this.transferSize = (Long)this.jdoStateManager.replacingObjectField((PersistenceCapable)this, index);
                break;
            }
            default: {
                super.jdoReplaceField(index);
            }
        }
    }

    @Override
    public void jdoProvideField(int index) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        switch (index - jdoInheritedFieldCount) {
            case 0: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.client);
                break;
            }
            case 1: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.initiator);
                break;
            }
            case 2: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.isNew);
                break;
            }
            case 3: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.p2p);
                break;
            }
            case 4: {
                this.jdoStateManager.providedStringField((PersistenceCapable)this, index, this.protocol);
                break;
            }
            case 5: {
                this.jdoStateManager.providedObjectField((PersistenceCapable)this, index, (Object)this.transferSize);
                break;
            }
            default: {
                super.jdoProvideField(index);
            }
        }
    }

    protected final void jdoCopyField(MoverData obj, int index) {
        switch (index - jdoInheritedFieldCount) {
            case 0: {
                this.client = obj.client;
                break;
            }
            case 1: {
                this.initiator = obj.initiator;
                break;
            }
            case 2: {
                this.isNew = obj.isNew;
                break;
            }
            case 3: {
                this.p2p = obj.p2p;
                break;
            }
            case 4: {
                this.protocol = obj.protocol;
                break;
            }
            case 5: {
                this.transferSize = obj.transferSize;
                break;
            }
            default: {
                super.jdoCopyField(obj, index);
            }
        }
    }

    @Override
    public void jdoCopyFields(Object obj, int[] indices) {
        if (this.jdoStateManager == null) {
            throw new IllegalStateException("state manager is null");
        }
        if (indices == null) {
            throw new IllegalStateException("fieldNumbers is null");
        }
        if (!(obj instanceof MoverData)) {
            throw new IllegalArgumentException("object is not an object of type org.dcache.services.billing.db.data.MoverData");
        }
        MoverData other = (MoverData)obj;
        if (this.jdoStateManager != other.jdoStateManager) {
            throw new IllegalArgumentException("state managers do not match");
        }
        int i = indices.length - 1;
        if (i >= 0) {
            do {
                this.jdoCopyField(other, indices[i]);
            } while (--i >= 0);
        }
    }

    private static final String[] __jdoFieldNamesInit() {
        return new String[]{"client", "initiator", "isNew", "p2p", "protocol", TRANSFER_SIZE};
    }

    private static final Class[] __jdoFieldTypesInit() {
        return new Class[]{MoverData.___jdo$loadClass("java.lang.String"), MoverData.___jdo$loadClass("java.lang.String"), MoverData.___jdo$loadClass("java.lang.Boolean"), MoverData.___jdo$loadClass("java.lang.Boolean"), MoverData.___jdo$loadClass("java.lang.String"), MoverData.___jdo$loadClass("java.lang.Long")};
    }

    private static final byte[] __jdoFieldFlagsInit() {
        return new byte[]{21, 21, 21, 21, 21, 21};
    }

    protected static int __jdoGetInheritedFieldCount() {
        return PnfsStorageInfo.jdoGetManagedFieldCount();
    }

    protected static int jdoGetManagedFieldCount() {
        return 6 + PnfsStorageInfo.jdoGetManagedFieldCount();
    }

    private static Class __jdoPersistenceCapableSuperclassInit() {
        return MoverData.___jdo$loadClass("org.dcache.services.billing.db.data.PnfsStorageInfo");
    }

    public static Class ___jdo$loadClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
    }

    private Object jdoSuperClone() throws CloneNotSupportedException {
        MoverData o = (MoverData)super.clone();
        o.jdoFlags = 0;
        o.jdoStateManager = null;
        return o;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.jdoPreSerialize();
        out.defaultWriteObject();
    }

    private static String jdoGetclient(MoverData objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 0 + jdoInheritedFieldCount)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 0 + jdoInheritedFieldCount, objPC.client);
        }
        return objPC.client;
    }

    private static void jdoSetclient(MoverData objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 0 + jdoInheritedFieldCount, objPC.client, val);
        } else {
            objPC.client = val;
        }
    }

    private static String jdoGetinitiator(MoverData objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 1 + jdoInheritedFieldCount)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 1 + jdoInheritedFieldCount, objPC.initiator);
        }
        return objPC.initiator;
    }

    private static void jdoSetinitiator(MoverData objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 1 + jdoInheritedFieldCount, objPC.initiator, val);
        } else {
            objPC.initiator = val;
        }
    }

    private static Boolean jdoGetisNew(MoverData objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 2 + jdoInheritedFieldCount)) {
            return (Boolean)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 2 + jdoInheritedFieldCount, (Object)objPC.isNew);
        }
        return objPC.isNew;
    }

    private static void jdoSetisNew(MoverData objPC, Boolean val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 2 + jdoInheritedFieldCount, (Object)objPC.isNew, (Object)val);
        } else {
            objPC.isNew = val;
        }
    }

    private static Boolean jdoGetp2p(MoverData objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 3 + jdoInheritedFieldCount)) {
            return (Boolean)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 3 + jdoInheritedFieldCount, (Object)objPC.p2p);
        }
        return objPC.p2p;
    }

    private static void jdoSetp2p(MoverData objPC, Boolean val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 3 + jdoInheritedFieldCount, (Object)objPC.p2p, (Object)val);
        } else {
            objPC.p2p = val;
        }
    }

    private static String jdoGetprotocol(MoverData objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 4 + jdoInheritedFieldCount)) {
            return objPC.jdoStateManager.getStringField((PersistenceCapable)objPC, 4 + jdoInheritedFieldCount, objPC.protocol);
        }
        return objPC.protocol;
    }

    private static void jdoSetprotocol(MoverData objPC, String val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setStringField((PersistenceCapable)objPC, 4 + jdoInheritedFieldCount, objPC.protocol, val);
        } else {
            objPC.protocol = val;
        }
    }

    private static Long jdoGettransferSize(MoverData objPC) {
        if (objPC.jdoFlags > 0 && objPC.jdoStateManager != null && !objPC.jdoStateManager.isLoaded((PersistenceCapable)objPC, 5 + jdoInheritedFieldCount)) {
            return (Long)objPC.jdoStateManager.getObjectField((PersistenceCapable)objPC, 5 + jdoInheritedFieldCount, (Object)objPC.transferSize);
        }
        return objPC.transferSize;
    }

    private static void jdoSettransferSize(MoverData objPC, Long val) {
        if (objPC.jdoFlags != 0 && objPC.jdoStateManager != null) {
            objPC.jdoStateManager.setObjectField((PersistenceCapable)objPC, 5 + jdoInheritedFieldCount, (Object)objPC.transferSize, (Object)val);
        } else {
            objPC.transferSize = val;
        }
    }
}

