/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.cells;

import com.google.common.io.Files;
import diskCacheV111.poolManager.PoolManagerCellInfo;
import diskCacheV111.util.CacheException;
import dmg.cells.nucleus.CellAddressCore;
import dmg.cells.nucleus.CellPath;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Map;
import org.dcache.cells.CellStub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PoolStatusCollector
extends Thread {
    private static final Logger _log = LoggerFactory.getLogger(PoolStatusCollector.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final File _report;
    private final CellStub _poolManagerStub;

    public PoolStatusCollector(CellStub poolManagerStub, File file) {
        this._poolManagerStub = poolManagerStub;
        this._report = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PrintWriter pw;
        try {
            pw = new PrintWriter(Files.newWriter((File)this._report, (Charset)UTF8));
        }
        catch (IOException ioe) {
            _log.warn("Problem opening {} : {}", (Object)this._report, (Object)ioe.getMessage());
            return;
        }
        try {
            PoolManagerCellInfo info = this._poolManagerStub.sendAndWait((Serializable)((Object)"xgetcellinfo"), PoolManagerCellInfo.class);
            for (Map.Entry pool : info.getPoolMap().entrySet()) {
                try {
                    String s = this._poolManagerStub.sendAndWait(new CellPath((CellAddressCore)pool.getValue()), (Serializable)((Object)"rep ls -s"), String.class);
                    for (String line : s.split("\n")) {
                        pw.println((String)pool.getKey() + "  " + line);
                    }
                }
                catch (CacheException | InterruptedException t) {
                    _log.warn("CollectPoolStatus : {}: {}", pool.getValue(), (Object)t.toString());
                }
            }
        }
        catch (CacheException | InterruptedException t) {
            _log.warn("Exception in CollectPools status : {}", (Object)t.toString());
            if (!this._report.delete()) {
                _log.warn("Could not delete report: {}", (Object)this._report);
            }
        }
        finally {
            pw.close();
        }
    }
}

