/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.services.billing.cells;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import diskCacheV111.cells.DateRenderer;
import diskCacheV111.vehicles.InfoMessage;
import diskCacheV111.vehicles.MoverInfoMessage;
import diskCacheV111.vehicles.PnfsFileInfoMessage;
import diskCacheV111.vehicles.StorageInfo;
import diskCacheV111.vehicles.WarningPnfsFileInfoMessage;
import dmg.cells.nucleus.CellInfo;
import dmg.cells.nucleus.EnvironmentAware;
import dmg.util.Args;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellInfoProvider;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.CellStub;
import org.dcache.services.billing.cells.PoolStatusCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.stringtemplate.v4.AttributeRenderer;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;

public final class BillingCell
implements CellMessageReceiver,
CellCommandListener,
CellInfoProvider,
EnvironmentAware {
    private static final Logger _log = LoggerFactory.getLogger(BillingCell.class);
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private final SimpleDateFormat _formatter = new SimpleDateFormat("MM.dd HH:mm:ss");
    private final SimpleDateFormat _fileNameFormat = new SimpleDateFormat("yyyy.MM.dd");
    private final SimpleDateFormat _directoryNameFormat = new SimpleDateFormat("yyyy" + File.separator + "MM");
    private final STGroup _templateGroup = new STGroup('$', '$');
    private final Map<String, int[]> _map = Maps.newHashMap();
    private final Map<String, long[]> _poolStatistics = Maps.newHashMap();
    private final Map<String, Map<String, long[]>> _poolStorageMap = Maps.newHashMap();
    private int _requests;
    private int _failed;
    private File _currentDbFile;
    private Map<String, Object> _environment;
    private CellStub _poolManagerStub;
    private File _logsDir;
    private int _printMode;
    private boolean _disableTxt;
    private static final Function<Map.Entry<String, int[]>, Object[]> toPair = new Function<Map.Entry<String, int[]>, Object[]>(){

        public Object[] apply(Map.Entry<String, int[]> entry) {
            return new Object[]{entry.getKey(), Arrays.copyOf(entry.getValue(), 2)};
        }
    };
    public static final String hh_get_pool_statistics = "[<poolName>]";
    public static final String hh_clear_pool_statistics = "";
    public static final String hh_dump_pool_statistics = "[<fileName>]";
    public static final String hh_get_poolstatus = "[<fileName>]";

    public BillingCell() {
        this._templateGroup.registerRenderer(Date.class, (AttributeRenderer)new DateRenderer());
    }

    public void setEnvironment(Map<String, Object> environment) {
        this._environment = environment;
    }

    public String toString() {
        return "Req=" + this._requests + ";Err=" + this._failed + ";";
    }

    @Override
    public CellInfo getCellInfo(CellInfo info) {
        return info;
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.format("%20s : %6d / %d\n", "Requests", this._requests, this._failed);
        for (Map.Entry<String, int[]> entry : this._map.entrySet()) {
            int[] values = entry.getValue();
            pw.format("%20s : %6d / %d\n", entry.getKey(), values[0], values[1]);
        }
    }

    public void messageArrived(InfoMessage info) {
        String output;
        if (info.getMessageType().equals("check")) {
            return;
        }
        this.updateMap(info);
        if (info.getCellType().equals("pool")) {
            this.doStatistics(info);
        }
        if ((output = this.getFormattedMessage(info)).isEmpty()) {
            return;
        }
        _log.info(output);
        if (!this._disableTxt) {
            String ext = this.getFilenameExtension(new Date(info.getTimestamp()));
            this.logInfo(output, ext);
            if (info.getResultCode() != 0) {
                this.logError(output, ext);
            }
        }
    }

    public void messageArrived(Object msg) {
        Date now = new Date();
        String output = this._formatter.format(now) + " " + msg.toString();
        _log.info(output);
        if (!this._disableTxt) {
            this.logInfo(output, this.getFilenameExtension(now));
        }
    }

    private String getFormattedMessage(InfoMessage msg) {
        String property = "billing.format." + msg.getClass().getSimpleName();
        Object format = this._environment.get(property);
        if (format == null) {
            return msg.toString();
        }
        ST template = new ST(this._templateGroup, format.toString());
        msg.fillTemplate(template);
        return template.render();
    }

    public Object[][] ac_get_billing_info(Args args) {
        return (Object[][])Iterables.toArray((Iterable)Iterables.transform(this._map.entrySet(), toPair), Object[].class);
    }

    public Map<String, long[]> ac_get_pool_statistics_$_0_1(Args args) {
        if (args.argc() == 0) {
            return this._poolStatistics;
        }
        Map<String, long[]> map = this._poolStorageMap.get(args.argv(0));
        if (map != null) {
            return map;
        }
        return Maps.newHashMap();
    }

    public String ac_clear_pool_statistics(Args args) {
        this._poolStatistics.clear();
        this._poolStorageMap.clear();
        return hh_clear_pool_statistics;
    }

    public String ac_dump_pool_statistics_$_0_1(Args args) throws IOException {
        this.dumpPoolStatistics(args.argc() == 0 ? null : args.argv(0));
        return hh_clear_pool_statistics;
    }

    public String ac_get_poolstatus_$_0_1(Args args) {
        String name = args.argc() == 0 ? "poolStatus-" + this._fileNameFormat.format(new Date()) : args.argv(0);
        File file = new File(this._logsDir, name);
        PoolStatusCollector collector = new PoolStatusCollector(this._poolManagerStub, file);
        collector.setName(name);
        collector.start();
        return file.toString();
    }

    private void dumpPoolStatistics(String name) throws IOException {
        if (name == null) {
            name = "poolFlow-" + this._fileNameFormat.format(new Date());
        }
        File report = new File(this._logsDir, name);
        try (PrintWriter pw = new PrintWriter(Files.newWriter((File)report, (Charset)UTF8));){
            Set<Map.Entry<String, Map<String, long[]>>> pools = this._poolStorageMap.entrySet();
            for (Map.Entry<String, Map<String, long[]>> poolEntry : pools) {
                String poolName = poolEntry.getKey();
                Map<String, long[]> map = poolEntry.getValue();
                for (Map.Entry<String, long[]> entry : map.entrySet()) {
                    String className = entry.getKey();
                    long[] counters = entry.getValue();
                    pw.print(poolName);
                    pw.print("  ");
                    pw.print(className);
                    for (long counter : counters) {
                        pw.print("  " + counter);
                    }
                    pw.println(hh_clear_pool_statistics);
                }
            }
        }
        catch (RuntimeException e) {
            _log.warn("Exception in dumpPoolStatistics : {}", (Throwable)e);
            if (!report.delete()) {
                _log.warn("Could not delete report: {}", (Object)report);
            }
            throw e;
        }
    }

    private void updateMap(InfoMessage info) {
        String key = info.getMessageType() + ":" + info.getCellType();
        int[] values = this._map.get(key);
        if (values == null) {
            values = new int[2];
            this._map.put(key, values);
        }
        values[0] = values[0] + 1;
        ++this._requests;
        if (info.getResultCode() != 0) {
            ++this._failed;
            values[1] = values[1] + 1;
        }
    }

    private String getFilenameExtension(Date dateOfEvent) {
        if (this._printMode == 0) {
            this._currentDbFile = this._logsDir;
            return this._fileNameFormat.format(dateOfEvent);
        }
        Date now = new Date();
        this._currentDbFile = new File(this._logsDir, this._directoryNameFormat.format(now));
        if (!this._currentDbFile.exists() && !this._currentDbFile.mkdirs()) {
            _log.error("Failed to create directory {}", (Object)this._currentDbFile);
        }
        return this._fileNameFormat.format(now);
    }

    private void logInfo(String output, String ext) {
        File outputFile = new File(this._currentDbFile, "billing-" + ext);
        try {
            Files.append((CharSequence)(output + "\n"), (File)outputFile, (Charset)UTF8);
        }
        catch (IOException e) {
            _log.warn("Can't write billing [{}] : {}", (Object)outputFile, (Object)e.toString());
        }
    }

    private void logError(String output, String ext) {
        File errorFile = new File(this._currentDbFile, "billing-error-" + ext);
        try {
            Files.append((CharSequence)(output + "\n"), (File)errorFile, (Charset)UTF8);
        }
        catch (IOException e) {
            _log.warn("Can't write billing-error : {}", (Object)e.toString());
        }
    }

    private void doStatistics(InfoMessage info) {
        PnfsFileInfoMessage pnfsInfo;
        StorageInfo sinfo;
        if (info instanceof WarningPnfsFileInfoMessage) {
            return;
        }
        String cellName = info.getCellName();
        int pos = cellName.indexOf("@");
        cellName = pos < 1 ? cellName : cellName.substring(0, pos);
        String transactionType = info.getMessageType();
        long[] counters = this._poolStatistics.get(cellName);
        if (counters == null) {
            counters = new long[4];
            this._poolStatistics.put(cellName, counters);
        }
        if (info.getResultCode() != 0) {
            counters[3] = counters[3] + 1L;
        } else if (transactionType.equals("transfer")) {
            counters[0] = counters[0] + 1L;
        } else if (transactionType.equals("restore")) {
            counters[1] = counters[1] + 1L;
        } else if (transactionType.equals("store")) {
            counters[2] = counters[2] + 1L;
        }
        if (info instanceof PnfsFileInfoMessage && (sinfo = (pnfsInfo = (PnfsFileInfoMessage)info).getStorageInfo()) != null) {
            String key;
            HashMap map = this._poolStorageMap.get(cellName);
            if (map == null) {
                map = Maps.newHashMap();
                this._poolStorageMap.put(cellName, map);
            }
            if ((counters = (long[])map.get(key = sinfo.getStorageClass() + "@" + sinfo.getHsm())) == null) {
                counters = new long[8];
                map.put(key, counters);
            }
            if (info.getResultCode() != 0) {
                counters[3] = counters[3] + 1L;
            } else if (transactionType.equals("transfer")) {
                counters[0] = counters[0] + 1L;
                MoverInfoMessage mim = (MoverInfoMessage)info;
                int n = mim.isFileCreated() ? 4 : 5;
                counters[n] = counters[n] + mim.getDataTransferred();
            } else if (transactionType.equals("restore")) {
                counters[1] = counters[1] + 1L;
                counters[6] = counters[6] + pnfsInfo.getFileSize();
            } else if (transactionType.equals("store")) {
                counters[2] = counters[2] + 1L;
                counters[7] = counters[7] + pnfsInfo.getFileSize();
            }
        }
    }

    @Required
    public void setPoolManagerStub(CellStub poolManagerStub) {
        this._poolManagerStub = poolManagerStub;
    }

    @Required
    public void setLogsDir(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("No such directory: " + dir);
        }
        if (!dir.canWrite()) {
            throw new IllegalArgumentException("Directory not writable: " + dir);
        }
        this._logsDir = dir;
    }

    public void setPrintMode(int printMode) {
        this._printMode = printMode;
    }

    @Required
    public void setDisableTxt(boolean disableTxt) {
        this._disableTxt = disableTxt;
    }
}

