/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.poolmanager;

import diskCacheV111.util.CacheException;
import diskCacheV111.vehicles.PoolManagerGetPoolMonitor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.CellStub;
import org.dcache.poolmanager.PoolMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class RemotePoolMonitorInvocationHandler
implements InvocationHandler {
    private static final Logger _log = LoggerFactory.getLogger(RemotePoolMonitorInvocationHandler.class);
    private static final long INIT_DELAY = TimeUnit.MILLISECONDS.toMillis(10L);
    private long _refreshDelay = TimeUnit.SECONDS.toMillis(20L);
    private CellStub _poolManagerStub;
    private ScheduledExecutorService _executor;
    private PoolMonitor _poolMonitor;

    @Required
    public void setPoolManagerStub(CellStub stub) {
        this._poolManagerStub = stub;
    }

    @Required
    public void setExecutor(ScheduledExecutorService executor) {
        this._executor = executor;
    }

    public long getRefreshDelay() {
        return this._refreshDelay;
    }

    public void setRefreshDelay(long refreshDelay) {
        this._refreshDelay = refreshDelay;
    }

    private synchronized void setPoolMonitor(PoolMonitor poolMonitor) {
        this._poolMonitor = poolMonitor;
        this.notify();
    }

    private synchronized PoolMonitor getPoolMonitor() throws InterruptedException {
        while (this._poolMonitor == null) {
            this.wait();
        }
        return this._poolMonitor;
    }

    public void init() throws InterruptedException {
        this.initPoolMonitor();
        this.scheduleUpdateTask();
    }

    private void initPoolMonitor() throws InterruptedException {
        while (true) {
            try {
                this.setPoolMonitor(this._poolManagerStub.sendAndWait(new PoolManagerGetPoolMonitor()).getPoolMonitor());
            }
            catch (CacheException e) {
                _log.error(e.toString());
                Thread.sleep(INIT_DELAY);
                continue;
            }
            break;
        }
    }

    private void scheduleUpdateTask() {
        this._executor.scheduleWithFixedDelay(new UpdatePoolMonitorTask(), this._refreshDelay / 2L, this._refreshDelay, TimeUnit.MILLISECONDS);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return method.invoke((Object)this.getPoolMonitor(), args);
    }

    private class UpdatePoolMonitorTask
    extends AbstractMessageCallback<PoolManagerGetPoolMonitor>
    implements Runnable {
        private UpdatePoolMonitorTask() {
        }

        @Override
        public void run() {
            RemotePoolMonitorInvocationHandler.this._poolManagerStub.send(new PoolManagerGetPoolMonitor(), PoolManagerGetPoolMonitor.class, this);
        }

        @Override
        public void success(PoolManagerGetPoolMonitor message) {
            RemotePoolMonitorInvocationHandler.this.setPoolMonitor(message.getPoolMonitor());
        }

        @Override
        public void failure(int rc, Object error) {
            _log.warn("Failed to update pool monitor: {} [{}]", error, (Object)rc);
        }
    }
}

