/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.poolmanager;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import diskCacheV111.poolManager.CostModule;
import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.util.CacheException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.dcache.poolmanager.Partition;
import org.dcache.poolmanager.PoolInfo;
import org.dcache.vehicles.FileAttributes;

public class RandomPartition
extends Partition {
    private static final long serialVersionUID = -2614882036844578650L;
    static final String TYPE = "random";
    public static final Random random = new Random();

    public RandomPartition(Map<String, String> inherited) {
        this(inherited, NO_PROPERTIES);
    }

    public RandomPartition(Map<String, String> inherited, Map<String, String> properties) {
        super(NO_PROPERTIES, inherited, properties);
    }

    @Override
    protected Partition create(Map<String, String> inherited, Map<String, String> properties) {
        return new RandomPartition(inherited, properties);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    private Predicate<PoolInfo> canHoldFile(final long size) {
        return new Predicate<PoolInfo>(){

            public boolean apply(PoolInfo pool) {
                PoolCostInfo.PoolSpaceInfo space = pool.getCostInfo().getSpaceInfo();
                long available = space.getFreeSpace() + space.getRemovableSpace();
                return available - size > space.getGap();
            }
        };
    }

    private PoolInfo select(List<PoolInfo> pools) {
        return pools.get(random.nextInt(pools.size()));
    }

    @Override
    public PoolInfo selectWritePool(CostModule cm, List<PoolInfo> pools, FileAttributes attributes, long preallocated) throws CacheException {
        ArrayList freePools = Lists.newArrayList((Iterable)Iterables.filter(pools, this.canHoldFile(preallocated)));
        if (freePools.isEmpty()) {
            throw new CacheException(21, "All pools are full");
        }
        return this.select(freePools);
    }

    @Override
    public PoolInfo selectReadPool(CostModule cm, List<PoolInfo> pools, FileAttributes attributes) throws CacheException {
        return this.select(pools);
    }

    @Override
    public Partition.P2pPair selectPool2Pool(CostModule cm, List<PoolInfo> src, List<PoolInfo> dst, FileAttributes attributes, boolean force) throws CacheException {
        return new Partition.P2pPair(this.select(src), this.selectWritePool(cm, dst, attributes, attributes.getSize()));
    }

    @Override
    public PoolInfo selectStagePool(CostModule cm, List<PoolInfo> pools, String previousPool, String previousHost, FileAttributes attributes) throws CacheException {
        return this.selectWritePool(cm, pools, attributes, attributes.getSize());
    }
}

