/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.poolmanager;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import dmg.util.Args;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.Set;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellSetupProvider;
import org.dcache.poolmanager.ClassicPartition;
import org.dcache.poolmanager.Partition;
import org.dcache.poolmanager.PartitionFactory;

public class PartitionManager
implements Serializable,
CellCommandListener,
CellSetupProvider {
    private static final long serialVersionUID = 3245564135066081407L;
    private static final String DEFAULT = "default";
    private static final ServiceLoader<PartitionFactory> _factories = ServiceLoader.load(PartitionFactory.class);
    private static final Function<PartitionFactory, String> getType = new Function<PartitionFactory, String>(){

        public String apply(PartitionFactory factory) {
            return factory.getType();
        }
    };
    private ImmutableMap<String, String> _inheritedProperties = ImmutableMap.of();
    private volatile boolean _hasImplicitDefaultPartition;
    private volatile ImmutableMap<String, Partition> _partitions = ImmutableMap.of();
    public static final String fh_pmx_get_map = "Name:\n    pmx get map - get partition map\n\nSynopsis:\n    pmx get map\n\nDescription:\n    Internal command to query the internal representation of all\n    partitions.\n";
    public static final String hh_pmx_get_map = "# get partition map";
    public static final String fh_pm_set = "Name:\n    pm set - set partition parameters\n\nSynopsis:\n    pm set [<partition>] OPTION...\n\nDescription:\n    Set one or more parameters on a partition.\n\n    If no partition name is provided, then the set of inherited\n    parameters is updated. These parameters are inherited by all\n    partitions except for those that explicitly redefine the\n    parameters.\n\n    Setting a parameter to the value 'off' resets it back to\n    inherited value or back to the default parameter value.\n\n    Available parameters depend on the partition type. Use\n    'pm ls -a' to see available parameters and their current\n    value. A small set of parameters are common to all partition\n    types. These are:\n\n       -p2p-allowed=yes|no|off\n       -p2p-oncost=yes|no|off\n       -p2p-fortransfer=yes|no|off\n       -stage-allowed=yes|no|off\n       -stage-oncost=yes|no|off\n";
    public static final String hh_pm_set = "[<partition>] OPTION... # set partition parameters";
    public static final String fh_pm_types = "Name:\n    pm types - list available partition types\n\nSynopsis:\n    pm types\n\nDescription:\n    List partition types that can be used when creating new\n    partitions. The pool selection algorithm, the configuration\n    parameters, and the default values are defined by the\n    partition type.\n\n    Partition types are pluggable and new partition types can\n    be added through a plugin mechanism.";
    public static final String hh_pm_types = "# list available partition types";
    public static final String hh_pm_create = "[-type=<type>] <partition> # create new partition";
    public static final String fh_pm_create = "Name:\n    pm create - create new partition\n\nSynopsis:\n    pm create [-type=<type>] <partition>\n\nDescription:\n    Creates a pool manager partition named <partition> of <type>.\n    If no <type> is specified then 'classic' is used as a default\n    type.\n\n    A partition encapsulates configuration parameters and pool\n    selection logic. Each pool manager link identifies a partition\n    to use for transfers in that link.\n\n    The partition type defines the pool selection logic and the\n    available configuration parameters. 'pm types' lists available\n    partition types.\n    A default partition named 'default' exists and is used for\n    links that do not explicitly define which partition to use.\n    Creating a partition reusing an existing name overwrites that\n    partition. This allows the type of the default partition to be\n    redefined. Any parameter values on the partition are lost.";
    public static final String fh_pm_destroy = "Name:\n    pm destroy - remove partition\n\nSynopsis:\n    pm destroy <partition>\n\nDescription:\n    Remove the specified pool manager partition. Links using the\n    partition will fall back to the default partition. Any\n    parameter values associated with the partition are lost.";
    public static final String hh_pm_destroy = "<partition> # remove partition";
    public static final String fh_pm_ls = "Name:\n    pm ls - list partitions\n\nSynopsis:\n    pm ls [-l] [-a] [<partition>]\n\nDescription:\n    List information about the <partition>. If no <partition> is\n    specified then information about all partitions is given.\n\n    -l  List parameters (default when <partition> is specified).\n    -a  List all parameters. The default is not to list inherited\n        and default parameters.\n";
    public static final String hh_pm_ls = "[-l] [-a] [<partition>] # list partitions";

    public PartitionManager() {
        this.clear();
    }

    public synchronized void clear() {
        this._hasImplicitDefaultPartition = true;
        this._inheritedProperties = ImmutableMap.of();
        this._partitions = ImmutableMap.of((Object)DEFAULT, (Object)new ClassicPartition());
    }

    private PartitionFactory getFactory(String type) throws NoSuchElementException {
        return (PartitionFactory)Iterables.find(_factories, (Predicate)Predicates.compose((Predicate)Predicates.equalTo((Object)type), getType));
    }

    private Function<Partition, Partition> updateInherited(final Map<String, String> properties) {
        return new Function<Partition, Partition>(){

            public Partition apply(Partition partition) {
                return partition.updateInherited(properties);
            }
        };
    }

    public synchronized void setProperties(String name, Map<String, String> properties) throws IllegalArgumentException {
        if (name == null || this._hasImplicitDefaultPartition && name.equals(DEFAULT)) {
            this._inheritedProperties = ImmutableMap.builder().putAll(Maps.filterKeys(this._inheritedProperties, (Predicate)Predicates.not((Predicate)Predicates.in(properties.keySet())))).putAll(Maps.filterValues(properties, (Predicate)Predicates.notNull())).build();
            this._partitions = ImmutableMap.copyOf((Map)Maps.transformValues(this._partitions, this.updateInherited((Map<String, String>)this._inheritedProperties)));
        } else if (this._partitions.containsKey((Object)name)) {
            this._partitions = ImmutableMap.builder().putAll(Maps.filterKeys(this._partitions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)name)))).put((Object)name, (Object)((Partition)this._partitions.get((Object)name)).updateProperties(properties)).build();
        } else {
            throw new IllegalArgumentException("No such partition: " + name);
        }
    }

    public synchronized void createPartition(PartitionFactory factory, String name) throws IllegalArgumentException, NoSuchElementException {
        Partition partition = factory.createPartition((Map<String, String>)this._inheritedProperties);
        this._partitions = ImmutableMap.builder().putAll(Maps.filterKeys(this._partitions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)name)))).put((Object)name, (Object)partition).build();
        if (name.equals(DEFAULT)) {
            this._hasImplicitDefaultPartition = false;
        }
    }

    public synchronized void destroyPartition(String name) throws IllegalArgumentException {
        if (name.equals(DEFAULT)) {
            throw new IllegalArgumentException("Cannot destroy default partition");
        }
        if (!this._partitions.containsKey((Object)name)) {
            throw new IllegalArgumentException("No such partition: " + name);
        }
        this._partitions = ImmutableMap.builder().putAll(Maps.filterKeys(this._partitions, (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)name)))).build();
    }

    public Partition getDefaultPartition() {
        return (Partition)this._partitions.get((Object)DEFAULT);
    }

    public Partition getPartition(String name) {
        if (name == null) {
            return this.getDefaultPartition();
        }
        Partition partition = (Partition)this._partitions.get((Object)name);
        if (partition == null) {
            return this.getDefaultPartition();
        }
        return partition;
    }

    public Object ac_pmx_get_map(Args args) {
        return this._partitions;
    }

    public ImmutableMap<String, Partition> getPartitions() {
        return this._partitions;
    }

    public String ac_pm_set_$_0_1(Args args) throws IllegalArgumentException {
        this.setProperties(args.argv(0), this.scanProperties(args));
        return "";
    }

    public String ac_pm_types_$_0(Args args) {
        String format = "%-16s %s\n";
        Formatter s = new Formatter(new StringBuilder());
        s.format("%-16s %s\n", "Partition type", "Description");
        s.format("%-16s %s\n", "--------------", "-----------");
        for (PartitionFactory factory : _factories) {
            s.format("%-16s %s\n", factory.getType(), factory.getDescription());
        }
        return s.toString();
    }

    public String ac_pm_create_$_1(Args args) {
        String type = args.getOption("type");
        PartitionFactory factory = this.getFactory(type == null ? "classic" : type);
        this.createPartition(factory, args.argv(0));
        return "";
    }

    public String ac_pm_destroy_$_1(Args args) {
        this.destroyPartition(args.argv(0));
        return "";
    }

    public String ac_pm_ls_$_0_1(Args args) throws IllegalArgumentException {
        boolean showAll = args.hasOption("a");
        StringBuilder sb = new StringBuilder();
        if (args.argc() != 0) {
            String name = args.argv(0);
            Partition partition = (Partition)this._partitions.get((Object)name);
            if (partition == null) {
                throw new IllegalArgumentException("Partition not found: " + name);
            }
            sb.append(name).append(" (").append(partition.getType()).append(")\n");
            this.printProperties(sb, partition, showAll);
        } else {
            boolean showProperties;
            boolean bl = showProperties = args.hasOption("l") || showAll;
            if (showProperties) {
                this.printInheritedProperties(sb);
            }
            for (Map.Entry entry : this._partitions.entrySet()) {
                sb.append((String)entry.getKey()).append(" (").append(((Partition)entry.getValue()).getType()).append(")\n");
                if (!showProperties) continue;
                this.printProperties(sb, (Partition)entry.getValue(), showAll);
            }
        }
        return sb.toString();
    }

    private void printInheritedProperties(StringBuilder sb) {
        ImmutableSet keys = this._inheritedProperties.keySet();
        sb.append("Inherited by all partitions\n");
        for (String key : Ordering.natural().sortedCopy((Iterable)keys)) {
            sb.append("    -").append(key).append("=").append((String)this._inheritedProperties.get((Object)key)).append("\n");
        }
    }

    private void printProperties(StringBuilder sb, Partition partition, boolean showAll) {
        Set<String> all = partition.getAllProperties().keySet();
        Set<String> defined = partition.getProperties().keySet();
        for (String key : Ordering.natural().sortedCopy(all)) {
            if (!defined.contains(key) && !showAll) continue;
            sb.append("    -").append(key).append("=").append(partition.getProperty(key));
            if (defined.contains(key)) {
                sb.append("\n");
                continue;
            }
            if (this._inheritedProperties.containsKey((Object)key)) {
                sb.append(" [inherited]\n");
                continue;
            }
            sb.append(" [default]\n");
        }
    }

    private Map<String, String> scanProperties(Args args) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : args.optionsAsMap().entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value.equals("off")) {
                map.put(key, null);
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    @Override
    public void beforeSetup() {
        this.clear();
    }

    @Override
    public void afterSetup() {
    }

    @Override
    public synchronized void printSetup(PrintWriter pw) {
        this.dumpInfo(pw, "", (Map<String, String>)this._inheritedProperties);
        for (Map.Entry entry : this._partitions.entrySet()) {
            pw.format("pm create -type=%s %s\n", ((Partition)entry.getValue()).getType(), entry.getKey());
            this.dumpInfo(pw, (String)entry.getKey(), ((Partition)entry.getValue()).getProperties());
        }
    }

    private void dumpInfo(PrintWriter pw, String name, Map<String, String> properties) {
        if (!properties.isEmpty()) {
            pw.append("pm set");
            if (!name.isEmpty()) {
                pw.append(" ").append(name);
            }
            for (Map.Entry<String, String> entry : properties.entrySet()) {
                pw.append(" -").append(entry.getKey()).append("=").append(entry.getValue());
            }
            pw.println();
        }
    }
}

