/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.poolmanager;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import diskCacheV111.poolManager.CostModule;
import diskCacheV111.util.CacheException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.dcache.poolmanager.PoolInfo;
import org.dcache.vehicles.FileAttributes;

public abstract class Partition
implements Serializable {
    private static final long serialVersionUID = -4195341006626972862L;
    protected static final Map<String, String> NO_PROPERTIES = ImmutableMap.of();
    private final Map<String, String> DEFAULTS = ImmutableMap.builder().put((Object)"p2p-allowed", (Object)"yes").put((Object)"p2p-oncost", (Object)"no").put((Object)"p2p-fortransfer", (Object)"no").put((Object)"stage-allowed", (Object)"no").put((Object)"stage-oncost", (Object)"no").build();
    private final ImmutableMap<String, String> _defaults;
    private final ImmutableMap<String, String> _inherited;
    private final ImmutableMap<String, String> _defined;
    public final boolean _p2pAllowed;
    public final boolean _p2pOnCost;
    public final boolean _p2pForTransfer;
    public final boolean _hasHsmBackend;
    public final boolean _stageOnCost;

    protected Partition(Map<String, String> defaults, Map<String, String> inherited, Map<String, String> defined) {
        this._defaults = ImmutableMap.builder().putAll(this.DEFAULTS).putAll(defaults).build();
        this._inherited = ImmutableMap.copyOf((Map)Maps.filterKeys(inherited, (Predicate)Predicates.in((Collection)this._defaults.keySet())));
        this._defined = ImmutableMap.copyOf((Map)Maps.filterKeys(defined, (Predicate)Predicates.in((Collection)this._defaults.keySet())));
        this._p2pAllowed = this.getBoolean("p2p-allowed");
        this._p2pOnCost = this.getBoolean("p2p-oncost");
        this._p2pForTransfer = this.getBoolean("p2p-fortransfer");
        this._hasHsmBackend = this.getBoolean("stage-allowed");
        this._stageOnCost = this.getBoolean("stage-oncost");
    }

    protected abstract Partition create(Map<String, String> var1, Map<String, String> var2);

    public Map<String, String> getProperties() {
        return this._defined;
    }

    public Map<String, String> getAllProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.putAll((Map<String, String>)this._defaults);
        map.putAll((Map<String, String>)this._inherited);
        map.putAll((Map<String, String>)this._defined);
        return map;
    }

    public Partition updateProperties(Map<String, String> defined) {
        ImmutableMap map = ImmutableMap.builder().putAll(Maps.filterKeys(this._defined, (Predicate)Predicates.not((Predicate)Predicates.in(defined.keySet())))).putAll(Maps.filterValues(defined, (Predicate)Predicates.notNull())).build();
        return this.create((Map<String, String>)this._inherited, (Map<String, String>)map);
    }

    public Partition updateInherited(Map<String, String> inherited) {
        return this.create(inherited, (Map<String, String>)this._defined);
    }

    public String getProperty(String name) throws NoSuchElementException {
        String value = (String)this._defined.get((Object)name);
        if (value == null) {
            value = (String)this._inherited.get((Object)name);
        }
        if (value == null) {
            value = (String)this._defaults.get((Object)name);
        }
        if (value == null) {
            throw new NoSuchElementException("No such property: " + name);
        }
        return value;
    }

    public boolean getBoolean(String name) throws NoSuchElementException, IllegalArgumentException {
        String value;
        switch (value = this.getProperty(name)) {
            case "yes": {
                return true;
            }
            case "no": {
                return false;
            }
        }
        throw new IllegalArgumentException("Boolean property " + name + " has invalid value: " + value);
    }

    public long getLong(String name) throws NoSuchElementException, IllegalArgumentException {
        return Long.parseLong(this.getProperty(name));
    }

    public double getDouble(String name) throws NoSuchElementException, IllegalArgumentException {
        return Double.parseDouble(this.getProperty(name));
    }

    public synchronized Map<String, Object[]> toMap() {
        HashMap<String, Object[]> map = new HashMap<String, Object[]>();
        for (Map.Entry entry : this._defaults.entrySet()) {
            map.put((String)entry.getKey(), new Object[]{false, entry.getValue()});
        }
        for (Map.Entry entry : this._inherited.entrySet()) {
            map.put((String)entry.getKey(), new Object[]{false, entry.getValue()});
        }
        for (Map.Entry entry : this._defined.entrySet()) {
            map.put((String)entry.getKey(), new Object[]{true, entry.getValue()});
        }
        return map;
    }

    public boolean getP2PAllowed() {
        return this._p2pAllowed;
    }

    public boolean getP2POnCost() {
        return this._p2pOnCost;
    }

    public boolean getP2PForTransfer() {
        return this._p2pForTransfer;
    }

    public boolean getHasHsmBackend() {
        return this._hasHsmBackend;
    }

    public boolean getStageOnCost() {
        return this._stageOnCost;
    }

    public abstract String getType();

    public abstract PoolInfo selectWritePool(CostModule var1, List<PoolInfo> var2, FileAttributes var3, long var4) throws CacheException;

    public abstract PoolInfo selectReadPool(CostModule var1, List<PoolInfo> var2, FileAttributes var3) throws CacheException;

    public abstract P2pPair selectPool2Pool(CostModule var1, List<PoolInfo> var2, List<PoolInfo> var3, FileAttributes var4, boolean var5) throws CacheException;

    public abstract PoolInfo selectStagePool(CostModule var1, List<PoolInfo> var2, String var3, String var4, FileAttributes var5) throws CacheException;

    public static class P2pPair {
        public final PoolInfo source;
        public final PoolInfo destination;

        public P2pPair(PoolInfo source, PoolInfo destination) {
            this.source = source;
            this.destination = destination;
        }
    }
}

