/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.v5;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.DiskErrorCacheException;
import diskCacheV111.util.FileCorruptedCacheException;
import diskCacheV111.util.PnfsHandler;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.dcache.namespace.FileAttribute;
import org.dcache.pool.repository.Allocator;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.pool.repository.Repository;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.pool.repository.v5.CacheRepositoryV5;
import org.dcache.util.Checksum;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteHandleImpl
implements ReplicaDescriptor {
    private static final Logger _log = LoggerFactory.getLogger((String)"logger.org.dcache.repository");
    private static final long HOLD_TIME = 300000L;
    private final CacheRepositoryV5 _repository;
    private final Allocator _allocator;
    private final MetaDataRecord _entry;
    private final FileAttributes _fileAttributes;
    private final PnfsHandler _pnfs;
    private final List<StickyRecord> _stickyRecords;
    private final EntryState _initialState;
    private EntryState _targetState;
    private HandleState _state;
    private long _allocated;
    private Thread _allocationThread;

    WriteHandleImpl(CacheRepositoryV5 repository, Allocator allocator, PnfsHandler pnfs, MetaDataRecord entry, FileAttributes fileAttributes, EntryState targetState, List<StickyRecord> stickyRecords, Set<Repository.OpenFlags> flags) throws DiskErrorCacheException {
        this._repository = (CacheRepositoryV5)Preconditions.checkNotNull((Object)repository);
        this._allocator = (Allocator)Preconditions.checkNotNull((Object)allocator);
        this._pnfs = (PnfsHandler)Preconditions.checkNotNull((Object)pnfs);
        this._entry = (MetaDataRecord)Preconditions.checkNotNull((Object)entry);
        this._fileAttributes = (FileAttributes)Preconditions.checkNotNull((Object)fileAttributes);
        this._initialState = entry.getState();
        this._targetState = (EntryState)((Object)Preconditions.checkNotNull((Object)((Object)targetState)));
        this._stickyRecords = (List)Preconditions.checkNotNull(stickyRecords);
        this._state = HandleState.OPEN;
        this._allocated = 0L;
        Preconditions.checkState((this._initialState != EntryState.FROM_CLIENT || this._fileAttributes.isDefined(EnumSet.of(FileAttribute.RETENTION_POLICY, FileAttribute.ACCESS_LATENCY)) ? 1 : 0) != 0);
        Preconditions.checkState((this._initialState == EntryState.FROM_CLIENT || this._fileAttributes.isDefined(FileAttribute.SIZE) ? 1 : 0) != 0);
        if (flags.contains((Object)Repository.OpenFlags.CREATEFILE)) {
            File file = this._entry.getDataFile();
            try {
                if (!file.createNewFile()) {
                    throw new DiskErrorCacheException("File exists when it should not: " + file);
                }
            }
            catch (IOException e) {
                throw new DiskErrorCacheException("Failed to create file: " + file, e);
            }
        }
    }

    private synchronized void setState(HandleState state) {
        this._state = state;
        if (state != HandleState.OPEN && this._allocationThread != null) {
            this._allocationThread.interrupt();
        }
    }

    private synchronized boolean isOpen() {
        return this._state == HandleState.OPEN;
    }

    private synchronized void setAllocationThread() throws InterruptedException, IllegalStateException {
        while (this._allocationThread != null) {
            this.wait();
        }
        if (!this.isOpen()) {
            throw new IllegalStateException("Handle is closed");
        }
        this._allocationThread = Thread.currentThread();
    }

    private synchronized void clearAllocationThread() {
        this._allocationThread = null;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void allocate(long size) throws IllegalStateException, IllegalArgumentException, InterruptedException {
        if (size < 0L) {
            throw new IllegalArgumentException("Size is negative");
        }
        this.setAllocationThread();
        try {
            this._allocator.allocate(size);
        }
        catch (InterruptedException e) {
            if (!this.isOpen()) {
                throw new IllegalStateException("Handle is closed");
            }
            throw e;
        }
        finally {
            this.clearAllocationThread();
        }
        WriteHandleImpl writeHandleImpl = this;
        synchronized (writeHandleImpl) {
            this._allocated += size;
            this._entry.setSize(this._allocated);
        }
    }

    @Override
    public void free(long size) throws IllegalStateException {
        throw new IllegalStateException("Space cannot be freed through a write handle");
    }

    private synchronized void adjustReservation(long length) throws InterruptedException {
        try {
            if (this._allocated < length) {
                _log.error("Under allocation detected. This is a bug. Please report it.");
                this._allocator.allocate(length - this._allocated);
            } else if (this._allocated > length) {
                this._allocator.free(this._allocated - length);
            }
            this._allocated = length;
            this._entry.setSize(length);
        }
        catch (InterruptedException e) {
            _log.warn("Failed to adjust space reservation because the operation was interrupted. The pool is now over allocated.");
            throw e;
        }
    }

    private void registerFileAttributesInNameSpace() throws CacheException {
        FileAttributes attributesToUpdate = new FileAttributes();
        if (this._fileAttributes.isDefined(FileAttribute.CHECKSUM)) {
            attributesToUpdate.setChecksums(this._fileAttributes.getChecksums());
        }
        if (this._initialState == EntryState.FROM_CLIENT) {
            attributesToUpdate.setAccessLatency(this._fileAttributes.getAccessLatency());
            attributesToUpdate.setRetentionPolicy(this._fileAttributes.getRetentionPolicy());
            if (this._fileAttributes.isDefined(FileAttribute.SIZE) && this._fileAttributes.getSize() > 0L) {
                attributesToUpdate.setSize(this._fileAttributes.getSize());
            }
        }
        attributesToUpdate.setLocations(Collections.singleton(this._repository.getPoolName()));
        this._pnfs.setFileAttributes(this._entry.getPnfsId(), attributesToUpdate);
    }

    private void setToTargetState() {
        if (this._targetState == EntryState.CACHED && this._stickyRecords.isEmpty()) {
            long now = System.currentTimeMillis();
            this._repository.setSticky(this._entry, "self", now + 300000L, false);
        }
        for (StickyRecord record : this._stickyRecords) {
            this._repository.setSticky(this._entry, record.owner(), record.expire(), false);
        }
        this._repository.setState(this._entry, this._targetState);
    }

    private void verifyFileSize(long length) throws CacheException {
        assert (this._initialState == EntryState.FROM_CLIENT || this._fileAttributes.isDefined(FileAttribute.SIZE));
        if ((this._initialState != EntryState.FROM_CLIENT || this._fileAttributes.isDefined(FileAttribute.SIZE) && this._fileAttributes.getSize() > 0L) && this._fileAttributes.getSize() != length) {
            throw new FileCorruptedCacheException(this._fileAttributes.getSize(), length);
        }
    }

    @Override
    public synchronized void commit() throws IllegalStateException, InterruptedException, CacheException {
        if (this._state != HandleState.OPEN) {
            throw new IllegalStateException("Handle is closed");
        }
        try {
            this._entry.touch();
            long length = this.getFile().length();
            this.adjustReservation(length);
            this.verifyFileSize(length);
            this._fileAttributes.setSize(length);
            this.registerFileAttributesInNameSpace();
            this._entry.setFileAttributes(this._fileAttributes);
            this.setToTargetState();
            this.setState(HandleState.COMMITTED);
        }
        catch (CacheException e) {
            if (e.getRc() == 10001) {
                this._targetState = EntryState.REMOVED;
            }
            throw e;
        }
    }

    private synchronized void fail() {
        long length = this.getFile().length();
        try {
            this.adjustReservation(length);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this._initialState == EntryState.FROM_POOL || this._initialState == EntryState.FROM_STORE) {
            this._targetState = EntryState.REMOVED;
        }
        if (this._targetState != EntryState.REMOVED) {
            try {
                this._pnfs.addCacheLocation(this._entry.getPnfsId(), this._repository.getPoolName());
                this.registerFileAttributesInNameSpace();
            }
            catch (CacheException e) {
                if (e.getRc() == 10001) {
                    this._targetState = EntryState.REMOVED;
                }
                _log.warn("Failed to register {} after failed replica creation: {}", (Object)this._fileAttributes, (Object)e.getMessage());
            }
        }
        if (this._targetState == EntryState.REMOVED) {
            this._repository.setState(this._entry, EntryState.REMOVED);
        } else {
            _log.warn("Marking pool entry as BROKEN");
            this._repository.setState(this._entry, EntryState.BROKEN);
        }
    }

    @Override
    public synchronized void close() throws IllegalStateException {
        switch (this._state) {
            case CLOSED: {
                throw new IllegalStateException("Handle is closed");
            }
            case OPEN: {
                this.fail();
                this.setState(HandleState.CLOSED);
                break;
            }
            case COMMITTED: {
                this.setState(HandleState.CLOSED);
            }
        }
        this._repository.destroyWhenRemovedAndUnused(this._entry);
    }

    @Override
    public synchronized File getFile() throws IllegalStateException {
        if (this._state == HandleState.CLOSED) {
            throw new IllegalStateException("Handle is closed");
        }
        return this._entry.getDataFile();
    }

    @Override
    public FileAttributes getFileAttributes() throws IllegalStateException {
        return this._fileAttributes;
    }

    @Override
    public synchronized Iterable<Checksum> getChecksums() throws CacheException {
        if (!this._fileAttributes.isDefined(FileAttribute.CHECKSUM)) {
            this._fileAttributes.setChecksums(this._pnfs.getFileAttributes(this._entry.getPnfsId(), EnumSet.of(FileAttribute.CHECKSUM)).getChecksums());
        }
        return Iterables.unmodifiableIterable(this._fileAttributes.getChecksums());
    }

    @Override
    public synchronized void addChecksums(Iterable<Checksum> checksums) {
        if (!Iterables.isEmpty(checksums)) {
            Iterable newChecksums = this._fileAttributes.isDefined(FileAttribute.CHECKSUM) ? Iterables.concat(this._fileAttributes.getChecksums(), checksums) : checksums;
            this._fileAttributes.setChecksums(Sets.newHashSet((Iterable)newChecksums));
        }
    }

    static enum HandleState {
        OPEN,
        COMMITTED,
        CLOSED;

    }
}

