/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.v5;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import org.dcache.pool.repository.EntryChangeEvent;
import org.dcache.pool.repository.StateChangeEvent;
import org.dcache.pool.repository.StateChangeListener;
import org.dcache.pool.repository.StickyChangeEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StateChangeListeners {
    private static final Logger _log = LoggerFactory.getLogger(StateChangeListeners.class);
    private final List<StateChangeListener> _listeners = new CopyOnWriteArrayList<StateChangeListener>();
    private final ExecutorService _executorService = Executors.newSingleThreadExecutor();
    private Executor _executor = this._executorService;

    public void setSynchronousNotification(boolean value) {
        this._executor = value ? MoreExecutors.sameThreadExecutor() : this._executorService;
    }

    public void add(StateChangeListener listener) {
        this._listeners.add(listener);
    }

    public void remove(StateChangeListener listener) {
        this._listeners.remove(listener);
    }

    public void stateChanged(final StateChangeEvent event) {
        try {
            this._executor.execute(new Runnable(){

                @Override
                public void run() {
                    for (StateChangeListener listener : StateChangeListeners.this._listeners) {
                        try {
                            listener.stateChanged(event);
                        }
                        catch (RuntimeException e) {
                            _log.error("Unexpected failure during state change notification", (Throwable)e);
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            _log.debug("Dropping repository state change notification: {}", (Object)e.getMessage());
        }
    }

    public void accessTimeChanged(final EntryChangeEvent event) {
        try {
            this._executor.execute(new Runnable(){

                @Override
                public void run() {
                    for (StateChangeListener listener : StateChangeListeners.this._listeners) {
                        try {
                            listener.accessTimeChanged(event);
                        }
                        catch (RuntimeException e) {
                            _log.error("Unexpected failure during state change notification", (Throwable)e);
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            _log.debug("Dropping repository access time change notification: {}", (Object)e.getMessage());
        }
    }

    public void stickyChanged(final StickyChangeEvent event) {
        try {
            this._executor.execute(new Runnable(){

                @Override
                public void run() {
                    for (StateChangeListener listener : StateChangeListeners.this._listeners) {
                        try {
                            listener.stickyChanged(event);
                        }
                        catch (RuntimeException e) {
                            _log.error("Unexpected failure during state change notification", (Throwable)e);
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException e) {
            _log.debug("Dropping repository stick flag change notification: {}", (Object)e.getMessage());
        }
    }

    public void stop() {
        this._executorService.shutdown();
    }
}

