/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.v5;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsHandler;
import java.io.File;
import java.util.EnumSet;
import java.util.Set;
import org.dcache.namespace.FileAttribute;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.pool.repository.v5.CacheRepositoryV5;
import org.dcache.util.Checksum;
import org.dcache.vehicles.FileAttributes;

class ReadHandleImpl
implements ReplicaDescriptor {
    private final CacheRepositoryV5 _repository;
    private final PnfsHandler _pnfs;
    private final MetaDataRecord _entry;
    private FileAttributes _fileAttributes;
    private boolean _open;

    ReadHandleImpl(CacheRepositoryV5 repository, PnfsHandler pnfs, MetaDataRecord entry) {
        this._repository = (CacheRepositoryV5)Preconditions.checkNotNull((Object)repository);
        this._pnfs = (PnfsHandler)Preconditions.checkNotNull((Object)pnfs);
        this._entry = (MetaDataRecord)Preconditions.checkNotNull((Object)entry);
        this._fileAttributes = this._entry.getFileAttributes();
        this._open = true;
        this._entry.incrementLinkCount();
    }

    @Override
    public synchronized void close() throws IllegalStateException {
        if (!this._open) {
            throw new IllegalStateException("Handle is closed");
        }
        this._entry.decrementLinkCount();
        this._open = false;
        this._repository.destroyWhenRemovedAndUnused(this._entry);
    }

    @Override
    public synchronized File getFile() throws IllegalStateException {
        if (!this._open) {
            throw new IllegalStateException("Handle is closed");
        }
        return this._entry.getDataFile();
    }

    @Override
    public synchronized FileAttributes getFileAttributes() throws IllegalStateException {
        return this._fileAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Iterable<Checksum> getChecksums() throws CacheException {
        if (this._fileAttributes.isUndefined(FileAttribute.CHECKSUM)) {
            Set<Checksum> checksums = this._pnfs.getFileAttributes(this._entry.getPnfsId(), EnumSet.of(FileAttribute.CHECKSUM)).getChecksums();
            MetaDataRecord metaDataRecord = this._entry;
            synchronized (metaDataRecord) {
                this._fileAttributes = this._entry.getFileAttributes();
                if (this._fileAttributes.isUndefined(FileAttribute.CHECKSUM)) {
                    this._fileAttributes.setChecksums(checksums);
                    this._entry.setFileAttributes(this._fileAttributes);
                }
            }
        }
        return Iterables.unmodifiableIterable(this._fileAttributes.getChecksums());
    }

    @Override
    public void addChecksums(Iterable<Checksum> checksums) {
        throw new IllegalStateException("Read-only handle");
    }

    @Override
    public void commit() throws IllegalStateException, InterruptedException, CacheException {
    }

    @Override
    public void allocate(long size) throws IllegalStateException, IllegalArgumentException, InterruptedException {
        throw new IllegalStateException("Read-only handle");
    }

    @Override
    public void free(long size) throws IllegalStateException, IllegalArgumentException {
        throw new IllegalStateException("Read-only handle");
    }
}

