/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.v5;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.DiskErrorCacheException;
import diskCacheV111.util.FileInCacheException;
import diskCacheV111.util.FileNotInCacheException;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.util.UnitInteger;
import dmg.util.Args;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.namespace.FileAttribute;
import org.dcache.pool.FaultAction;
import org.dcache.pool.FaultEvent;
import org.dcache.pool.FaultListener;
import org.dcache.pool.repository.Account;
import org.dcache.pool.repository.Allocator;
import org.dcache.pool.repository.CacheEntry;
import org.dcache.pool.repository.DuplicateEntryException;
import org.dcache.pool.repository.EntryChangeEvent;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.IllegalTransitionException;
import org.dcache.pool.repository.MetaDataCache;
import org.dcache.pool.repository.MetaDataLRUOrder;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.MetaDataStore;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.pool.repository.Repository;
import org.dcache.pool.repository.SpaceRecord;
import org.dcache.pool.repository.SpaceSweeperPolicy;
import org.dcache.pool.repository.StateChangeEvent;
import org.dcache.pool.repository.StateChangeListener;
import org.dcache.pool.repository.StickyChangeEvent;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.pool.repository.v5.CacheEntryImpl;
import org.dcache.pool.repository.v5.CheckHealthTask;
import org.dcache.pool.repository.v5.ReadHandleImpl;
import org.dcache.pool.repository.v5.StateChangeListeners;
import org.dcache.pool.repository.v5.WriteHandleImpl;
import org.dcache.util.CacheExceptionFactory;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheRepositoryV5
extends AbstractCellComponent
implements Repository,
CellCommandListener {
    public static final long EXPIRATION_CLOCKSHIFT_EXTRA_TIME = 1000L;
    private static final Logger _log = LoggerFactory.getLogger(CacheRepositoryV5.class);
    private final List<FaultListener> _faultListeners = new CopyOnWriteArrayList<FaultListener>();
    private final StateChangeListeners _stateChangeListeners = new StateChangeListeners();
    private final Map<PnfsId, ScheduledFuture<?>> _tasks = new ConcurrentHashMap();
    private final Set<PnfsId> _removable = Collections.newSetFromMap(new ConcurrentHashMap());
    private ScheduledExecutorService _executor;
    private MetaDataStore _store;
    private State _state = State.UNINITIALIZED;
    private Account _account;
    private Allocator _allocator;
    private SpaceSweeperPolicy _sweeper;
    private PnfsHandler _pnfs;
    private boolean _checkRepository = true;
    private boolean _volatile;
    private long _runtimeMaxSize = Long.MAX_VALUE;
    private long _staticMaxSize = Long.MAX_VALUE;
    public static final String hh_set_max_diskspace = "<bytes>[<unit>]|Infinity # unit = k|m|g|t";
    public static final String fh_set_max_diskspace = "Sets the maximum disk space to be used by this pool. Overrides\nwhatever maximum was defined in the configuration file. The value\nwill be saved to the pool setup file if the save command is\nexecuted. If inf is specified, then the pool will return to the\nsize configured in the configuration file, or no maximum if such a\nsize is not defined.";

    private synchronized void assertUninitialized() {
        if (this._state != State.UNINITIALIZED) {
            throw new IllegalStateException("Operation not allowed after initialization");
        }
    }

    private synchronized void assertOpen() {
        if (this._state != State.OPEN) {
            throw new IllegalStateException("Operation not allowed while repository is in state " + (Object)((Object)this._state));
        }
    }

    private synchronized void assertInitialized() {
        if (this._state != State.INITIALIZED && this._state != State.LOADING && this._state != State.OPEN) {
            throw new IllegalStateException("Operation not allowed while repository is in state " + (Object)((Object)this._state));
        }
    }

    public synchronized void setExecutor(ScheduledExecutorService executor) {
        this.assertUninitialized();
        this._executor = executor;
    }

    public synchronized void setPnfsHandler(PnfsHandler pnfs) {
        this.assertUninitialized();
        this._pnfs = pnfs;
    }

    public synchronized boolean getPeriodicChecks() {
        return this._checkRepository;
    }

    public synchronized void setPeriodicChecks(boolean enable) {
        this.assertUninitialized();
        this._checkRepository = enable;
    }

    public synchronized boolean getVolatile() {
        return this._volatile;
    }

    public synchronized void setVolatile(boolean value) {
        this.assertUninitialized();
        this._volatile = value;
    }

    public synchronized void setAccount(Account account) {
        this.assertUninitialized();
        this._account = account;
    }

    public synchronized void setAllocator(Allocator allocator) {
        this.assertUninitialized();
        this._allocator = allocator;
    }

    public synchronized void setMetaDataStore(MetaDataStore store) {
        this.assertUninitialized();
        this._store = store;
    }

    public synchronized void setSpaceSweeperPolicy(SpaceSweeperPolicy sweeper) {
        this.assertUninitialized();
        this._sweeper = sweeper;
    }

    public synchronized void setMaxDiskSpaceString(String size) {
        this.setMaxDiskSpace(UnitInteger.parseUnitLong(size));
    }

    public synchronized void setMaxDiskSpace(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Negative value is not allowed");
        }
        this._staticMaxSize = size;
        if (this._state == State.OPEN) {
            this.updateAccountSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws IllegalStateException {
        CacheRepositoryV5 cacheRepositoryV5 = this;
        synchronized (cacheRepositoryV5) {
            assert (this._pnfs != null) : "Pnfs handler must be set";
            assert (this._account != null) : "Account must be set";
            assert (this._allocator != null) : "Account must be set";
            if (this._state != State.UNINITIALIZED) {
                throw new IllegalStateException("Can only initialize repository once.");
            }
            this._state = State.INITIALIZING;
        }
        _log.warn("Reading inventory from " + this._store);
        MetaDataCache cache = new MetaDataCache(this._store);
        CacheRepositoryV5 cacheRepositoryV52 = this;
        synchronized (cacheRepositoryV52) {
            this._store = cache;
            this._state = State.INITIALIZED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void load() throws CacheException, IllegalStateException, InterruptedException {
        Iterable<PnfsId> ids;
        try {
            Account account;
            MetaDataRecord entry;
            CacheRepositoryV5 cacheRepositoryV5 = this;
            synchronized (cacheRepositoryV5) {
                if (this._state != State.INITIALIZED) {
                    throw new IllegalStateException("Can only load repository after initialization and only once.");
                }
                this._state = State.LOADING;
            }
            ids = new ArrayList<PnfsId>(this._store.list());
            _log.info("Found {} data files", (Object)ids.size());
            Collections.sort(ids);
            _log.info("Checking meta data for {} files", (Object)ids.size());
            long usedDataSpace = 0L;
            ArrayList<MetaDataRecord> entries = new ArrayList<MetaDataRecord>();
            for (PnfsId pnfsId : ids) {
                entry = this.readMetaDataRecord(pnfsId);
                if (entry == null) continue;
                usedDataSpace += entry.getSize();
                _log.debug("{} {}", (Object)pnfsId, (Object)entry.getState());
                entries.add(entry);
            }
            _log.info("Pool contains {} bytes of data", (Object)usedDataSpace);
            Account account2 = account = this._account;
            synchronized (account2) {
                account.setTotal(usedDataSpace);
                account.allocateNow(usedDataSpace);
            }
            this.updateAccountSize();
            CacheRepositoryV5 cacheRepositoryV52 = this;
            synchronized (cacheRepositoryV52) {
                _log.info("Registering files in sweeper");
                Collections.sort(entries, new MetaDataLRUOrder());
                for (MetaDataRecord entry2 : entries) {
                    this.stateChanged(entry2, EntryState.NEW, entry2.getState());
                }
                _log.info(String.format("Inventory contains %d files; total size is %d; used space is %d; free space is %d.", entries.size(), this._account.getTotal(), usedDataSpace, this._account.getFree()));
                this._state = State.OPEN;
            }
            _log.info("Registering sticky bits");
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                MetaDataRecord metaDataRecord = entry = (MetaDataRecord)iterator.next();
                synchronized (metaDataRecord) {
                    if (entry.isSticky()) {
                        this.scheduleExpirationTask(entry);
                    }
                }
            }
        }
        finally {
            ids = this;
            synchronized (ids) {
                if (this._state != State.OPEN) {
                    this._state = State.FAILED;
                }
            }
        }
        _log.info("Done generating inventory");
        if (this.getPeriodicChecks()) {
            CheckHealthTask task = new CheckHealthTask(this);
            task.setAccount(this._account);
            task.setMetaDataStore(this._store);
            this._executor.scheduleWithFixedDelay(task, 0L, 60L, TimeUnit.SECONDS);
        }
    }

    @Override
    public Iterator<PnfsId> iterator() {
        this.assertOpen();
        return Collections.unmodifiableCollection(this._store.list()).iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicaDescriptor createEntry(FileAttributes fileAttributes, EntryState transferState, EntryState targetState, List<StickyRecord> stickyRecords, Set<Repository.OpenFlags> flags) throws FileInCacheException {
        try {
            MetaDataRecord entry;
            if (!fileAttributes.isDefined(EnumSet.of(FileAttribute.PNFSID, FileAttribute.STORAGEINFO))) {
                throw new IllegalArgumentException("StorageInfo must not be null");
            }
            if (stickyRecords == null) {
                throw new IllegalArgumentException("List of sticky records must not be null");
            }
            this.assertOpen();
            switch (transferState) {
                case FROM_CLIENT: 
                case FROM_STORE: 
                case FROM_POOL: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid initial state");
                }
            }
            switch (targetState) {
                case PRECIOUS: 
                case CACHED: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid target state");
                }
            }
            MetaDataRecord metaDataRecord = entry = this._store.create(fileAttributes.getPnfsId());
            synchronized (metaDataRecord) {
                entry.setFileAttributes(fileAttributes);
                this.setState(entry, transferState);
                return new WriteHandleImpl(this, this._allocator, this._pnfs, entry, fileAttributes, targetState, stickyRecords, flags);
            }
        }
        catch (DuplicateEntryException e) {
            throw new FileInCacheException("Entry already exists: " + fileAttributes.getPnfsId());
        }
        catch (CacheException e) {
            this.fail(FaultAction.READONLY, "Internal repository error", e);
            throw new RuntimeException("Internal repository error", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReplicaDescriptor openEntry(PnfsId id, Set<Repository.OpenFlags> flags) throws CacheException, InterruptedException {
        this.assertInitialized();
        try {
            ReadHandleImpl handle;
            MetaDataRecord entry = this.getMetaDataRecord(id);
            Object object = entry;
            synchronized (object) {
                switch (entry.getState()) {
                    case FROM_CLIENT: 
                    case FROM_STORE: 
                    case FROM_POOL: 
                    case NEW: {
                        throw new FileNotInCacheException("File is incomplete");
                    }
                    case BROKEN: {
                        throw new FileNotInCacheException("File is broken");
                    }
                    case DESTROYED: {
                        throw new FileNotInCacheException("File has been removed");
                    }
                }
                handle = new ReadHandleImpl(this, this._pnfs, entry);
            }
            if (!flags.contains((Object)Repository.OpenFlags.NOATIME)) {
                object = this;
                synchronized (object) {
                    entry.touch();
                    if (this._state == State.OPEN) {
                        this.accessTimeChanged(entry);
                    }
                }
            }
            return handle;
        }
        catch (FileNotInCacheException e) {
            this._pnfs.clearCacheLocation(id);
            throw e;
        }
        catch (DiskErrorCacheException e) {
            this.fail(FaultAction.READONLY, "Internal repository error", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheEntry getEntry(PnfsId id) throws CacheException, InterruptedException {
        this.assertInitialized();
        try {
            MetaDataRecord entry;
            MetaDataRecord metaDataRecord = entry = this.getMetaDataRecord(id);
            synchronized (metaDataRecord) {
                if (entry.getState() == EntryState.NEW) {
                    throw new FileNotInCacheException("File is incomplete");
                }
                return new CacheEntryImpl(entry);
            }
        }
        catch (FileNotInCacheException e) {
            throw e;
        }
        catch (DiskErrorCacheException e) {
            this.fail(FaultAction.READONLY, "Internal repository error", e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSticky(PnfsId id, String owner, long expire, boolean overwrite) throws IllegalArgumentException, CacheException, InterruptedException {
        MetaDataRecord entry;
        if (id == null) {
            throw new IllegalArgumentException("Null argument not allowed");
        }
        this.assertInitialized();
        try {
            entry = this.getMetaDataRecord(id);
        }
        catch (FileNotInCacheException e) {
            this._pnfs.clearCacheLocation(id);
            throw e;
        }
        CacheRepositoryV5 cacheRepositoryV5 = this;
        synchronized (cacheRepositoryV5) {
            MetaDataRecord metaDataRecord = entry;
            synchronized (metaDataRecord) {
                switch (entry.getState()) {
                    case FROM_CLIENT: 
                    case FROM_STORE: 
                    case FROM_POOL: 
                    case NEW: {
                        throw new FileNotInCacheException("File is incomplete");
                    }
                    case DESTROYED: 
                    case REMOVED: {
                        throw new FileNotInCacheException("File has been removed");
                    }
                }
                this.setSticky(entry, owner, expire, overwrite);
            }
        }
    }

    @Override
    public SpaceRecord getSpaceRecord() {
        SpaceRecord space = this._account.getSpaceRecord();
        long lru = (System.currentTimeMillis() - this._sweeper.getLru()) / 1000L;
        return new SpaceRecord(space.getTotalSpace(), space.getFreeSpace(), space.getPreciousSpace(), space.getRemovableSpace(), lru);
    }

    @Override
    public void setState(PnfsId id, EntryState state) throws IllegalTransitionException, IllegalArgumentException, InterruptedException, CacheException {
        if (id == null) {
            throw new IllegalArgumentException("id is null");
        }
        this.assertOpen();
        try {
            MetaDataRecord entry;
            MetaDataRecord metaDataRecord = entry = this.getMetaDataRecord(id);
            synchronized (metaDataRecord) {
                EntryState source = entry.getState();
                switch (source) {
                    case NEW: 
                    case DESTROYED: 
                    case REMOVED: {
                        if (state != EntryState.REMOVED) break;
                        return;
                    }
                    case PRECIOUS: 
                    case CACHED: 
                    case BROKEN: {
                        switch (state) {
                            case PRECIOUS: 
                            case CACHED: 
                            case BROKEN: 
                            case REMOVED: {
                                this.setState(entry, state);
                                return;
                            }
                        }
                    }
                }
                throw new IllegalTransitionException(id, source, state);
            }
        }
        catch (FileNotInCacheException e) {
            if (state != EntryState.REMOVED) {
                throw new IllegalTransitionException(id, EntryState.NEW, state);
            }
        }
        catch (DiskErrorCacheException e) {
            this.fail(FaultAction.READONLY, "Internal repository error", e);
            throw e;
        }
    }

    public void setSynchronousNotification(boolean value) {
        this._stateChangeListeners.setSynchronousNotification(value);
    }

    @Override
    public void addListener(StateChangeListener listener) {
        this._stateChangeListeners.add(listener);
    }

    @Override
    public void removeListener(StateChangeListener listener) {
        this._stateChangeListeners.remove(listener);
    }

    @Override
    public void addFaultListener(FaultListener listener) {
        this._faultListeners.add(listener);
    }

    @Override
    public void removeFaultListener(FaultListener listener) {
        this._faultListeners.remove(listener);
    }

    @Override
    public EntryState getState(PnfsId id) throws CacheException, InterruptedException {
        this.assertInitialized();
        try {
            return this.getMetaDataRecord(id).getState();
        }
        catch (FileNotInCacheException e) {
            return EntryState.NEW;
        }
    }

    @Override
    public void getInfo(PrintWriter pw) {
        pw.println("State             : " + (Object)((Object)this._state));
        pw.println("Check Repository  : " + this.getPeriodicChecks());
        SpaceRecord space = this.getSpaceRecord();
        long total = space.getTotalSpace();
        long used = total - space.getFreeSpace();
        long precious = space.getPreciousSpace();
        long fsFree = this._store.getFreeSpace();
        long fsTotal = this._store.getTotalSpace();
        pw.println("Diskspace usage   : ");
        pw.println("    Total    : " + UnitInteger.toUnitString(total));
        pw.println("    Used     : " + used + "    [" + (float)used / (float)total + "]");
        pw.println("    Free     : " + (total - used));
        pw.println("    Precious : " + precious + "    [" + (float)precious / (float)total + "]");
        pw.println("    Removable: " + space.getRemovableSpace() + "    [" + (float)space.getRemovableSpace() / (float)total + "]");
        pw.println("File system");
        pw.println("    Size: " + fsTotal);
        pw.println("    Free: " + fsFree + "    [" + (float)fsFree / (float)fsTotal + "]");
        pw.println("Limits for maximum disk space");
        pw.println("    File system          : " + (fsFree + used));
        pw.println("    Statically configured: " + UnitInteger.toUnitString(this._staticMaxSize));
        pw.println("    Runtime configured   : " + UnitInteger.toUnitString(this._runtimeMaxSize));
    }

    public synchronized void shutdown() {
        this._stateChangeListeners.stop();
        this._state = State.CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateRemovable(MetaDataRecord entry) {
        MetaDataRecord metaDataRecord = entry;
        synchronized (metaDataRecord) {
            PnfsId id = entry.getPnfsId();
            if (this._sweeper.isRemovable(entry)) {
                if (this._removable.add(id)) {
                    this._account.adjustRemovable(entry.getSize());
                }
            } else if (this._removable.remove(id)) {
                this._account.adjustRemovable(-entry.getSize());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stateChanged(MetaDataRecord entry, EntryState oldState, EntryState newState) {
        MetaDataRecord metaDataRecord = entry;
        synchronized (metaDataRecord) {
            this.updateRemovable(entry);
            StateChangeEvent event = new StateChangeEvent(new CacheEntryImpl(entry), oldState, newState);
            this._stateChangeListeners.stateChanged(event);
            if (oldState != EntryState.PRECIOUS && newState == EntryState.PRECIOUS) {
                this._account.adjustPrecious(entry.getSize());
            } else if (oldState == EntryState.PRECIOUS && newState != EntryState.PRECIOUS) {
                this._account.adjustPrecious(-entry.getSize());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void accessTimeChanged(MetaDataRecord entry) {
        MetaDataRecord metaDataRecord = entry;
        synchronized (metaDataRecord) {
            this.updateRemovable(entry);
            EntryChangeEvent event = new EntryChangeEvent(new CacheEntryImpl(entry));
            this._stateChangeListeners.accessTimeChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stickyChanged(MetaDataRecord entry, StickyRecord record) {
        MetaDataRecord metaDataRecord = entry;
        synchronized (metaDataRecord) {
            this.updateRemovable(entry);
            StickyChangeEvent event = new StickyChangeEvent(new CacheEntryImpl(entry), record);
            this._stateChangeListeners.stickyChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(MetaDataRecord entry, EntryState state) {
        MetaDataRecord metaDataRecord = entry;
        synchronized (metaDataRecord) {
            EntryState oldState = entry.getState();
            if (oldState == state) {
                return;
            }
            try {
                entry.setState(state);
            }
            catch (CacheException e) {
                this.fail(FaultAction.READONLY, "Internal repository error", e);
                throw new RuntimeException("Internal repository error", e);
            }
            this.stateChanged(entry, oldState, state);
            if (state == EntryState.REMOVED) {
                if (_log.isInfoEnabled()) {
                    _log.info("remove entry for: " + entry.getPnfsId().toString());
                }
                PnfsId id = entry.getPnfsId();
                this._pnfs.clearCacheLocation(id, this._volatile);
                ScheduledFuture<?> oldTask = this._tasks.remove(id);
                if (oldTask != null) {
                    oldTask.cancel(false);
                }
            }
            this.destroyWhenRemovedAndUnused(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void setSticky(MetaDataRecord entry, String owner, long expire, boolean overwrite) throws IllegalArgumentException {
        try {
            if (entry == null || owner == null) {
                throw new IllegalArgumentException("Null argument not allowed");
            }
            if (expire < -1L) {
                throw new IllegalArgumentException("Expiration time must be -1 or non-negative");
            }
            MetaDataRecord metaDataRecord = entry;
            synchronized (metaDataRecord) {
                if (entry.setSticky(owner, expire, overwrite) && this._state == State.OPEN) {
                    this.stickyChanged(entry, new StickyRecord(owner, expire));
                    this.scheduleExpirationTask(entry);
                }
            }
        }
        catch (CacheException e) {
            this.fail(FaultAction.READONLY, "Internal repository error", e);
            throw new RuntimeException("Internal repository error", e);
        }
    }

    private MetaDataRecord getMetaDataRecord(PnfsId pnfsId) throws CacheException, InterruptedException {
        MetaDataRecord entry = this._store.get(pnfsId);
        if (entry == null) {
            throw new FileNotInCacheException("Entry not in repository : " + pnfsId);
        }
        return entry;
    }

    private MetaDataRecord readMetaDataRecord(PnfsId id) throws CacheException, InterruptedException {
        while (!Thread.interrupted()) {
            try {
                return this._store.get(id);
            }
            catch (CacheException e) {
                if (e.getRc() != 10006) {
                    throw CacheExceptionFactory.exceptionOf(e.getRc(), "Failed to read meta data for " + id + ": " + e.getMessage(), e);
                }
                Thread.sleep(1000L);
            }
        }
        throw new InterruptedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroyWhenRemovedAndUnused(MetaDataRecord entry) {
        MetaDataRecord metaDataRecord = entry;
        synchronized (metaDataRecord) {
            EntryState state = entry.getState();
            PnfsId id = entry.getPnfsId();
            if (entry.getLinkCount() == 0 && state == EntryState.REMOVED) {
                this.setState(entry, EntryState.DESTROYED);
                this._account.free(entry.getSize());
                this._store.remove(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExpiredStickyFlags(MetaDataRecord entry) {
        MetaDataRecord metaDataRecord = entry;
        synchronized (metaDataRecord) {
            List<StickyRecord> removed = entry.removeExpiredStickyFlags();
            for (StickyRecord record : removed) {
                this.stickyChanged(entry, record);
            }
            this.scheduleExpirationTask(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleExpirationTask(MetaDataRecord entry) {
        MetaDataRecord metaDataRecord = entry;
        synchronized (metaDataRecord) {
            PnfsId pnfsId = entry.getPnfsId();
            ScheduledFuture<?> future = this._tasks.remove(pnfsId);
            if (future != null) {
                future.cancel(false);
            }
            long expire = Long.MAX_VALUE;
            for (StickyRecord record : entry.stickyRecords()) {
                if (record.expire() <= -1L) continue;
                expire = Math.min(expire, record.expire());
            }
            if (expire != Long.MAX_VALUE) {
                ExpirationTask task = new ExpirationTask(entry);
                future = this._executor.schedule(task, expire - System.currentTimeMillis() + 1000L, TimeUnit.MILLISECONDS);
                this._tasks.put(pnfsId, future);
            }
        }
    }

    void fail(FaultAction action, String message, Throwable cause) {
        FaultEvent event = new FaultEvent("repository", action, message, cause);
        for (FaultListener listener : this._faultListeners) {
            listener.faultOccurred(event);
        }
    }

    void fail(FaultAction action, String message) {
        this.fail(action, message, null);
    }

    public String getPoolName() {
        return this.getCellName();
    }

    public synchronized String ac_set_max_diskspace_$_1(Args args) {
        long size = UnitInteger.parseUnitLong(args.argv(0));
        if (size < 0L) {
            throw new IllegalArgumentException("Negative value is not allowed");
        }
        this._runtimeMaxSize = size;
        if (this._state == State.OPEN) {
            this.updateAccountSize();
        }
        return "";
    }

    @Override
    public synchronized void printSetup(PrintWriter pw) {
        if (this._runtimeMaxSize < Long.MAX_VALUE) {
            pw.println("set max diskspace " + this._runtimeMaxSize);
        }
    }

    private synchronized long getConfiguredMaxSize() {
        if (this._runtimeMaxSize < Long.MAX_VALUE) {
            return this._runtimeMaxSize;
        }
        return this._staticMaxSize;
    }

    private long getFileSystemMaxSize() {
        return this._store.getFreeSpace() + this._account.getUsed();
    }

    private boolean isTotalSpaceReported() {
        return this._store.getTotalSpace() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateAccountSize() {
        Account account;
        Account account2 = account = this._account;
        synchronized (account2) {
            long newSize;
            long configuredMaxSize = this.getConfiguredMaxSize();
            long fileSystemMaxSize = this.getFileSystemMaxSize();
            boolean hasConfiguredMaxSize = configuredMaxSize < Long.MAX_VALUE;
            long used = account.getUsed();
            if (!this.isTotalSpaceReported()) {
                _log.warn("Java reported the file system size as 0. This typically happens on Solaris with a 32-bit JVM. Please use a 64-bit JVM.");
                if (!hasConfiguredMaxSize) {
                    throw new IllegalStateException("Failed to determine file system size. A pool size must be configured.");
                }
            }
            if (hasConfiguredMaxSize && fileSystemMaxSize < configuredMaxSize) {
                _log.warn(String.format("Configured pool size (%d) is larger than what is available on disk (%d)", configuredMaxSize, fileSystemMaxSize));
            }
            if (configuredMaxSize < used) {
                _log.warn(String.format("Configured pool size (%d) is smaller than what is used already (%d)", configuredMaxSize, used));
            }
            if ((newSize = Math.max(used, Math.min(configuredMaxSize, fileSystemMaxSize))) != account.getTotal()) {
                _log.info("Adjusting pool size to " + newSize);
                account.setTotal(newSize);
            }
        }
    }

    class ExpirationTask
    implements Runnable {
        private final MetaDataRecord _entry;

        public ExpirationTask(MetaDataRecord entry) {
            this._entry = entry;
        }

        @Override
        public void run() {
            CacheRepositoryV5.this._tasks.remove(this._entry.getPnfsId());
            CacheRepositoryV5.this.removeExpiredStickyFlags(this._entry);
        }
    }

    static enum State {
        UNINITIALIZED,
        INITIALIZING,
        INITIALIZED,
        LOADING,
        OPEN,
        FAILED,
        CLOSED;

    }
}

