/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.v5;

import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.StorageInfo;
import java.util.Collection;
import org.dcache.pool.repository.CacheEntry;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.vehicles.FileAttributes;

public class CacheEntryImpl
implements CacheEntry {
    private final long _size;
    private final EntryState _state;
    private final long _created_at;
    private final long _accessed_at;
    private final int _linkCount;
    private final boolean _isSticky;
    private final Collection<StickyRecord> _sticky;
    private final FileAttributes _fileAttributes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheEntryImpl(MetaDataRecord entry) {
        MetaDataRecord metaDataRecord = entry;
        synchronized (metaDataRecord) {
            this._size = entry.getSize();
            this._created_at = entry.getCreationTime();
            this._accessed_at = entry.getLastAccessTime();
            this._linkCount = entry.getLinkCount();
            this._isSticky = entry.isSticky();
            this._sticky = entry.stickyRecords();
            this._state = entry.getState();
            this._fileAttributes = entry.getFileAttributes();
        }
    }

    @Override
    public PnfsId getPnfsId() {
        return this._fileAttributes.getPnfsId();
    }

    @Override
    public long getReplicaSize() {
        return this._size;
    }

    @Override
    public FileAttributes getFileAttributes() {
        return this._fileAttributes;
    }

    @Override
    public EntryState getState() {
        return this._state;
    }

    @Override
    public long getCreationTime() {
        return this._created_at;
    }

    @Override
    public long getLastAccessTime() {
        return this._accessed_at;
    }

    @Override
    public int getLinkCount() {
        return this._linkCount;
    }

    @Override
    public boolean isSticky() {
        return this._isSticky;
    }

    @Override
    public Collection<StickyRecord> getStickyRecords() {
        return this._sticky;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPnfsId());
        sb.append(" <");
        sb.append(this._state == EntryState.CACHED ? "C" : "-");
        sb.append(this._state == EntryState.PRECIOUS ? "P" : "-");
        sb.append(this._state == EntryState.FROM_CLIENT ? "C" : "-");
        sb.append(this._state == EntryState.FROM_STORE ? "S" : "-");
        sb.append("-");
        sb.append("-");
        sb.append(this._state == EntryState.REMOVED ? "R" : "-");
        sb.append(this._state == EntryState.DESTROYED ? "D" : "-");
        sb.append(this.isSticky() ? "X" : "-");
        sb.append(this._state == EntryState.BROKEN ? "E" : "-");
        sb.append("-");
        sb.append("L(0)[").append(this._linkCount).append("]");
        sb.append("> ");
        StorageInfo info = this._fileAttributes.getStorageInfo();
        sb.append(this._size);
        sb.append(" si={").append(info == null ? "<unknown>" : info.getStorageClass()).append("}");
        return sb.toString();
    }
}

