/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.v3.entry.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dcache.pool.repository.StickyRecord;

public class Sticky {
    private final Map<String, StickyRecord> _records = new HashMap<String, StickyRecord>();

    public synchronized boolean isSticky() {
        return !this._records.isEmpty();
    }

    public boolean isSet() {
        return this.isSticky();
    }

    public synchronized boolean addRecord(String owner, long expire, boolean overwrite) {
        if (!this.removeRecord(owner, overwrite ? -1L : expire)) {
            return false;
        }
        if (expire == -1L || expire > System.currentTimeMillis()) {
            this._records.put(owner, new StickyRecord(owner, expire));
        }
        return true;
    }

    private synchronized boolean removeRecord(String owner, long time) {
        StickyRecord record = this._records.get(owner);
        if (record != null && time > -1L && record.isValidAt(time)) {
            return false;
        }
        this._records.remove(owner);
        return true;
    }

    public synchronized String stringValue() {
        StringBuilder sb = new StringBuilder();
        long now = System.currentTimeMillis();
        for (StickyRecord record : this._records.values()) {
            if (!record.isValidAt(now)) continue;
            sb.append("sticky:").append(record.owner()).append(":").append(record.expire()).append("\n");
        }
        return sb.toString();
    }

    public synchronized List<StickyRecord> records() {
        return new ArrayList<StickyRecord>(this._records.values());
    }

    public synchronized List<StickyRecord> removeExpired() {
        ArrayList<StickyRecord> removed = new ArrayList<StickyRecord>();
        long now = System.currentTimeMillis();
        Iterator<StickyRecord> i = this._records.values().iterator();
        while (i.hasNext()) {
            StickyRecord record = i.next();
            if (record.isValidAt(now)) continue;
            i.remove();
            removed.add(record);
        }
        return removed;
    }
}

