/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.v3.entry;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.pool.repository.v3.entry.state.Sticky;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheRepositoryEntryState {
    private static Logger _logBussiness = LoggerFactory.getLogger((String)"logger.org.dcache.repository");
    private static final Pattern VERSION_PATTERN = Pattern.compile("#\\s+version\\s+[0-9]\\.[0-9]");
    private static final int FORMAT_VERSION_MAJOR = 3;
    private static final int FORMAT_VERSION_MINOR = 0;
    private final Sticky _sticky = new Sticky();
    private EntryState _state;
    private final File _controlFile;

    public CacheRepositoryEntryState(File controlFile) throws IOException {
        this._controlFile = controlFile;
        this._state = EntryState.NEW;
        try {
            this.loadState();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public CacheRepositoryEntryState(File controlFile, MetaDataRecord entry) throws IOException {
        this._controlFile = controlFile;
        this._state = entry.getState();
        for (StickyRecord record : entry.stickyRecords()) {
            this._sticky.addRecord(record.owner(), record.expire(), true);
        }
        this.makeStatePersistent();
    }

    public List<StickyRecord> removeExpiredStickyFlags() {
        List<StickyRecord> removed = this._sticky.removeExpired();
        try {
            if (!removed.isEmpty()) {
                this.makeStatePersistent();
            }
        }
        catch (IOException e) {
            _logBussiness.error("Failed to store repository state: " + e.getMessage());
        }
        return removed;
    }

    public void setState(EntryState state) throws IOException {
        if (state == this._state) {
            return;
        }
        switch (state) {
            case NEW: {
                throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
            }
            case FROM_CLIENT: {
                if (this._state == EntryState.NEW) break;
                throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
            }
            case FROM_STORE: {
                if (this._state == EntryState.NEW) break;
                throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
            }
            case FROM_POOL: {
                if (this._state == EntryState.NEW) break;
                throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
            }
            case CACHED: {
                if (this._state != EntryState.REMOVED && this._state != EntryState.DESTROYED) break;
                throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
            }
            case PRECIOUS: {
                if (this._state != EntryState.REMOVED && this._state != EntryState.DESTROYED) break;
                throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
            }
            case BROKEN: {
                if (this._state != EntryState.REMOVED && this._state != EntryState.DESTROYED) break;
                throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
            }
            case REMOVED: {
                if (this._state != EntryState.DESTROYED) break;
                throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
            }
            case DESTROYED: {
                if (this._state == EntryState.REMOVED) break;
                throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
            }
        }
        this._state = state;
        this.makeStatePersistent();
    }

    public EntryState getState() {
        return this._state;
    }

    public boolean setSticky(String owner, long expire, boolean overwrite) throws IllegalStateException, IOException {
        if (this._state == EntryState.REMOVED || this._state == EntryState.DESTROYED) {
            throw new IllegalStateException("Entry in removed state");
        }
        if (this._sticky.addRecord(owner, expire, overwrite)) {
            this.makeStatePersistent();
            return true;
        }
        return false;
    }

    public boolean isSticky() {
        return this._sticky.isSet();
    }

    private void makeStatePersistent() throws IOException {
        try (BufferedWriter out = new BufferedWriter(new FileWriter(this._controlFile, false));){
            out.write("# version 3.0");
            out.newLine();
            switch (this._state) {
                case PRECIOUS: {
                    out.write("precious");
                    out.newLine();
                    break;
                }
                case CACHED: {
                    out.write("cached");
                    out.newLine();
                    break;
                }
                case FROM_CLIENT: {
                    out.write("from_client");
                    out.newLine();
                    break;
                }
                case FROM_STORE: 
                case FROM_POOL: {
                    out.write("from_store");
                    out.newLine();
                }
            }
            String state = this._sticky.stringValue();
            if (state != null && state.length() > 0) {
                out.write(state);
                out.newLine();
            }
            out.flush();
        }
    }

    private void loadState() throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(this._controlFile));){
            String line;
            this._state = EntryState.BROKEN;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() == 0) continue;
                if (line.startsWith("#")) {
                    Matcher m = VERSION_PATTERN.matcher(line);
                    if (!m.matches()) continue;
                    String[] versionLine = line.split("\\s");
                    String[] versionNumber = versionLine[2].split("\\.");
                    int major = Integer.parseInt(versionNumber[0]);
                    int minor = Integer.parseInt(versionNumber[1]);
                    if (major <= 3 && minor == 0) continue;
                    throw new IOException("control file format mismatch: supported <= 3.0 found: " + versionLine[2]);
                }
                if (line.equals("precious")) {
                    this._state = EntryState.PRECIOUS;
                    continue;
                }
                if (line.equals("cached")) {
                    this._state = EntryState.CACHED;
                    continue;
                }
                if (line.equals("from_client")) {
                    this._state = EntryState.FROM_CLIENT;
                    continue;
                }
                if (line.equals("from_store")) {
                    this._state = EntryState.FROM_STORE;
                    continue;
                }
                if (line.equals("receiving.store")) {
                    this._state = EntryState.FROM_STORE;
                    continue;
                }
                if (line.equals("receiving.cient")) {
                    this._state = EntryState.FROM_CLIENT;
                    continue;
                }
                if (line.equals("receiving.client")) {
                    this._state = EntryState.FROM_CLIENT;
                    continue;
                }
                if (line.startsWith("sticky")) {
                    long expire;
                    String owner;
                    String[] stickyOptions = line.split(":");
                    switch (stickyOptions.length) {
                        case 1: {
                            owner = "system";
                            expire = -1L;
                            break;
                        }
                        case 2: {
                            owner = stickyOptions[1];
                            expire = -1L;
                            break;
                        }
                        case 3: {
                            owner = stickyOptions[1];
                            try {
                                expire = Long.parseLong(stickyOptions[2]);
                                break;
                            }
                            catch (NumberFormatException nfe) {
                                this._state = EntryState.BROKEN;
                                if (in != null) {
                                    if (var2_2 != null) {
                                        try {
                                            in.close();
                                        }
                                        catch (Throwable x2) {
                                            var2_2.addSuppressed(x2);
                                        }
                                    } else {
                                        in.close();
                                    }
                                }
                                return;
                            }
                        }
                        default: {
                            _logBussiness.info("Unknow number of arguments in " + this._controlFile.getPath() + " [" + line + "]");
                            this._state = EntryState.BROKEN;
                            return;
                        }
                    }
                    this._sticky.addRecord(owner, expire, true);
                    continue;
                }
                _logBussiness.error("Invalid state [" + line + "] for entry " + this._controlFile);
                break;
            }
        }
    }

    public List<StickyRecord> stickyRecords() {
        return this._sticky.records();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._state == EntryState.CACHED ? "C" : "-");
        sb.append(this._state == EntryState.PRECIOUS ? "P" : "-");
        sb.append(this._state == EntryState.FROM_CLIENT ? "C" : "-");
        sb.append(this._state == EntryState.FROM_STORE || this._state == EntryState.FROM_POOL ? "S" : "-");
        sb.append("-");
        sb.append("-");
        sb.append(this._state == EntryState.REMOVED ? "R" : "-");
        sb.append(this._state == EntryState.DESTROYED ? "D" : "-");
        sb.append(this._sticky.isSet() ? "X" : "-");
        sb.append(this._state == EntryState.BROKEN ? "E" : "-");
        return sb.toString();
    }
}

