/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.meta.file;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.StorageInfo;
import diskCacheV111.vehicles.StorageInfos;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import org.dcache.namespace.FileAttribute;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.pool.repository.v3.RepositoryException;
import org.dcache.pool.repository.v3.entry.CacheRepositoryEntryState;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheRepositoryEntryImpl
implements MetaDataRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheRepositoryEntryImpl.class);
    private final CacheRepositoryEntryState _state;
    private final PnfsId _pnfsId;
    private int _linkCount;
    private StorageInfo _storageInfo;
    private long _creationTime = System.currentTimeMillis();
    private long _lastAccess;
    private long _size;
    private final File _controlFile;
    private final File _siFile;
    private final File _dataFile;

    public CacheRepositoryEntryImpl(PnfsId pnfsId, File controlFile, File dataFile, File siFile) throws IOException {
        this._pnfsId = pnfsId;
        this._controlFile = controlFile;
        this._siFile = siFile;
        this._dataFile = dataFile;
        this._state = new CacheRepositoryEntryState(this._controlFile);
        try {
            this._storageInfo = CacheRepositoryEntryImpl.readStorageInfo(siFile);
            this._creationTime = this._siFile.lastModified();
        }
        catch (FileNotFoundException fnf) {
            // empty catch block
        }
        this._lastAccess = this._dataFile.lastModified();
        this._size = this._dataFile.length();
        if (this._lastAccess == 0L) {
            this._lastAccess = this._creationTime;
        }
    }

    public CacheRepositoryEntryImpl(PnfsId pnfsId, File controlFile, File dataFile, File siFile, MetaDataRecord entry) throws IOException, RepositoryException, CacheException {
        this._pnfsId = pnfsId;
        this._controlFile = controlFile;
        this._siFile = siFile;
        this._dataFile = dataFile;
        this._lastAccess = entry.getLastAccessTime();
        this._linkCount = entry.getLinkCount();
        this._creationTime = entry.getCreationTime();
        this._size = entry.getSize();
        this._state = new CacheRepositoryEntryState(this._controlFile, entry);
        this.setFileAttributes(entry.getFileAttributes());
    }

    @Override
    public synchronized void incrementLinkCount() {
        ++this._linkCount;
    }

    @Override
    public synchronized void decrementLinkCount() {
        if (this._linkCount <= 0) {
            throw new IllegalStateException("Link count is already  zero");
        }
        --this._linkCount;
    }

    @Override
    public synchronized int getLinkCount() {
        return this._linkCount;
    }

    @Override
    public synchronized long getCreationTime() {
        return this._creationTime;
    }

    @Override
    public synchronized File getDataFile() {
        return this._dataFile;
    }

    @Override
    public synchronized long getLastAccessTime() {
        return this._lastAccess;
    }

    @Override
    public synchronized PnfsId getPnfsId() {
        return this._pnfsId;
    }

    @Override
    public synchronized void setSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Negative entry size is not allowed");
        }
        this._size = size;
    }

    @Override
    public synchronized long getSize() {
        return this._size;
    }

    @Override
    public synchronized boolean isSticky() {
        return this._state.isSticky();
    }

    @Override
    public synchronized EntryState getState() {
        return this._state.getState();
    }

    @Override
    public synchronized void setState(EntryState state) throws CacheException {
        try {
            this._state.setState(state);
        }
        catch (IOException e) {
            throw new CacheException(e.getMessage());
        }
    }

    @Override
    public synchronized List<StickyRecord> removeExpiredStickyFlags() {
        return this._state.removeExpiredStickyFlags();
    }

    @Override
    public synchronized boolean setSticky(String owner, long expire, boolean overwrite) throws CacheException {
        try {
            return this._state.setSticky(owner, expire, overwrite);
        }
        catch (IOException | IllegalStateException e) {
            throw new CacheException(e.getMessage());
        }
    }

    @Override
    public synchronized FileAttributes getFileAttributes() {
        FileAttributes attributes = new FileAttributes();
        attributes.setPnfsId(this._pnfsId);
        StorageInfo storageInfo = this.getStorageInfo();
        if (storageInfo != null) {
            StorageInfos.injectInto(storageInfo, attributes);
        }
        return attributes;
    }

    @Override
    public void setFileAttributes(FileAttributes attributes) throws CacheException {
        if (attributes.isDefined(FileAttribute.STORAGEINFO)) {
            this.setStorageInfo(StorageInfos.extractFrom(attributes));
        } else {
            this.setStorageInfo(null);
        }
    }

    @Override
    public synchronized void touch() throws CacheException {
        try {
            if (!this._dataFile.exists()) {
                this._dataFile.createNewFile();
            }
        }
        catch (IOException ee) {
            throw new CacheException("Io Error creating : " + this._dataFile);
        }
        this._lastAccess = System.currentTimeMillis();
        this._dataFile.setLastModified(this._lastAccess);
    }

    private synchronized StorageInfo getStorageInfo() {
        return this._storageInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setStorageInfo(StorageInfo storageInfo) throws CacheException {
        try {
            File siFileTemp = File.createTempFile(this._siFile.getName(), null, this._siFile.getParentFile());
            try {
                try (ObjectOutputStream objectOut = new ObjectOutputStream(new FileOutputStream(siFileTemp));){
                    objectOut.writeObject(storageInfo);
                }
                if (!siFileTemp.renameTo(this._siFile)) {
                    throw new CacheException(10, this._pnfsId + " rename failed");
                }
            }
            finally {
                if (siFileTemp.exists()) {
                    siFileTemp.delete();
                }
            }
        }
        catch (IOException e) {
            throw new CacheException(10, this._pnfsId + " " + e.getMessage(), e);
        }
        this._storageInfo = storageInfo;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static StorageInfo readStorageInfo(File objIn) throws IOException {
        try (ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(objIn)));){
            StorageInfo storageInfo = (StorageInfo)in.readObject();
            return storageInfo;
        }
        catch (Throwable t) {
            LOGGER.debug("Failed to read {}: {}", (Object)objIn.getPath(), (Object)t.toString());
            return null;
        }
    }

    @Override
    public synchronized List<StickyRecord> stickyRecords() {
        return this._state.stickyRecords();
    }

    public synchronized String toString() {
        StorageInfo si = this.getStorageInfo();
        return this._pnfsId.toString() + " <" + this._state.toString() + "-" + "(0)" + "[" + this._linkCount + "]> " + this.getSize() + " si={" + (si == null ? "<unknown>" : si.getStorageClass()) + "}";
    }
}

