/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.meta.db;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.StickyRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheRepositoryEntryState
implements Serializable {
    private static final long serialVersionUID = -715461991190516015L;
    private static Logger _log = LoggerFactory.getLogger((String)"logger.org.dcache.repository");
    private final Set<StickyRecord> _sticky = new HashSet<StickyRecord>(0);
    private boolean _precious;
    private boolean _cached;
    private boolean _toStore;
    private boolean _toClient;
    private boolean _fromClient;
    private boolean _fromStore;
    private boolean _error;
    private boolean _removed;
    private transient boolean _dirty;
    private transient EntryState _state;

    public CacheRepositoryEntryState() {
        this._state = EntryState.NEW;
    }

    public CacheRepositoryEntryState(MetaDataRecord entry) {
        this.setState(entry.getState());
        for (StickyRecord r : entry.stickyRecords()) {
            this._sticky.add(new StickyRecord(r.owner(), r.expire()));
        }
        this._dirty = true;
    }

    public EntryState getState() {
        return this._state;
    }

    public void setState(EntryState state) {
        if (state == this._state) {
            return;
        }
        switch (state) {
            case NEW: {
                throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
            }
            case FROM_CLIENT: {
                if (this._state != EntryState.NEW) {
                    throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
                }
                this._removed = false;
                this._error = false;
                this._fromStore = false;
                this._cached = false;
                this._precious = false;
                this._fromClient = true;
                break;
            }
            case FROM_STORE: {
                if (this._state != EntryState.NEW) {
                    throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
                }
                this._removed = false;
                this._error = false;
                this._fromClient = false;
                this._cached = false;
                this._precious = false;
                this._fromStore = true;
                break;
            }
            case FROM_POOL: {
                if (this._state != EntryState.NEW) {
                    throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
                }
                this._removed = false;
                this._error = false;
                this._fromClient = false;
                this._cached = false;
                this._precious = false;
                this._fromStore = true;
                break;
            }
            case CACHED: {
                if (this._state == EntryState.REMOVED || this._state == EntryState.DESTROYED) {
                    throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
                }
                this._removed = false;
                this._error = false;
                this._fromStore = false;
                this._fromClient = false;
                this._precious = false;
                this._cached = true;
                break;
            }
            case PRECIOUS: {
                if (this._state == EntryState.REMOVED || this._state == EntryState.DESTROYED) {
                    throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
                }
                this._removed = false;
                this._error = false;
                this._fromStore = false;
                this._fromClient = false;
                this._cached = false;
                this._precious = true;
                break;
            }
            case BROKEN: {
                if (this._state == EntryState.REMOVED || this._state == EntryState.DESTROYED) {
                    throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
                }
                this._removed = false;
                this._fromStore = false;
                this._fromClient = false;
                this._cached = false;
                this._precious = false;
                this._error = true;
                break;
            }
            case REMOVED: {
                if (this._state == EntryState.DESTROYED) {
                    throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
                }
                this._error = false;
                this._fromStore = false;
                this._fromClient = false;
                this._cached = false;
                this._precious = false;
                this._removed = true;
                break;
            }
            case DESTROYED: {
                if (this._state == EntryState.REMOVED) break;
                throw new IllegalStateException("Entry is " + (Object)((Object)this._state));
            }
        }
        this._state = state;
        this.markDirty();
    }

    public boolean dirty() {
        if (this._dirty) {
            this._dirty = false;
            return true;
        }
        return false;
    }

    private void markDirty() {
        this._dirty = true;
    }

    public boolean isSticky() {
        return !this._sticky.isEmpty();
    }

    public List<StickyRecord> stickyRecords() {
        return new ArrayList<StickyRecord>(this._sticky);
    }

    public List<StickyRecord> removeExpiredStickyFlags() {
        ArrayList<StickyRecord> removed = new ArrayList<StickyRecord>();
        long now = System.currentTimeMillis();
        Iterator<StickyRecord> i = this._sticky.iterator();
        while (i.hasNext()) {
            StickyRecord record = i.next();
            if (record.isValidAt(now)) continue;
            i.remove();
            removed.add(record);
            this.markDirty();
        }
        return removed;
    }

    public boolean setSticky(String owner, long expire, boolean overwrite) throws IllegalStateException {
        if (this._removed) {
            throw new IllegalStateException("Entry in removed state");
        }
        if (this.cleanSticky(owner, overwrite ? -1L : expire)) {
            if (expire == -1L || expire > System.currentTimeMillis()) {
                this._sticky.add(new StickyRecord(owner, expire));
                this.markDirty();
            }
            return true;
        }
        return false;
    }

    private boolean cleanSticky(String owner, long time) throws IllegalStateException {
        Iterator<StickyRecord> i = this._sticky.iterator();
        while (i.hasNext()) {
            StickyRecord record = i.next();
            if (!record.owner().equals(owner)) continue;
            if (time > -1L && record.isValidAt(time)) {
                return false;
            }
            i.remove();
            this.markDirty();
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._cached && !this._precious ? "C" : "-");
        sb.append(this._precious ? "P" : "-");
        sb.append(this._fromClient ? "C" : "-");
        sb.append(this._fromStore ? "S" : "-");
        sb.append(this._toClient ? "c" : "-");
        sb.append(this._toStore ? "s" : "-");
        sb.append(this._removed ? "R" : "-");
        sb.append("-");
        sb.append(this.isSticky() ? "X" : "-");
        sb.append(this._error ? "E" : "-");
        return sb.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._dirty = false;
        this._state = EntryState.BROKEN;
        if (this._fromClient) {
            this._state = EntryState.FROM_CLIENT;
        }
        if (this._fromStore) {
            this._state = EntryState.FROM_STORE;
        }
        if (this._cached) {
            this._state = EntryState.CACHED;
        }
        if (this._precious) {
            this._state = EntryState.PRECIOUS;
        }
        if (this._removed) {
            this._state = EntryState.REMOVED;
        }
        if (this._error) {
            this._state = EntryState.BROKEN;
        }
    }
}

