/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository.meta.db;

import com.sleepycat.util.RuntimeExceptionWrapper;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.DiskErrorCacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.StorageInfo;
import diskCacheV111.vehicles.StorageInfos;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.dcache.namespace.FileAttribute;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.pool.repository.meta.db.BerkeleyDBMetaDataRepository;
import org.dcache.pool.repository.meta.db.CacheRepositoryEntryState;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheRepositoryEntryImpl
implements MetaDataRecord {
    private static Logger _log = LoggerFactory.getLogger((String)"logger.org.dcache.repository");
    private final CacheRepositoryEntryState _state;
    private final PnfsId _pnfsId;
    private final BerkeleyDBMetaDataRepository _repository;
    private long _creationTime = System.currentTimeMillis();
    private long _lastAccess;
    private int _linkCount;
    private long _size;

    public CacheRepositoryEntryImpl(BerkeleyDBMetaDataRepository repository, PnfsId pnfsId) {
        this._repository = repository;
        this._pnfsId = pnfsId;
        this._state = new CacheRepositoryEntryState();
        File file = this.getDataFile();
        this._lastAccess = file.lastModified();
        this._size = file.length();
        if (this._lastAccess == 0L) {
            this._lastAccess = this._creationTime;
        }
    }

    public CacheRepositoryEntryImpl(BerkeleyDBMetaDataRepository repository, MetaDataRecord entry) {
        this._repository = repository;
        this._pnfsId = entry.getPnfsId();
        this._lastAccess = entry.getLastAccessTime();
        this._linkCount = entry.getLinkCount();
        this._creationTime = entry.getCreationTime();
        this._size = entry.getSize();
        this._state = new CacheRepositoryEntryState(entry);
        this.storeStateIfDirty();
        this.setFileAttributes(entry.getFileAttributes());
        if (this._lastAccess == 0L) {
            this._lastAccess = this._creationTime;
        }
    }

    private CacheRepositoryEntryImpl(BerkeleyDBMetaDataRepository repository, PnfsId pnfsId, CacheRepositoryEntryState state) {
        this._repository = repository;
        this._pnfsId = pnfsId;
        this._state = state;
        File file = this.getDataFile();
        this._lastAccess = file.lastModified();
        this._size = file.length();
        if (this._lastAccess == 0L) {
            this._lastAccess = this._creationTime;
        }
    }

    @Override
    public synchronized void decrementLinkCount() {
        if (this._linkCount <= 0) {
            throw new IllegalStateException("Link count is already zero");
        }
        --this._linkCount;
    }

    @Override
    public synchronized void incrementLinkCount() {
        EntryState state = this.getState();
        if (state == EntryState.REMOVED || state == EntryState.DESTROYED) {
            throw new IllegalStateException("Entry is marked as removed");
        }
        ++this._linkCount;
    }

    @Override
    public synchronized int getLinkCount() {
        return this._linkCount;
    }

    public synchronized void setCreationTime(long time) {
        this._creationTime = time;
    }

    @Override
    public synchronized long getCreationTime() {
        return this._creationTime;
    }

    @Override
    public synchronized long getLastAccessTime() {
        return this._lastAccess;
    }

    @Override
    public synchronized void setSize(long size) {
        if (size < 0L) {
            throw new IllegalArgumentException("Negative entry size is not allowed");
        }
        this._size = size;
    }

    @Override
    public synchronized long getSize() {
        return this._size;
    }

    private synchronized StorageInfo getStorageInfo() {
        return (StorageInfo)this._repository.getStorageInfoMap().get((Object)this._pnfsId.toString());
    }

    @Override
    public synchronized FileAttributes getFileAttributes() {
        FileAttributes attributes = new FileAttributes();
        attributes.setPnfsId(this._pnfsId);
        StorageInfo storageInfo = this.getStorageInfo();
        if (storageInfo != null) {
            StorageInfos.injectInto(storageInfo, attributes);
        }
        return attributes;
    }

    @Override
    public void setFileAttributes(FileAttributes attributes) {
        String id = this._pnfsId.toString();
        if (attributes.isDefined(FileAttribute.STORAGEINFO)) {
            this._repository.getStorageInfoMap().put((Object)id, (Object)StorageInfos.extractFrom(attributes));
        } else {
            this._repository.getStorageInfoMap().remove((Object)id);
        }
    }

    @Override
    public synchronized PnfsId getPnfsId() {
        return this._pnfsId;
    }

    @Override
    public synchronized EntryState getState() {
        return this._state.getState();
    }

    @Override
    public synchronized void setState(EntryState state) {
        this._state.setState(state);
        this.storeStateIfDirty();
    }

    @Override
    public synchronized boolean isSticky() {
        return this._state.isSticky();
    }

    @Override
    public synchronized File getDataFile() {
        return this._repository.getDataFile(this._pnfsId);
    }

    @Override
    public synchronized List<StickyRecord> removeExpiredStickyFlags() {
        List<StickyRecord> removed = this._state.removeExpiredStickyFlags();
        if (!removed.isEmpty()) {
            this.storeStateIfDirty();
        }
        return removed;
    }

    @Override
    public synchronized boolean setSticky(String owner, long expire, boolean overwrite) throws CacheException {
        try {
            if (this._state.setSticky(owner, expire, overwrite)) {
                this.storeStateIfDirty();
                return true;
            }
            return false;
        }
        catch (IllegalStateException e) {
            throw new CacheException(e.getMessage());
        }
    }

    @Override
    public synchronized void touch() throws CacheException {
        File file = this.getDataFile();
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            throw new DiskErrorCacheException("IO error creating: " + file);
        }
        long now = System.currentTimeMillis();
        if (!file.setLastModified(now)) {
            throw new DiskErrorCacheException("Failed to set modification time: " + file);
        }
        this._lastAccess = now;
    }

    @Override
    public synchronized List<StickyRecord> stickyRecords() {
        return this._state.stickyRecords();
    }

    public synchronized String toString() {
        StorageInfo info = this.getStorageInfo();
        return this._pnfsId.toString() + " <" + this._state.toString() + "-" + "(0)" + "[" + this.getLinkCount() + "]> " + this.getSize() + " si={" + (info == null ? "<unknown>" : info.getStorageClass()) + "}";
    }

    private synchronized void storeStateIfDirty() {
        if (this._state.dirty()) {
            this._repository.getStateMap().put((Object)this._pnfsId.toString(), (Object)this._state);
        }
    }

    static CacheRepositoryEntryImpl load(BerkeleyDBMetaDataRepository repository, PnfsId pnfsId) {
        try {
            String id = pnfsId.toString();
            CacheRepositoryEntryState state = (CacheRepositoryEntryState)repository.getStateMap().get((Object)id);
            if (state != null) {
                return new CacheRepositoryEntryImpl(repository, pnfsId, state);
            }
            _log.debug("No entry found for " + id);
        }
        catch (ClassCastException e) {
            _log.warn(e.toString());
        }
        catch (RuntimeExceptionWrapper e) {
            if (!(e.getCause() instanceof ClassNotFoundException) && !(e.getCause() instanceof ClassCastException)) {
                throw e;
            }
            _log.warn(e.toString());
        }
        return null;
    }
}

