/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository;

import com.google.common.base.Preconditions;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.dcache.pool.repository.DuplicateEntryException;
import org.dcache.pool.repository.MetaDataRecord;
import org.dcache.pool.repository.MetaDataStore;

public class MetaDataCache
implements MetaDataStore {
    private static final float LOAD_FACTOR = 0.75f;
    private final ConcurrentMap<PnfsId, Monitor> _entries;
    private final MetaDataStore _inner;
    private volatile boolean _isClosed;

    public MetaDataCache(MetaDataStore inner) {
        this._inner = inner;
        Collection<PnfsId> list = inner.list();
        this._entries = new ConcurrentHashMap<PnfsId, Monitor>((int)((float)list.size() / 0.75f + 1.0f), 0.75f);
        for (PnfsId id : list) {
            this._entries.put(id, new Monitor(id));
        }
    }

    @Override
    public MetaDataRecord get(PnfsId id) throws CacheException, InterruptedException {
        Monitor monitor = (Monitor)this._entries.get(id);
        return monitor != null ? monitor.get() : null;
    }

    @Override
    public MetaDataRecord create(PnfsId id) throws CacheException {
        return new Monitor(id).create();
    }

    @Override
    public MetaDataRecord create(MetaDataRecord entry) throws CacheException {
        return new Monitor(entry.getPnfsId()).create(entry);
    }

    @Override
    public void remove(PnfsId id) {
        Monitor monitor = (Monitor)this._entries.get(id);
        if (monitor != null) {
            monitor.remove();
        }
    }

    @Override
    public Collection<PnfsId> list() {
        return Collections.unmodifiableCollection(this._entries.keySet());
    }

    @Override
    public boolean isOk() {
        return this._inner.isOk();
    }

    @Override
    public void close() {
        this._isClosed = true;
        for (Monitor monitor : this._entries.values()) {
            monitor.close();
        }
        this._inner.close();
    }

    @Override
    public long getFreeSpace() {
        return this._inner.getFreeSpace();
    }

    @Override
    public long getTotalSpace() {
        return this._inner.getTotalSpace();
    }

    private class Monitor {
        private final PnfsId _id;
        private MetaDataRecord _record;

        private Monitor(PnfsId id) {
            this._id = id;
        }

        private synchronized MetaDataRecord get() throws InterruptedException, CacheException {
            if (MetaDataCache.this._entries.get(this._id) != this) {
                return null;
            }
            assert (MetaDataCache.this._entries.get(this._id) == this);
            if (this._record == null) {
                this._record = MetaDataCache.this._inner.get(this._id);
                if (this._record == null) {
                    MetaDataCache.this._entries.remove(this._id, this);
                }
            }
            return this._record;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized MetaDataRecord create() throws CacheException {
            if (MetaDataCache.this._entries.putIfAbsent(this._id, this) != null) {
                throw new DuplicateEntryException(this._id);
            }
            assert (MetaDataCache.this._entries.get(this._id) == this);
            try {
                Preconditions.checkState((!MetaDataCache.this._isClosed ? 1 : 0) != 0);
                this._record = MetaDataCache.this._inner.create(this._id);
            }
            finally {
                if (this._record == null) {
                    MetaDataCache.this._entries.remove(this._id);
                }
            }
            return this._record;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized MetaDataRecord create(MetaDataRecord entry) throws CacheException {
            if (MetaDataCache.this._entries.putIfAbsent(this._id, this) != null) {
                throw new DuplicateEntryException(this._id);
            }
            assert (MetaDataCache.this._entries.get(this._id) == this);
            try {
                Preconditions.checkState((!MetaDataCache.this._isClosed ? 1 : 0) != 0);
                this._record = MetaDataCache.this._inner.create(entry);
            }
            finally {
                if (this._record == null) {
                    MetaDataCache.this._entries.remove(this._id);
                }
            }
            return this._record;
        }

        private synchronized void remove() {
            if (MetaDataCache.this._entries.get(this._id) == this) {
                assert (MetaDataCache.this._entries.get(this._id) == this);
                MetaDataCache.this._inner.remove(this._id);
                MetaDataCache.this._entries.remove(this._id);
            }
        }

        private synchronized void close() {
            MetaDataCache.this._entries.remove(this._id, this);
        }
    }
}

