/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository;

import diskCacheV111.util.PnfsId;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dcache.pool.repository.FileStore;

public class FlatFileStore
implements FileStore {
    private final File _dataDir;

    public FlatFileStore(File baseDir) throws FileNotFoundException {
        if (!baseDir.isDirectory()) {
            throw new FileNotFoundException("No such directory: " + baseDir);
        }
        this._dataDir = new File(baseDir, "data");
        if (!this._dataDir.exists()) {
            if (!this._dataDir.mkdir()) {
                throw new FileNotFoundException("Failed to create directory: " + this._dataDir);
            }
        } else if (!this._dataDir.isDirectory()) {
            throw new FileNotFoundException("No such directory: " + this._dataDir);
        }
    }

    public String toString() {
        return this._dataDir.getPath();
    }

    @Override
    public File get(PnfsId id) {
        return new File(this._dataDir, id.toString());
    }

    @Override
    public List<PnfsId> list() {
        String[] files = this._dataDir.list();
        ArrayList<PnfsId> ids = new ArrayList<PnfsId>(files.length);
        for (String name : files) {
            try {
                ids.add(new PnfsId(name));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return ids;
    }

    @Override
    public long getFreeSpace() {
        return this._dataDir.getUsableSpace();
    }

    @Override
    public long getTotalSpace() {
        return this._dataDir.getTotalSpace();
    }

    @Override
    public boolean isOk() {
        try {
            File tmp = new File(this._dataDir, ".repository_is_ok");
            tmp.delete();
            tmp.deleteOnExit();
            if (!tmp.createNewFile()) {
                return false;
            }
            return tmp.exists();
        }
        catch (IOException e) {
            return false;
        }
    }
}

