/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.dcache.pool.repository.RepositoryChannel;

public class FileRepositoryChannel
implements RepositoryChannel {
    private final FileChannel _fileChannel;
    private final RandomAccessFile _raf;
    private final File _file;

    public FileRepositoryChannel(String f, String mode) throws FileNotFoundException {
        this(new File(f), mode);
    }

    public FileRepositoryChannel(File f, String mode) throws FileNotFoundException {
        this._file = f;
        this._raf = new RandomAccessFile(f, mode);
        this._fileChannel = this._raf.getChannel();
    }

    @Override
    public long position() throws IOException {
        return this._fileChannel.position();
    }

    @Override
    public RepositoryChannel position(long position) throws IOException {
        this._fileChannel.position(position);
        return this;
    }

    @Override
    public long size() throws IOException {
        return this._file.length();
    }

    @Override
    public void sync() throws SyncFailedException, IOException {
        this._raf.getFD().sync();
    }

    @Override
    public RepositoryChannel truncate(long size) throws IOException {
        this._fileChannel.truncate(size);
        return this;
    }

    @Override
    public void close() throws IOException {
        this._fileChannel.close();
    }

    @Override
    public boolean isOpen() {
        return this._fileChannel.isOpen();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this._fileChannel.read(dst);
    }

    @Override
    public int read(ByteBuffer buffer, long position) throws IOException {
        return this._fileChannel.read(buffer, position);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this._fileChannel.read(dsts, offset, length);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this._fileChannel.read(dsts);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this._fileChannel.write(src);
    }

    @Override
    public int write(ByteBuffer buffer, long position) throws IOException {
        return this._fileChannel.write(buffer, position);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this._fileChannel.write(srcs, offset, length);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this._fileChannel.write(srcs);
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        return this._fileChannel.transferTo(position, count, target);
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        return this._fileChannel.transferFrom(src, position, count);
    }
}

