/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.repository;

import org.dcache.pool.repository.SpaceRecord;

public class Account {
    private long _total;
    private long _used;
    private long _precious;
    private long _removable;
    private long _requested;

    public synchronized long getTotal() {
        return this._total;
    }

    public synchronized long getUsed() {
        return this._used;
    }

    public synchronized long getFree() {
        return this._total - this._used;
    }

    public synchronized long getRemovable() {
        return this._removable;
    }

    public synchronized long getPrecious() {
        return this._precious;
    }

    public synchronized long getRequested() {
        return this._requested;
    }

    public synchronized void setTotal(long total) {
        if (total < this._used) {
            throw new IllegalArgumentException("Cannot set repository size below amount of used space");
        }
        this._total = total;
        this.notifyAll();
    }

    public synchronized void free(long space) {
        if (space < 0L) {
            throw new IllegalArgumentException("Cannot free negative space");
        }
        if (this._used < space) {
            throw new IllegalArgumentException("Cannot set used space to a negattive value");
        }
        this.notifyAll();
        this._used -= space;
    }

    public synchronized boolean allocateNow(long request) {
        if (request < 0L) {
            throw new IllegalArgumentException("Cannot allocate negative space");
        }
        if (request > this.getFree()) {
            return false;
        }
        this.notifyAll();
        this._used += request;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void allocate(long request) throws InterruptedException {
        if (request < 0L) {
            throw new IllegalArgumentException("Cannot allocate negative space");
        }
        this._requested += request;
        try {
            while (request > this.getFree()) {
                this.notifyAll();
                this.wait();
            }
            this._used += request;
            this.notifyAll();
        }
        finally {
            this._requested -= request;
        }
    }

    public synchronized void adjustRemovable(long delta) {
        long removable = this._removable + delta;
        if (removable < 0L) {
            throw new IllegalArgumentException("Negative removable space is not allowed");
        }
        if (removable > this._total) {
            throw new IllegalArgumentException("Removable space would exceed repository size");
        }
        this._removable = removable;
        this.notifyAll();
    }

    public synchronized void adjustPrecious(long delta) {
        long precious = this._precious + delta;
        if (precious < 0L) {
            throw new IllegalArgumentException("Negative precious space is not allowed");
        }
        if (precious > this._total) {
            throw new IllegalArgumentException("Precious space would exceed repository size");
        }
        this._precious = precious;
        this.notifyAll();
    }

    public synchronized SpaceRecord getSpaceRecord() {
        return new SpaceRecord(this._total, this.getFree(), this._precious, this._removable, 0L);
    }
}

