/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.p2p;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.CacheFileAvailable;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.HttpDoorUrlInfoMessage;
import diskCacheV111.vehicles.HttpProtocolInfo;
import dmg.util.Args;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.dcache.cells.AbstractCellComponent;
import org.dcache.cells.CellCommandListener;
import org.dcache.cells.CellMessageReceiver;
import org.dcache.cells.CellStub;
import org.dcache.pool.classic.ChecksumModule;
import org.dcache.pool.p2p.Companion;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.Repository;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P2PClient
extends AbstractCellComponent
implements CellMessageReceiver,
CellCommandListener {
    private static final Logger _log = LoggerFactory.getLogger(P2PClient.class);
    private final Map<Integer, Companion> _companions = new HashMap<Integer, Companion>();
    private ScheduledExecutorService _executor;
    private Repository _repository;
    private ChecksumModule _checksumModule;
    private int _maxActive;
    private CellStub _pnfs;
    private CellStub _pool;
    private InetAddress _interface;
    public static final String hh_pp_set_pnfs_timeout = "<Timeout/sec>";
    public static final String hh_pp_set_max_active = "<normalization>";
    public static final String hh_pp_set_port = "<port> # Obsolete";
    public static final String fh_pp_set_listen = "The command is deprecated. Use 'pp interface' instead.";
    public static final String hh_pp_set_listen = "<address> # Deprecated";
    public static final String fh_pp_interface = "Specifies the interface used when connecting to other pools.\n\nFor pool to pool transfers, the destination creates a TCP\nconection to the source pool. For this to work the source pool\nmust select one of its network interfaces to which the destination\npool can connect. For compatibility reasons this interface is\nnot specified explicitly on the source pool. Instead an interface\non the target pool is specified and the source pool selects an\ninterface facing the target interface.\n\nIf * is provided then an interface is selected automatically.";
    public static final String hh_pp_interface = "[<address>]";
    public static final String hh_pp_get_file = "<pnfsId> <pool>";
    public static final String hh_pp_remove = "<id>";
    public static final String hh_pp_ls = " # get the list of companions";

    public synchronized void setExecutor(ScheduledExecutorService executor) {
        this._executor = executor;
    }

    public synchronized void setRepository(Repository repository) {
        this._repository = repository;
    }

    public synchronized void setChecksumModule(ChecksumModule csm) {
        this._checksumModule = csm;
    }

    public synchronized void setPnfs(CellStub pnfs) {
        this._pnfs = pnfs;
    }

    public synchronized void setPool(CellStub pool) {
        this._pool = pool;
    }

    public synchronized int getActiveJobs() {
        return this._companions.size() <= this._maxActive ? this._companions.size() : this._maxActive;
    }

    public synchronized int getMaxActiveJobs() {
        return this._maxActive;
    }

    public synchronized int getQueueSize() {
        return this._companions.size() > this._maxActive ? this._companions.size() - this._maxActive : 0;
    }

    public synchronized InetAddress getInterface() throws UnknownHostException {
        return this._interface == null ? InetAddress.getLocalHost() : this._interface;
    }

    public synchronized void messageArrived(DoorTransferFinishedMessage message) {
        HttpProtocolInfo pinfo = (HttpProtocolInfo)message.getProtocolInfo();
        int sessionId = pinfo.getSessionId();
        Companion companion = this._companions.get(sessionId);
        if (companion != null) {
            companion.messageArrived(message);
        }
    }

    public synchronized void messageArrived(HttpDoorUrlInfoMessage message) {
        int sessionId = (int)message.getId();
        Companion companion = this._companions.get(sessionId);
        if (companion != null) {
            companion.messageArrived(message);
        }
    }

    private synchronized int addCompanion(Companion companion) {
        int sessionId = companion.getId();
        this._companions.put(sessionId, companion);
        return sessionId;
    }

    private synchronized void removeCompanion(int sessionId) {
        this._companions.remove(sessionId);
        this.notifyAll();
    }

    private synchronized void cancelCompanions(PnfsId pnfsId, String cause) {
        for (Companion companion : this._companions.values()) {
            if (!pnfsId.equals(companion.getPnfsId())) continue;
            companion.cancel(cause);
        }
    }

    public synchronized int newCompanion(String sourcePoolName, FileAttributes fileAttributes, EntryState targetState, List<StickyRecord> stickyRecords, CacheFileAvailable callback, boolean forceSourceMode) throws IOException, CacheException, InterruptedException {
        if (this.getCellEndpoint() == null) {
            throw new IllegalStateException("Endpoint not initialized");
        }
        if (this._pool == null) {
            throw new IllegalStateException("Pool stub not initialized");
        }
        if (this._executor == null) {
            throw new IllegalStateException("Executor not initialized");
        }
        if (this._repository == null) {
            throw new IllegalStateException("Repository not initialized");
        }
        if (this._checksumModule == null) {
            throw new IllegalStateException("Checksum module not initialized");
        }
        if (this._pnfs == null) {
            throw new IllegalStateException("PNFS stub not initialized");
        }
        if (this._repository.getState(fileAttributes.getPnfsId()) != EntryState.NEW) {
            throw new IllegalStateException("Replica already exists");
        }
        Callback cb = new Callback(callback);
        Companion companion = new Companion(this._executor, this.getInterface(), this._repository, this._checksumModule, this._pnfs, this._pool, fileAttributes, sourcePoolName, this.getCellName(), this.getCellDomainName(), targetState, stickyRecords, cb, forceSourceMode);
        int id = this.addCompanion(companion);
        cb.setId(id);
        return id;
    }

    public synchronized boolean cancel(int id) {
        Companion companion = this._companions.get(id);
        return companion == null ? false : companion.cancel("Transfer was cancelled");
    }

    public synchronized void shutdown() throws InterruptedException {
        for (Companion companion : this._companions.values()) {
            companion.cancel("Pool is going down");
        }
        while (!this._companions.isEmpty()) {
            this.wait();
        }
    }

    @Override
    public synchronized void getInfo(PrintWriter pw) {
        try {
            pw.println("  Interface  : " + this.getInterface());
        }
        catch (UnknownHostException e) {
            pw.println("  Interface  : " + e.getMessage());
        }
        pw.println("  Max Active : " + this._maxActive);
        pw.println("Pnfs Timeout : " + this._pnfs.getTimeout() / 1000L + " seconds ");
    }

    @Override
    public synchronized void printSetup(PrintWriter pw) {
        pw.println("#\n#  Pool to Pool (P2P) [$Revision$]\n#");
        pw.println("pp set max active " + this._maxActive);
        pw.println("pp set pnfs timeout " + this._pnfs.getTimeout() / 1000L);
        if (this._interface != null) {
            pw.println("pp interface " + this._interface.getHostAddress());
        }
    }

    public synchronized String ac_pp_set_pnfs_timeout_$_1(Args args) {
        long timeout = Long.parseLong(args.argv(0));
        this._pnfs.setTimeout(timeout * 1000L);
        return "Pnfs timeout set to " + timeout + " seconds";
    }

    public synchronized String ac_pp_set_max_active_$_1(Args args) {
        this._maxActive = Integer.parseInt(args.argv(0));
        return "";
    }

    public synchronized String ac_pp_set_port_$_1(Args args) {
        return "'pp set port' is obsolete";
    }

    public synchronized String ac_pp_set_listen_$_1_2(Args args) throws UnknownHostException {
        return this.ac_pp_interface_$_0_1(new Args((CharSequence)args.argv(0)));
    }

    public synchronized String ac_pp_interface_$_0_1(Args args) throws UnknownHostException {
        if (args.argc() == 1) {
            String host = args.argv(0);
            this._interface = host.equals("*") ? null : InetAddress.getByName(host);
        }
        return "PP interface is " + this.getInterface();
    }

    public synchronized String ac_pp_get_file_$_2(Args args) throws CacheException, IOException, InterruptedException {
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setPnfsId(new PnfsId(args.argv(0)));
        String pool = args.argv(1);
        List<StickyRecord> stickyRecords = Collections.emptyList();
        this.newCompanion(pool, fileAttributes, EntryState.CACHED, stickyRecords, null, false);
        return "Transfer Initiated";
    }

    public synchronized String ac_pp_remove_$_1(Args args) throws NumberFormatException {
        int id = Integer.valueOf(args.argv(0));
        if (!this.cancel(id)) {
            throw new IllegalArgumentException("Id not found: " + id);
        }
        return "";
    }

    public synchronized String ac_pp_ls(Args args) {
        StringBuilder sb = new StringBuilder();
        for (Companion c : this._companions.values()) {
            sb.append(c.toString()).append("\n");
        }
        return sb.toString();
    }

    private class Callback
    implements CacheFileAvailable {
        private CacheFileAvailable _callback;
        private int _id;

        Callback(CacheFileAvailable callback) {
            this._callback = callback;
            this._id = -1;
        }

        synchronized void setId(int id) {
            this._id = id;
            this.notifyAll();
        }

        synchronized int getId() throws InterruptedException {
            while (this._id == -1) {
                this.wait();
            }
            return this._id;
        }

        @Override
        public void cacheFileAvailable(PnfsId pnfsId, Throwable t) {
            try {
                if (this._callback != null) {
                    this._callback.cacheFileAvailable(pnfsId, t);
                }
                P2PClient.this.removeCompanion(this.getId());
                if (t == null) {
                    P2PClient.this.cancelCompanions(pnfsId, "Replica already exists");
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

