/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.p2p;

import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.HttpDoorUrlInfoMessage;
import org.dcache.pool.p2p.Companion;
import statemap.FSMContext;
import statemap.State;
import statemap.StateUndefinedException;
import statemap.TransitionUndefinedException;

public class CompanionContext
extends FSMContext {
    private transient Companion _owner;

    public CompanionContext(Companion owner) {
        super((State)FSM.Init);
        this._owner = owner;
    }

    public CompanionContext(Companion owner, CompanionState initState) {
        super((State)initState);
        this._owner = owner;
    }

    public void enterStartState() {
        this.getState().Entry(this);
    }

    public void cancel(Object error) {
        this._transition = "cancel";
        this.getState().cancel(this, error);
        this._transition = "";
    }

    public void createEntryFailed() {
        this._transition = "createEntryFailed";
        this.getState().createEntryFailed(this);
        this._transition = "";
    }

    public void failure(Integer rc, Object cause) {
        this._transition = "failure";
        this.getState().failure(this, rc, cause);
        this._transition = "";
    }

    public void messageArrived(DoorTransferFinishedMessage message) {
        this._transition = "messageArrived";
        this.getState().messageArrived(this, message);
        this._transition = "";
    }

    public void messageArrived(HttpDoorUrlInfoMessage message) {
        this._transition = "messageArrived";
        this.getState().messageArrived(this, message);
        this._transition = "";
    }

    public void noroute() {
        this._transition = "noroute";
        this.getState().noroute(this);
        this._transition = "";
    }

    public void start() {
        this._transition = "start";
        this.getState().start(this);
        this._transition = "";
    }

    public void success() {
        this._transition = "success";
        this.getState().success(this);
        this._transition = "";
    }

    public void timeout() {
        this._transition = "timeout";
        this.getState().timeout(this);
        this._transition = "";
    }

    public void timer() {
        this._transition = "timer";
        this.getState().timer(this);
        this._transition = "";
    }

    public void transferEnded(Object error) {
        this._transition = "transferEnded";
        this.getState().transferEnded(this, error);
        this._transition = "";
    }

    public CompanionState getState() throws StateUndefinedException {
        if (this._state == null) {
            throw new StateUndefinedException();
        }
        return (CompanionState)this._state;
    }

    protected Companion getOwner() {
        return this._owner;
    }

    public void setOwner(Companion owner) {
        if (owner == null) {
            throw new NullPointerException("null owner");
        }
        this._owner = owner;
    }

    private static final class FSM_Done
    extends FSM_Default {
        private FSM_Done(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(CompanionContext context) {
            Companion ctxt = context.getOwner();
            ctxt.done();
        }
    }

    private static final class FSM_Failed
    extends FSM_Default {
        private FSM_Failed(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(CompanionContext context) {
            Companion ctxt = context.getOwner();
            ctxt.done();
        }
    }

    private static final class FSM_Cancelling
    extends FSM_Default {
        private FSM_Cancelling(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(CompanionContext context) {
            Companion ctxt = context.getOwner();
            ctxt.interrupt();
        }

        @Override
        protected void cancel(CompanionContext context, Object error) {
            context.getState().Exit(context);
            context.setState(FSM.Cancelling);
            context.getState().Entry(context);
        }

        @Override
        protected void messageArrived(CompanionContext context, DoorTransferFinishedMessage message) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void transferEnded(CompanionContext context, Object error) {
            Companion ctxt = context.getOwner();
            if (error == null) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.clearError();
                }
                finally {
                    context.setState(FSM.Done);
                    context.getState().Entry(context);
                }
            } else {
                super.transferEnded(context, error);
            }
        }
    }

    private static final class FSM_DoorFinished
    extends FSM_Default {
        private FSM_DoorFinished(String name, int id) {
            super(name, id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel(CompanionContext context, Object error) {
            Companion ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.setError(error);
            }
            finally {
                context.setState(FSM.Cancelling);
                context.getState().Entry(context);
            }
        }

        @Override
        protected void transferEnded(CompanionContext context, Object error) {
            if (error == null) {
                context.getState().Exit(context);
                context.setState(FSM.Done);
                context.getState().Entry(context);
            } else {
                super.transferEnded(context, error);
            }
        }
    }

    private static final class FSM_Transferring
    extends FSM_Default {
        private FSM_Transferring(String name, int id) {
            super(name, id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel(CompanionContext context, Object error) {
            Companion ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.setError(error);
            }
            finally {
                context.setState(FSM.Cancelling);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void messageArrived(CompanionContext context, DoorTransferFinishedMessage message) {
            Companion ctxt = context.getOwner();
            if (message.getReturnCode() == 0) {
                context.getState().Exit(context);
                context.setState(FSM.DoorFinished);
                context.getState().Entry(context);
            } else if (message.getReturnCode() != 0) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.setError(message.getErrorObject());
                }
                finally {
                    context.setState(FSM.Cancelling);
                    context.getState().Entry(context);
                }
            } else {
                super.messageArrived(context, message);
            }
        }

        @Override
        protected void transferEnded(CompanionContext context, Object error) {
            if (error == null) {
                context.getState().Exit(context);
                context.setState(FSM.Done);
                context.getState().Entry(context);
            } else {
                super.transferEnded(context, error);
            }
        }
    }

    private static final class FSM_WaitingForURLInfoMessage
    extends FSM_Default {
        private FSM_WaitingForURLInfoMessage(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(CompanionContext context) {
            Companion ctxt = context.getOwner();
            ctxt.startTimer(ctxt.getPingPeriod());
        }

        @Override
        protected void Exit(CompanionContext context) {
            Companion ctxt = context.getOwner();
            ctxt.stopTimer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void failure(CompanionContext context, Integer rc, Object cause) {
            Companion ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.setError("Ping failed (" + cause + ")");
            }
            finally {
                context.setState(FSM.Failed);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void messageArrived(CompanionContext context, HttpDoorUrlInfoMessage message) {
            Companion ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.beginTransfer(message.getUrl());
            }
            finally {
                context.setState(FSM.Transferring);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void noroute(CompanionContext context) {
            Companion ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.setError("Ping failed (no route to cell)");
            }
            finally {
                context.setState(FSM.Failed);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void success(CompanionContext context) {
            Companion ctxt = context.getOwner();
            CompanionState endState = context.getState();
            context.clearState();
            try {
                ctxt.startTimer(ctxt.getPingPeriod());
            }
            finally {
                context.setState(endState);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void timeout(CompanionContext context) {
            Companion ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.setError("Ping failed (no response)");
            }
            finally {
                context.setState(FSM.Failed);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void timer(CompanionContext context) {
            Companion ctxt = context.getOwner();
            CompanionState endState = context.getState();
            context.clearState();
            try {
                ctxt.ping();
            }
            finally {
                context.setState(endState);
            }
        }
    }

    private static final class FSM_CreatingMover
    extends FSM_Default {
        private FSM_CreatingMover(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(CompanionContext context) {
            Companion ctxt = context.getOwner();
            ctxt.sendDeliveryRequest();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void failure(CompanionContext context, Integer rc, Object cause) {
            Companion ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.setError("Source pool failed (" + cause + ")");
            }
            finally {
                context.setState(FSM.Failed);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void messageArrived(CompanionContext context, HttpDoorUrlInfoMessage message) {
            Companion ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.beginTransfer(message.getUrl());
            }
            finally {
                context.setState(FSM.Transferring);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void noroute(CompanionContext context) {
            Companion ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.setError("Source pool failed (no route to cell)");
            }
            finally {
                context.setState(FSM.Failed);
                context.getState().Entry(context);
            }
        }

        @Override
        protected void success(CompanionContext context) {
            context.getState().Exit(context);
            context.setState(FSM.WaitingForURLInfoMessage);
            context.getState().Entry(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void timeout(CompanionContext context) {
            Companion ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.setError("Source pool failed (no response)");
            }
            finally {
                context.setState(FSM.Failed);
                context.getState().Entry(context);
            }
        }
    }

    private static final class FSM_GettingFileAttributes
    extends FSM_Default {
        private FSM_GettingFileAttributes(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(CompanionContext context) {
            Companion ctxt = context.getOwner();
            ctxt.fetchFileAttributes();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void failure(CompanionContext context, Integer rc, Object cause) {
            Companion ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.setError("Failed to get file attributes (" + cause + ")");
            }
            finally {
                context.setState(FSM.Failed);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void noroute(CompanionContext context) {
            Companion ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.setError("Failed to get file attributes (no route to cell)");
            }
            finally {
                context.setState(FSM.Failed);
                context.getState().Entry(context);
            }
        }

        @Override
        protected void success(CompanionContext context) {
            context.getState().Exit(context);
            context.setState(FSM.CreatingMover);
            context.getState().Entry(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void timeout(CompanionContext context) {
            Companion ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.setError("Failed to get file attributes (timeout)");
            }
            finally {
                context.setState(FSM.Failed);
                context.getState().Entry(context);
            }
        }
    }

    private static final class FSM_Init
    extends FSM_Default {
        private FSM_Init(String name, int id) {
            super(name, id);
        }

        @Override
        protected void start(CompanionContext context) {
            Companion ctxt = context.getOwner();
            if (!ctxt.hasRequiredAttributes()) {
                context.getState().Exit(context);
                context.setState(FSM.GettingFileAttributes);
                context.getState().Entry(context);
            } else if (ctxt.hasRequiredAttributes()) {
                context.getState().Exit(context);
                context.setState(FSM.CreatingMover);
                context.getState().Entry(context);
            } else {
                super.start(context);
            }
        }
    }

    protected static class FSM_Default
    extends CompanionState {
        protected FSM_Default(String name, int id) {
            super(name, id);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void createEntryFailed(CompanionContext context) {
            Companion ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.setError("Replica already exists");
            }
            finally {
                context.setState(FSM.Failed);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel(CompanionContext context, Object error) {
            Companion ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.setError(error);
            }
            finally {
                context.setState(FSM.Failed);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void messageArrived(CompanionContext context, DoorTransferFinishedMessage message) {
            Companion ctxt = context.getOwner();
            if (message.getReturnCode() != 0) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.setError(message.getErrorObject());
                }
                finally {
                    context.setState(FSM.Failed);
                    context.getState().Entry(context);
                }
            } else {
                super.messageArrived(context, message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void transferEnded(CompanionContext context, Object error) {
            Companion ctxt = context.getOwner();
            if (error != null) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.setError(error);
                }
                finally {
                    context.setState(FSM.Failed);
                    context.getState().Entry(context);
                }
            } else {
                super.transferEnded(context, error);
            }
        }

        @Override
        protected void Default(CompanionContext context) {
        }
    }

    static abstract class FSM {
        public static final FSM_Init Init = new FSM_Init("FSM.Init", 0);
        public static final FSM_GettingFileAttributes GettingFileAttributes = new FSM_GettingFileAttributes("FSM.GettingFileAttributes", 1);
        public static final FSM_CreatingMover CreatingMover = new FSM_CreatingMover("FSM.CreatingMover", 2);
        public static final FSM_WaitingForURLInfoMessage WaitingForURLInfoMessage = new FSM_WaitingForURLInfoMessage("FSM.WaitingForURLInfoMessage", 3);
        public static final FSM_Transferring Transferring = new FSM_Transferring("FSM.Transferring", 4);
        public static final FSM_DoorFinished DoorFinished = new FSM_DoorFinished("FSM.DoorFinished", 5);
        public static final FSM_Cancelling Cancelling = new FSM_Cancelling("FSM.Cancelling", 6);
        public static final FSM_Failed Failed = new FSM_Failed("FSM.Failed", 7);
        public static final FSM_Done Done = new FSM_Done("FSM.Done", 8);
        private static final FSM_Default Default = new FSM_Default("FSM.Default", -1);

        FSM() {
        }
    }

    public static abstract class CompanionState
    extends State {
        protected CompanionState(String name, int id) {
            super(name, id);
        }

        protected void Entry(CompanionContext context) {
        }

        protected void Exit(CompanionContext context) {
        }

        protected void cancel(CompanionContext context, Object error) {
            this.Default(context);
        }

        protected void createEntryFailed(CompanionContext context) {
            this.Default(context);
        }

        protected void failure(CompanionContext context, Integer rc, Object cause) {
            this.Default(context);
        }

        protected void messageArrived(CompanionContext context, DoorTransferFinishedMessage message) {
            this.Default(context);
        }

        protected void messageArrived(CompanionContext context, HttpDoorUrlInfoMessage message) {
            this.Default(context);
        }

        protected void noroute(CompanionContext context) {
            this.Default(context);
        }

        protected void start(CompanionContext context) {
            this.Default(context);
        }

        protected void success(CompanionContext context) {
            this.Default(context);
        }

        protected void timeout(CompanionContext context) {
            this.Default(context);
        }

        protected void timer(CompanionContext context) {
            this.Default(context);
        }

        protected void transferEnded(CompanionContext context, Object error) {
            this.Default(context);
        }

        protected void Default(CompanionContext context) {
            throw new TransitionUndefinedException("State: " + context.getState().getName() + ", Transition: " + context.getTransition());
        }
    }
}

