/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.p2p;

import com.google.common.base.Preconditions;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.CacheFileAvailable;
import diskCacheV111.util.ChecksumFactory;
import diskCacheV111.util.FileInCacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.DoorTransferFinishedMessage;
import diskCacheV111.vehicles.HttpDoorUrlInfoMessage;
import diskCacheV111.vehicles.HttpProtocolInfo;
import diskCacheV111.vehicles.IoJobInfo;
import diskCacheV111.vehicles.PoolDeliverFileMessage;
import dmg.cells.nucleus.CellPath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.SyncFailedException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.CellStub;
import org.dcache.namespace.FileAttribute;
import org.dcache.pool.classic.ChecksumModule;
import org.dcache.pool.p2p.CompanionContext;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.pool.repository.Repository;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.util.Checksum;
import org.dcache.util.FireAndForgetTask;
import org.dcache.vehicles.FileAttributes;
import org.dcache.vehicles.PnfsGetFileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Companion {
    private static final EnumSet<FileAttribute> REQUIRED_ATTRIBUTES = EnumSet.of(FileAttribute.PNFSID, FileAttribute.STORAGEINFO, FileAttribute.CHECKSUM, FileAttribute.SIZE);
    private static final Logger _log = LoggerFactory.getLogger(Companion.class);
    private static final long PING_PERIOD = TimeUnit.MINUTES.toMillis(5L);
    private static final int BUFFER_SIZE = 65536;
    private static final String PROTOCOL_INFO_NAME = "Http";
    private static final int PROTOCOL_INFO_MAJOR_VERSION = 1;
    private static final int PROTOCOL_INFO_MINOR_VERSION = 1;
    private static final AtomicInteger _nextId = new AtomicInteger(100);
    private static final long CONNECT_TIMEOUT = TimeUnit.MINUTES.toMillis(5L);
    private static final long READ_TIMEOUT = TimeUnit.MINUTES.toMillis(10L);
    private final InetAddress _address;
    private final Repository _repository;
    private final ChecksumModule _checksumModule;
    private final String _sourcePoolName;
    private final String _destinationPoolCellname;
    private final String _destinationPoolCellDomainName;
    private final EntryState _targetState;
    private final List<StickyRecord> _stickyRecords;
    private final CacheFileAvailable _callback;
    private final ScheduledExecutorService _executor;
    private final CellStub _pnfs;
    private final CellStub _pool;
    private final boolean _forceSourceMode;
    private final CompanionContext _fsm = new CompanionContext(this);
    private final int _id;
    private FileAttributes _fileAttributes;
    private Object _error;
    private Thread _thread;
    private ScheduledFuture<?> _timerTask;
    private int _moverId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Companion(ScheduledExecutorService executor, InetAddress address, Repository repository, ChecksumModule checksumModule, CellStub pnfs, CellStub pool, FileAttributes fileAttributes, String sourcePoolName, String destinationPoolCellname, String destinationPoolCellDomainName, EntryState targetState, List<StickyRecord> stickyRecords, CacheFileAvailable callback, boolean forceSourceMode) {
        this._executor = executor;
        this._address = address;
        this._repository = repository;
        this._checksumModule = checksumModule;
        this._pnfs = pnfs;
        this._pool = pool;
        this._sourcePoolName = sourcePoolName;
        Preconditions.checkNotNull((Object)fileAttributes);
        Preconditions.checkNotNull((Object)destinationPoolCellname, (Object)"Destination pool name is unknown. Aborting the request.");
        Preconditions.checkNotNull((Object)destinationPoolCellDomainName, (Object)"Destination domain name is unknown. Aborting the request");
        this._destinationPoolCellname = destinationPoolCellname;
        this._destinationPoolCellDomainName = destinationPoolCellDomainName;
        this._callback = callback;
        this._forceSourceMode = forceSourceMode;
        this._targetState = targetState;
        this._stickyRecords = new ArrayList<StickyRecord>(stickyRecords);
        if (fileAttributes != null) {
            this.setFileAttributes(fileAttributes);
        }
        this._id = _nextId.getAndIncrement();
        Companion companion = this;
        synchronized (companion) {
            this._fsm.start();
        }
    }

    public synchronized int getId() {
        return this._id;
    }

    public synchronized PnfsId getPnfsId() {
        return this._fileAttributes.getPnfsId();
    }

    public synchronized long getPingPeriod() {
        return PING_PERIOD;
    }

    public synchronized boolean cancel(Object cause) {
        this._fsm.cancel(cause);
        return this._fsm.getState() != CompanionContext.FSM.Done;
    }

    public synchronized String toString() {
        return "" + this._id + " " + this.getPnfsId() + " " + (Object)((Object)this._fsm.getState());
    }

    public synchronized void messageArrived(DoorTransferFinishedMessage message) {
        this._fsm.messageArrived(message);
    }

    public synchronized void messageArrived(HttpDoorUrlInfoMessage message) {
        this._fsm.messageArrived(message);
    }

    private synchronized void setThread(Thread thread) {
        this._thread = thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transfer(String uri) {
        Object file;
        ReplicaDescriptor handle;
        Companion companion = this;
        synchronized (companion) {
            try {
                handle = this.createReplicaEntry();
            }
            catch (FileInCacheException e) {
                this._fsm.createEntryFailed();
                return;
            }
            this.setThread(Thread.currentThread());
        }
        Throwable error = null;
        try {
            try {
                MessageDigest digest;
                ChecksumFactory checksumFactory;
                file = handle.getFile();
                long size = handle.getFileAttributes().getSize();
                handle.allocate(size);
                if (this._checksumModule.hasPolicy(ChecksumModule.PolicyFlag.ON_TRANSFER)) {
                    checksumFactory = this._checksumModule.getPreferredChecksumFactory(handle);
                    digest = checksumFactory.create();
                } else {
                    checksumFactory = null;
                    digest = null;
                }
                HttpURLConnection connection = this.createConnection(uri);
                try (InputStream input = connection.getInputStream();){
                    long total = this.copy(input, (File)file, digest);
                    if (total != size) {
                        throw new IOException("Amount of received data does not match expected file size");
                    }
                }
                finally {
                    connection.disconnect();
                }
                Set<Checksum> actualChecksums = digest == null ? Collections.emptySet() : Collections.singleton(checksumFactory.create(digest.digest()));
                this._checksumModule.enforcePostTransferPolicy(handle, actualChecksums);
            }
            finally {
                this.setThread(null);
                Thread.interrupted();
            }
            handle.commit();
        }
        catch (Throwable e) {
            error = e;
        }
        finally {
            handle.close();
            file = this;
            synchronized (file) {
                this._fsm.transferEnded(error);
            }
        }
    }

    private ReplicaDescriptor createReplicaEntry() throws FileInCacheException {
        return this._repository.createEntry(this._fileAttributes, EntryState.FROM_POOL, this._targetState, this._stickyRecords, EnumSet.of(Repository.OpenFlags.CREATEFILE));
    }

    private HttpURLConnection createConnection(String uri) throws MalformedURLException, IOException {
        URL url = new URL(uri);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestProperty("Connection", "close");
        connection.setConnectTimeout((int)CONNECT_TIMEOUT);
        connection.setReadTimeout((int)READ_TIMEOUT);
        connection.connect();
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long copy(InputStream input, File file, MessageDigest digest) throws IOException {
        long total = 0L;
        try (RandomAccessFile dataFile = new RandomAccessFile(file, "rw");){
            try {
                int read;
                byte[] buffer = new byte[65536];
                while ((read = input.read(buffer)) > -1) {
                    dataFile.write(buffer, 0, read);
                    total += (long)read;
                    if (digest == null) continue;
                    digest.update(buffer, 0, read);
                }
            }
            finally {
                try {
                    dataFile.getFD().sync();
                }
                catch (SyncFailedException e) {
                    _log.warn("Failed to synchronize file with storage device: {}", (Object)e.getMessage());
                }
            }
        }
        return total;
    }

    synchronized void setError(Object error) {
        if (this._error == null) {
            this._error = error;
        }
    }

    synchronized void clearError() {
        this._error = null;
    }

    synchronized boolean hasRequiredAttributes() {
        return this._fileAttributes.isDefined(REQUIRED_ATTRIBUTES);
    }

    synchronized void fetchFileAttributes() {
        this._pnfs.send(new PnfsGetFileAttributes(this.getPnfsId(), REQUIRED_ATTRIBUTES), PnfsGetFileAttributes.class, new Callback<PnfsGetFileAttributes>(){

            @Override
            public void success(PnfsGetFileAttributes message) {
                Companion.this.setFileAttributes(message.getFileAttributes());
                super.success(message);
            }
        });
    }

    synchronized void setFileAttributes(FileAttributes fileAttributes) {
        this._fileAttributes = fileAttributes;
    }

    synchronized void startTimer(long delay) {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Companion companion = Companion.this;
                synchronized (companion) {
                    if (Companion.this._timerTask != null) {
                        Companion.this._fsm.timer();
                        Companion.this._timerTask = null;
                    }
                }
            }
        };
        this._timerTask = this._executor.schedule(new FireAndForgetTask(task), delay, TimeUnit.MILLISECONDS);
    }

    synchronized void stopTimer() {
        if (this._timerTask != null) {
            this._timerTask.cancel(false);
            this._timerTask = null;
        }
    }

    synchronized void sendDeliveryRequest() {
        HttpProtocolInfo protocolInfo = new HttpProtocolInfo(PROTOCOL_INFO_NAME, 1, 1, new InetSocketAddress(this._address, 0), this._destinationPoolCellname, this._destinationPoolCellDomainName, "/" + this.getPnfsId(), null);
        protocolInfo.setSessionId(this._id);
        PoolDeliverFileMessage request = new PoolDeliverFileMessage(this._sourcePoolName, protocolInfo, this._fileAttributes);
        request.setPool2Pool();
        request.setInitiator(this.getInitiator());
        request.setId(this._id);
        request.setForceSourceMode(this._forceSourceMode);
        this._pool.send(new CellPath(this._sourcePoolName), request, PoolDeliverFileMessage.class, new Callback<PoolDeliverFileMessage>(){

            @Override
            public void success(PoolDeliverFileMessage message) {
                Companion.this.setMoverId(message.getMoverId());
                super.success(message);
            }
        });
    }

    private String getInitiator() {
        return "pool:" + this._destinationPoolCellname + "@" + this._destinationPoolCellDomainName;
    }

    synchronized void setMoverId(int moverId) {
        this._moverId = moverId;
    }

    synchronized void ping() {
        this._pool.send(new CellPath(this._sourcePoolName), (Serializable)((Object)("p2p ls -binary " + this._moverId)), IoJobInfo.class, new Callback());
    }

    synchronized void beginTransfer(final String uri) {
        new Thread("P2P Transfer - " + this.getPnfsId()){

            @Override
            public void run() {
                Companion.this.transfer(uri);
            }
        }.start();
    }

    synchronized void done() {
        if (this._thread != null) {
            throw new IllegalStateException("Cannot close a companion while the transfer is in progress");
        }
        if (this._error != null) {
            if (this._error instanceof RuntimeException) {
                _log.error(String.format("P2P for %s failed: %s", this.getPnfsId(), this._error), (Throwable)((Exception)this._error));
            } else {
                _log.error(String.format("P2P for %s failed: %s", this.getPnfsId(), this._error));
            }
        } else {
            _log.info(String.format("P2P for %s completed", this.getPnfsId()));
        }
        if (this._callback != null) {
            final Object error = this._error;
            this._executor.execute(new FireAndForgetTask(new Runnable(){

                @Override
                public void run() {
                    Throwable t = error == null ? null : (error instanceof Throwable ? (Throwable)error : new CacheException(error.toString()));
                    Companion.this._callback.cacheFileAvailable(Companion.this.getPnfsId(), t);
                }
            }));
        }
    }

    synchronized void interrupt() {
        if (this._thread != null) {
            this._thread.interrupt();
        }
    }

    class Callback<T>
    extends AbstractMessageCallback<T> {
        Callback() {
        }

        @Override
        public void success(T message) {
            Companion.this._executor.execute(new FireAndForgetTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Companion companion = Companion.this;
                    synchronized (companion) {
                        Companion.this._fsm.success();
                    }
                }
            }));
        }

        @Override
        public void failure(final int rc, final Object cause) {
            Companion.this._executor.execute(new FireAndForgetTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Companion companion = Companion.this;
                    synchronized (companion) {
                        Companion.this._fsm.failure(rc, cause);
                    }
                }
            }));
        }

        @Override
        public void timeout(CellPath path) {
            Companion.this._executor.execute(new FireAndForgetTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Companion companion = Companion.this;
                    synchronized (companion) {
                        Companion.this._fsm.timeout();
                    }
                }
            }));
        }

        @Override
        public void noroute(CellPath path) {
            Companion.this._executor.execute(new FireAndForgetTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Companion companion = Companion.this;
                    synchronized (companion) {
                        Companion.this._fsm.noroute();
                    }
                }
            }));
        }
    }
}

