/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.movers;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class VspDataOutputStream
extends DataOutputStream {
    private static final int IOCMD_WRITE = 1;
    private static final int IOCMD_READ = 2;
    private static final int IOCMD_SEEK = 3;
    private static final int IOCMD_CLOSE = 4;
    private static final int IOCMD_INTERRUPT = 5;
    private static final int IOCMD_ACK = 6;
    private static final int IOCMD_FIN = 7;
    private static final int IOCMD_DATA = 8;
    private static final int IOCMD_LOCATE = 9;
    private static final int IOCMD_STATUS = 10;
    private static final int IOCMD_SEEK_AND_READ = 11;
    private static final int IOCMD_SEEK_AND_WRITE = 11;
    private static final int IOCMD_SEEK_SET = 0;
    private static final int IOCMD_SEEK_CURRENT = 1;
    private static final int IOCMD_SEEK_END = 2;

    public VspDataOutputStream(OutputStream out) {
        super(out);
    }

    public void writeCmdData(byte[] data, int offset, int size) throws IOException {
        this.writeInt(4);
        this.writeInt(8);
        this.writeInt(size);
        this.write(data, offset, size);
        this.writeInt(-1);
        this.flush();
    }

    public void writeCmdSeek(long offset, int whence) throws IOException {
        this.writeInt(16);
        this.writeInt(3);
        this.writeLong(offset);
        this.writeInt(whence);
        this.flush();
    }

    public void writeCmdLocate() throws IOException {
        this.writeInt(4);
        this.writeInt(9);
        this.flush();
    }

    public void writeCmdWrite() throws IOException {
        this.writeInt(4);
        this.writeInt(1);
        this.flush();
    }

    public void writeCmdRead(long size) throws IOException {
        this.writeInt(12);
        this.writeInt(2);
        this.writeLong(size);
        this.flush();
    }

    public void writeCmdSeekAndRead(long offset, int whence, long size) throws IOException {
        this.writeInt(24);
        this.writeInt(11);
        this.writeLong(offset);
        this.writeInt(whence);
        this.writeLong(size);
        this.flush();
    }

    public void writeCmdClose() throws IOException {
        this.writeInt(4);
        this.writeInt(4);
        this.flush();
    }

    public void writeACK(int command) throws IOException {
        this.writeInt(12);
        this.writeInt(6);
        this.writeInt(command);
        this.writeInt(0);
        this.flush();
    }

    public void writeACK(int command, int returnCode, String message) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(message);
        dos.flush();
        dos.close();
        byte[] msgBytes = baos.toByteArray();
        int len = 12 + msgBytes.length;
        this.writeInt(len);
        this.writeInt(6);
        this.writeInt(command);
        this.writeInt(returnCode);
        this.write(msgBytes, 0, msgBytes.length);
        this.flush();
    }

    public void writeACK(long location, long size) throws IOException {
        this.writeInt(28);
        this.writeInt(6);
        this.writeInt(9);
        this.writeInt(0);
        this.writeLong(location);
        this.writeLong(size);
        this.flush();
    }

    public void writeACK(long location) throws IOException {
        this.writeInt(20);
        this.writeInt(6);
        this.writeInt(3);
        this.writeInt(0);
        this.writeLong(location);
        this.flush();
    }

    public void writeFIN(int command) throws IOException {
        this.writeInt(12);
        this.writeInt(7);
        this.writeInt(command);
        this.writeInt(0);
        this.flush();
    }

    public void writeFIN(int command, int returnCode, String message) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeUTF(message);
        dos.flush();
        dos.close();
        byte[] msgBytes = baos.toByteArray();
        int len = 12 + msgBytes.length;
        this.writeInt(len);
        this.writeInt(7);
        this.writeInt(command);
        this.writeInt(returnCode);
        this.write(msgBytes, 0, msgBytes.length);
        this.flush();
    }

    public void writeDATA_HEADER() throws IOException {
        this.writeInt(4);
        this.writeInt(8);
        this.flush();
    }

    public void writeDATA_TRAILER() throws IOException {
        this.writeInt(-1);
        this.flush();
    }

    public void writeDATA_BLOCK(byte[] data, int offset, int size) throws IOException {
        this.writeInt(size);
        this.write(data, offset, size);
        this.flush();
    }
}

