/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.movers;

import diskCacheV111.util.Base64;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.RemoteHttpDataTransferProtocolInfo;
import diskCacheV111.vehicles.StorageInfos;
import dmg.cells.nucleus.CellEndpoint;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.MoverProtocol;
import org.dcache.pool.repository.Allocator;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteHttpDataTransferProtocol_1
implements MoverProtocol {
    private static final Logger _log = LoggerFactory.getLogger(RemoteHttpDataTransferProtocol_1.class);
    private static final int INC_SPACE = 0x3200000;
    private long allocated_space;
    private long last_transfer_time = System.currentTimeMillis();
    private long starttime;
    private volatile long transferred;

    public RemoteHttpDataTransferProtocol_1(CellEndpoint cell) {
    }

    @Override
    public void runIO(FileAttributes fileAttributes, RepositoryChannel fileChannel, ProtocolInfo protocol, Allocator allocator, IoMode access) throws CacheException, IOException, InterruptedException {
        PnfsId pnfsId = fileAttributes.getPnfsId();
        if (_log.isInfoEnabled()) {
            _log.info("Active HTTP: Protocol={}, StorageInfo={}, PnfsId={}, Access={}", new Object[]{protocol, StorageInfos.extractFrom(fileAttributes), pnfsId, access});
        }
        if (!(protocol instanceof RemoteHttpDataTransferProtocolInfo)) {
            throw new CacheException("protocol info is not RemoteHttpDataTransferProtocolInfo");
        }
        this.starttime = System.currentTimeMillis();
        RemoteHttpDataTransferProtocolInfo remoteHttpProtocolInfo = (RemoteHttpDataTransferProtocolInfo)protocol;
        URL remoteURL = new URL(remoteHttpProtocolInfo.getSourceHttpUrl());
        URLConnection connection = remoteURL.openConnection();
        if (!(connection instanceof HttpURLConnection)) {
            throw new CacheException("URL is not usable with active HTTP mover: " + remoteURL);
        }
        HttpURLConnection httpconnection = (HttpURLConnection)connection;
        String userInfo = remoteURL.getUserInfo();
        if (userInfo != null) {
            String userPassEncoding = Base64.byteArrayToBase64((byte[])userInfo.getBytes());
            httpconnection.setRequestProperty("Authorization", "Basic " + userPassEncoding);
        }
        if (access == IoMode.WRITE) {
            int read;
            httpconnection.setDoInput(true);
            httpconnection.setDoOutput(false);
            InputStream httpinput = httpconnection.getInputStream();
            byte[] buffer = new byte[remoteHttpProtocolInfo.getBufferSize()];
            ByteBuffer bb = ByteBuffer.wrap(buffer);
            allocator.allocate(0x3200000L);
            this.allocated_space += 0x3200000L;
            while ((read = httpinput.read(buffer)) != -1) {
                this.last_transfer_time = System.currentTimeMillis();
                if (this.transferred + (long)read > this.allocated_space) {
                    allocator.allocate(0x3200000L);
                    this.allocated_space += 0x3200000L;
                }
                bb.limit(read);
                fileChannel.write(bb);
                this.transferred += (long)read;
                bb.clear();
            }
        } else {
            httpconnection.setDoInput(false);
            httpconnection.setDoOutput(true);
            OutputStream httpoutput = httpconnection.getOutputStream();
            throw new UnsupportedOperationException("srmCopy upload not implemented for HTTP");
        }
    }

    @Override
    public long getLastTransferred() {
        return this.last_transfer_time;
    }

    @Override
    public long getBytesTransferred() {
        return this.transferred;
    }

    @Override
    public long getTransferTime() {
        return System.currentTimeMillis() - this.starttime;
    }
}

