/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.movers;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.ChecksumFactory;
import diskCacheV111.util.PnfsHandler;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import diskCacheV111.vehicles.StorageInfos;
import diskCacheV111.vehicles.transferManager.RemoteGsiftpTransferProtocolInfo;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellPath;
import dmg.cells.nucleus.NoRouteToCellException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.EnumSet;
import java.util.Set;
import org.dcache.namespace.FileAttribute;
import org.dcache.pool.movers.ChecksumMover;
import org.dcache.pool.movers.DataBlocksRecipient;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.MoverProtocol;
import org.dcache.pool.repository.Allocator;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.srm.util.GridftpClient;
import org.dcache.util.Checksum;
import org.dcache.util.ChecksumType;
import org.dcache.vehicles.FileAttributes;
import org.globus.ftp.Buffer;
import org.globus.ftp.exception.ClientException;
import org.globus.ftp.exception.ServerException;
import org.globus.gsi.CredentialException;
import org.globus.util.GlobusURL;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteGsiftpTransferProtocol_1
implements MoverProtocol,
ChecksumMover,
DataBlocksRecipient {
    private static final Logger _log = LoggerFactory.getLogger(RemoteGsiftpTransferProtocol_1.class);
    private static final int SERVER_SOCKET_TIMEOUT = 300000;
    private static final CellPath PNFS_MANAGER = new CellPath("PnfsManager");
    private final CellEndpoint _cell;
    private long _starttime;
    private long _timeout_time;
    private PnfsId _pnfsId;
    private ChecksumFactory _checksumFactory;
    private MessageDigest _transferMessageDigest;
    private long _previousUpdateEndOffset;
    private RepositoryChannel _fileChannel;
    private GridftpClient _client;
    private GridftpClient.Checksum _ftpCksm;

    public RemoteGsiftpTransferProtocol_1(CellEndpoint cell) {
        this._cell = cell;
    }

    private void createFtpClient(RemoteGsiftpTransferProtocolInfo protocolInfo) throws ServerException, ClientException, CredentialException, GSSException, IOException {
        if (this._client != null) {
            return;
        }
        GlobusURL url = new GlobusURL(protocolInfo.getGsiftpUrl());
        this._client = new GridftpClient(url.getHost(), url.getPort(), protocolInfo.getTcpBufferSize(), (GSSCredential)protocolInfo.getCredential());
        this._client.setStreamsNum(protocolInfo.getNumberOfStreams());
        this._client.setTcpBufferSize(protocolInfo.getTcpBufferSize());
    }

    @Override
    public void runIO(FileAttributes fileAttributes, RepositoryChannel fileChannel, ProtocolInfo protocol, Allocator allocator, IoMode access) throws CacheException, IOException, NoRouteToCellException, ServerException, ClientException, CredentialException, GSSException {
        this._pnfsId = fileAttributes.getPnfsId();
        if (_log.isDebugEnabled()) {
            _log.debug("runIO()\n\tprotocol=" + protocol + ",\n\tStorageInfo=" + StorageInfos.extractFrom(fileAttributes) + ",\n\tPnfsId=" + this._pnfsId + ",\n\taccess =" + (Object)((Object)access));
        }
        if (!(protocol instanceof RemoteGsiftpTransferProtocolInfo)) {
            throw new CacheException("protocol info is not RemoteGsiftpransferProtocolInfo");
        }
        this._fileChannel = fileChannel;
        this._starttime = System.currentTimeMillis();
        RemoteGsiftpTransferProtocolInfo remoteGsiftpProtocolInfo = (RemoteGsiftpTransferProtocolInfo)protocol;
        if (this._checksumFactory != null) {
            ChecksumFactory factory = this.getChecksumFactory(remoteGsiftpProtocolInfo);
            if (factory != null) {
                this._checksumFactory = factory;
            }
            this._transferMessageDigest = this._checksumFactory.create();
        }
        this.createFtpClient(remoteGsiftpProtocolInfo);
        if (access == IoMode.WRITE) {
            this.gridFTPRead(remoteGsiftpProtocolInfo, fileAttributes.getStorageInfo(), allocator);
        } else {
            this.gridFTPWrite(remoteGsiftpProtocolInfo, fileAttributes.getStorageInfo());
        }
        _log.debug(" runIO() done");
    }

    @Override
    public long getLastTransferred() {
        return this._client == null ? 0L : this._client.getLastTransferTime();
    }

    private synchronized void setTimeoutTime(long t) {
        this._timeout_time = t;
    }

    private synchronized long getTimeoutTime() {
        return this._timeout_time;
    }

    @Override
    public long getBytesTransferred() {
        return this._client == null ? 0L : this._client.getTransfered();
    }

    @Override
    public long getTransferTime() {
        return System.currentTimeMillis() - this._starttime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gridFTPRead(RemoteGsiftpTransferProtocolInfo protocolInfo, StorageInfo storage, Allocator allocator) throws CacheException {
        try {
            GlobusURL src_url = new GlobusURL(protocolInfo.getGsiftpUrl());
            boolean emode = protocolInfo.isEmode();
            long size = this._client.getSize(src_url.getPath());
            _log.debug(" received a file size info: " + size + " allocating space on the pool");
            _log.debug("ALLOC: " + this._pnfsId + " : " + size);
            allocator.allocate(size);
            _log.debug(" allocated space " + size);
            DiskDataSourceSink sink = new DiskDataSourceSink(protocolInfo.getBufferSize(), false);
            try {
                this._client.gridFTPRead(src_url.getPath(), (GridftpClient.IDiskDataSourceSink)sink, emode);
            }
            finally {
                this._client.close();
            }
        }
        catch (Exception e) {
            _log.error(e.toString());
            throw new CacheException(e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gridFTPWrite(RemoteGsiftpTransferProtocolInfo protocolInfo, StorageInfo storage) throws CacheException {
        _log.debug("gridFTPWrite started");
        try {
            PnfsHandler pnfs = new PnfsHandler(this._cell, PNFS_MANAGER);
            FileAttributes attributes = pnfs.getFileAttributes(this._pnfsId, EnumSet.of(FileAttribute.CHECKSUM));
            Set<Checksum> checksums = attributes.getChecksums();
            if (!checksums.isEmpty()) {
                Checksum checksum = checksums.iterator().next();
                _log.debug("Will use " + checksum + " for transfer verification of " + this._pnfsId);
                this._client.setChecksum(checksum.getType().getName(), null);
            } else {
                _log.debug("PnfsId " + this._pnfsId + " does not have checksums");
            }
            GlobusURL dst_url = new GlobusURL(protocolInfo.getGsiftpUrl());
            boolean emode = protocolInfo.isEmode();
            try {
                DiskDataSourceSink source = new DiskDataSourceSink(protocolInfo.getBufferSize(), true);
                this._client.gridFTPWrite((GridftpClient.IDiskDataSourceSink)source, dst_url.getPath(), emode, true);
            }
            finally {
                this._client.close();
            }
        }
        catch (Exception e) {
            _log.error(e.toString());
            throw new CacheException(e.toString());
        }
    }

    @Override
    public Checksum getExpectedChecksum() {
        try {
            if (this._ftpCksm != null) {
                return ChecksumFactory.getFactory(ChecksumType.getChecksumType((String)this._ftpCksm.type)).create(this._ftpCksm.value);
            }
        }
        catch (IllegalArgumentException | NoSuchAlgorithmException e) {
            _log.error("Checksum algorithm is not supported: " + e.getMessage());
        }
        return null;
    }

    @Override
    public Checksum getActualChecksum() {
        try {
            if (this._transferMessageDigest == null) {
                return null;
            }
            ByteBuffer buffer = ByteBuffer.allocate(131072);
            this._fileChannel.position(this._previousUpdateEndOffset);
            while (this._fileChannel.read(buffer) >= 0) {
                buffer.flip();
                this._transferMessageDigest.update(buffer);
                buffer.clear();
            }
            return this._checksumFactory.create(this._transferMessageDigest.digest());
        }
        catch (IOException e) {
            _log.error(e.toString());
            return null;
        }
    }

    private ChecksumFactory getChecksumFactory(RemoteGsiftpTransferProtocolInfo remoteGsiftpProtocolInfo) {
        try {
            this.createFtpClient(remoteGsiftpProtocolInfo);
            GlobusURL src_url = new GlobusURL(remoteGsiftpProtocolInfo.getGsiftpUrl());
            this._ftpCksm = this._client.negotiateCksm(src_url.getPath());
            return ChecksumFactory.getFactory(ChecksumType.getChecksumType((String)this._ftpCksm.type));
        }
        catch (IllegalArgumentException | NoSuchAlgorithmException e) {
            _log.error("Checksum algorithm is not supported: " + e.getMessage());
        }
        catch (CredentialException e) {
            _log.error("Failed to authenticate with FTP server: " + e.getMessage());
        }
        catch (GSSException e) {
            _log.error("Failed to authenticate with FTP server: " + e.getMessage());
        }
        catch (IOException e) {
            _log.error("I/O failure talking to FTP server: " + e.getMessage());
        }
        catch (Exception e) {
            _log.error("Failed to negotiate checksum with FTP server: " + e.getMessage());
        }
        return null;
    }

    @Override
    public void enableTransferChecksum(ChecksumType suggestedAlgorithm) throws NoSuchAlgorithmException {
        this._checksumFactory = ChecksumFactory.getFactory(suggestedAlgorithm);
        this._transferMessageDigest = this._checksumFactory != null ? this._checksumFactory.create() : null;
    }

    @Override
    public synchronized void receiveEBlock(byte[] array, int offset, int length, long offsetOfArrayInFile) throws IOException {
        if (array == null) {
            return;
        }
        ByteBuffer bb = ByteBuffer.wrap(array, offset, length);
        this._fileChannel.write(bb, offsetOfArrayInFile);
        if (this._transferMessageDigest != null && this._previousUpdateEndOffset == offsetOfArrayInFile) {
            this._previousUpdateEndOffset += (long)length;
            this._transferMessageDigest.update(array, offset, length);
        }
    }

    static {
        ChecksumType[] types = ChecksumType.values();
        String[] names = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            names[i] = types[i].getName();
        }
        GridftpClient.setSupportedChecksumTypes((String[])names);
    }

    private class DiskDataSourceSink
    implements GridftpClient.IDiskDataSourceSink {
        private final int _buf_size;
        private final boolean _source;
        private long _last_transfer_time = System.currentTimeMillis();
        private long _transferred;

        public DiskDataSourceSink(int buf_size, boolean source) {
            this._buf_size = buf_size;
            this._source = source;
        }

        public synchronized void write(Buffer buffer) throws IOException {
            if (this._source) {
                String error = "DiskDataSourceSink is source and write is called";
                _log.error(error);
                throw new IllegalStateException(error);
            }
            this._last_transfer_time = System.currentTimeMillis();
            int read = buffer.getLength();
            long offset = buffer.getOffset();
            if (offset >= 0L) {
                RemoteGsiftpTransferProtocol_1.this.receiveEBlock(buffer.getBuffer(), 0, read, buffer.getOffset());
            } else {
                RemoteGsiftpTransferProtocol_1.this.receiveEBlock(buffer.getBuffer(), 0, read, this._transferred);
            }
            this._transferred += (long)read;
        }

        public synchronized void close() {
            _log.debug("DiskDataSink.close() called");
            this._last_transfer_time = System.currentTimeMillis();
        }

        public long totalSize() throws IOException {
            return this._source ? RemoteGsiftpTransferProtocol_1.this._fileChannel.size() : -1L;
        }

        public synchronized long getLast_transfer_time() {
            return this._last_transfer_time;
        }

        public synchronized long getTransfered() {
            return this._transferred;
        }

        public synchronized Buffer read() throws IOException {
            if (!this._source) {
                String error = "DiskDataSourceSink is sink and read is called";
                _log.error(error);
                throw new IllegalStateException(error);
            }
            this._last_transfer_time = System.currentTimeMillis();
            byte[] bytes = new byte[this._buf_size];
            ByteBuffer bb = ByteBuffer.wrap(bytes);
            int read = RemoteGsiftpTransferProtocol_1.this._fileChannel.read(bb);
            if (read == -1) {
                return null;
            }
            Buffer buffer = new Buffer(bytes, read, this._transferred);
            this._transferred += (long)read;
            return buffer;
        }

        public String getCksmValue(String type) throws IOException, NoSuchAlgorithmException {
            try {
                PnfsHandler pnfs = new PnfsHandler(RemoteGsiftpTransferProtocol_1.this._cell, PNFS_MANAGER);
                FileAttributes attributes = pnfs.getFileAttributes(RemoteGsiftpTransferProtocol_1.this._pnfsId, EnumSet.of(FileAttribute.CHECKSUM));
                Checksum pnfsChecksum = ChecksumFactory.getFactory(ChecksumType.getChecksumType((String)type)).find(attributes.getChecksums());
                if (pnfsChecksum != null) {
                    String hexValue = pnfsChecksum.getValue();
                    _log.debug(type + " read from pnfs for file " + RemoteGsiftpTransferProtocol_1.this._pnfsId + " is " + hexValue);
                    return hexValue;
                }
            }
            catch (Exception e) {
                _log.error("could not get " + type + " from pnfs:");
                _log.error(e.toString());
                _log.error("ignoring this error");
            }
            String hexValue = GridftpClient.getCksmValue((ReadableByteChannel)RemoteGsiftpTransferProtocol_1.this._fileChannel, (String)type);
            RemoteGsiftpTransferProtocol_1.this._fileChannel.position(0L);
            return hexValue;
        }

        public long getAdler32() throws IOException {
            try {
                String hexValue = this.getCksmValue("adler32");
                return Long.parseLong(hexValue, 16);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IOException("adler 32 is not supported:" + ex.toString());
            }
        }

        public long length() throws IOException {
            return RemoteGsiftpTransferProtocol_1.this._fileChannel.size();
        }
    }
}

