/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.movers;

import com.google.common.base.Preconditions;
import diskCacheV111.util.DiskErrorCacheException;
import diskCacheV111.vehicles.PoolIoFileMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import dmg.cells.nucleus.CellPath;
import java.io.IOException;
import org.dcache.pool.classic.PostTransferService;
import org.dcache.pool.classic.TransferService;
import org.dcache.pool.movers.AbstractMover;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.Mover;
import org.dcache.pool.movers.MoverChannel;
import org.dcache.pool.repository.ReplicaDescriptor;

public abstract class MoverChannelMover<P extends ProtocolInfo, M extends Mover<P>>
extends AbstractMover<P, M> {
    private volatile MoverChannel<P> _wrappedChannel;

    public MoverChannelMover(ReplicaDescriptor handle, PoolIoFileMessage message, CellPath pathToDoor, TransferService<M> transferService, PostTransferService postTransferService) {
        super(handle, message, pathToDoor, transferService, postTransferService);
    }

    @Override
    public long getTransferTime() {
        MoverChannel<P> channel = this._wrappedChannel;
        return channel == null ? 0L : channel.getTransferTime();
    }

    @Override
    public long getBytesTransferred() {
        MoverChannel<P> channel = this._wrappedChannel;
        return channel == null ? 0L : channel.getBytesTransferred();
    }

    @Override
    public long getLastTransferred() {
        MoverChannel<P> channel = this._wrappedChannel;
        return channel == null ? 0L : channel.getLastTransferred();
    }

    public synchronized MoverChannel<P> open() throws DiskErrorCacheException {
        Preconditions.checkState((this._wrappedChannel == null ? 1 : 0) != 0);
        this._wrappedChannel = new MoverChannel(this, this.openChannel());
        return this._wrappedChannel;
    }

    @Override
    protected String getStatus() {
        StringBuilder s = new StringBuilder(this._protocolInfo.getProtocol());
        try {
            if (this._wrappedChannel != null && this.getIoMode() == IoMode.WRITE) {
                long size = this._wrappedChannel.size();
                s.append(":SU=").append(size);
                s.append(";SA=").append(this._wrappedChannel.getAllocated());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return s.toString();
    }
}

