/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.movers;

import com.google.common.base.Preconditions;
import diskCacheV111.vehicles.ProtocolInfo;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.SyncFailedException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.Mover;
import org.dcache.pool.repository.Allocator;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoverChannel<T extends ProtocolInfo>
implements RepositoryChannel {
    private static final Logger _logSpaceAllocation = LoggerFactory.getLogger((String)("logger.dev.org.dcache.poolspacemonitor." + MoverChannel.class.getName()));
    private static final long SPACE_INC = 0x3200000L;
    private final RepositoryChannel _channel;
    private final IoMode _mode;
    private final Allocator _allocator;
    private final long _transferStarted = System.currentTimeMillis();
    private final AtomicLong _lastTransferred = new AtomicLong(this._transferStarted);
    private final AtomicLong _bytesTransferred = new AtomicLong(0L);
    private final T _protocolInfo;
    private final FileAttributes _fileAttributes;
    private long _reserved;

    public MoverChannel(Mover<T> mover, RepositoryChannel channel) {
        this(mover.getIoMode(), mover.getFileAttributes(), mover.getProtocolInfo(), channel, mover.getIoHandle());
    }

    public MoverChannel(IoMode mode, FileAttributes attributes, T protocolInfo, RepositoryChannel channel, Allocator allocator) {
        this._mode = mode;
        this._protocolInfo = protocolInfo;
        this._channel = channel;
        this._allocator = allocator;
        this._fileAttributes = attributes;
    }

    @Override
    public long position() throws IOException {
        return this._channel.position();
    }

    @Override
    public synchronized MoverChannel<T> position(long position) throws IOException {
        this._channel.position(position);
        return this;
    }

    @Override
    public long size() throws IOException {
        return this._channel.size();
    }

    @Override
    public void sync() throws SyncFailedException, IOException {
        this._channel.sync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized MoverChannel<T> truncate(long size) throws IOException {
        try {
            this._channel.truncate(size);
            MoverChannel moverChannel = this;
            return moverChannel;
        }
        finally {
            this._lastTransferred.set(System.currentTimeMillis());
        }
    }

    @Override
    public void close() throws IOException {
        this._lastTransferred.set(System.currentTimeMillis());
        this._channel.close();
    }

    @Override
    public boolean isOpen() {
        return this._channel.isOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(ByteBuffer dst) throws IOException {
        try {
            int bytes = this._channel.read(dst);
            this._bytesTransferred.getAndAdd(bytes);
            int n = bytes;
            return n;
        }
        finally {
            this._lastTransferred.set(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(ByteBuffer buffer, long position) throws IOException {
        try {
            int bytes = this._channel.read(buffer, position);
            this._bytesTransferred.getAndAdd(bytes);
            int n = bytes;
            return n;
        }
        finally {
            this._lastTransferred.set(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        try {
            long bytes = this._channel.read(dsts, offset, length);
            this._bytesTransferred.getAndAdd(bytes);
            long l = bytes;
            return l;
        }
        finally {
            this._lastTransferred.set(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long read(ByteBuffer[] dsts) throws IOException {
        try {
            long bytes = this._channel.read(dsts);
            this._bytesTransferred.getAndAdd(bytes);
            long l = bytes;
            return l;
        }
        finally {
            this._lastTransferred.set(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int write(ByteBuffer src) throws IOException {
        try {
            this.preallocate(this.position() + (long)src.remaining());
            int bytes = this._channel.write(src);
            this._bytesTransferred.getAndAdd(bytes);
            int n = bytes;
            return n;
        }
        finally {
            this._lastTransferred.set(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer buffer, long position) throws IOException {
        try {
            this.preallocate(position + (long)buffer.remaining());
            int bytes = this._channel.write(buffer, position);
            this._bytesTransferred.getAndAdd(bytes);
            int n = bytes;
            return n;
        }
        finally {
            this._lastTransferred.set(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        try {
            long remaining = 0L;
            for (int i = offset; i < offset + length; ++i) {
                remaining += (long)srcs[i].remaining();
            }
            this.preallocate(this.position() + remaining);
            long bytes = this._channel.write(srcs, offset, length);
            this._bytesTransferred.getAndAdd(bytes);
            long l = bytes;
            return l;
        }
        finally {
            this._lastTransferred.set(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized long write(ByteBuffer[] srcs) throws IOException {
        try {
            long remaining = 0L;
            for (ByteBuffer src : srcs) {
                remaining += (long)src.remaining();
            }
            this.preallocate(this.position() + remaining);
            long bytes = this._channel.write(srcs);
            this._bytesTransferred.getAndAdd(bytes);
            long l = bytes;
            return l;
        }
        finally {
            this._lastTransferred.set(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        try {
            long bytes = this._channel.transferTo(position, count, target);
            this._bytesTransferred.getAndAdd(bytes);
            long l = bytes;
            return l;
        }
        finally {
            this._lastTransferred.set(System.currentTimeMillis());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        try {
            this.preallocate(position + count);
            long bytes = this._channel.transferFrom(src, position, count);
            this._bytesTransferred.getAndAdd(bytes);
            long l = bytes;
            return l;
        }
        finally {
            this._lastTransferred.set(System.currentTimeMillis());
        }
    }

    public IoMode getIoMode() {
        return this._mode;
    }

    public T getProtocolInfo() {
        return this._protocolInfo;
    }

    public FileAttributes getFileAttributes() {
        return this._fileAttributes;
    }

    public long getBytesTransferred() {
        return this._bytesTransferred.get();
    }

    public long getTransferTime() {
        return (this._channel.isOpen() ? System.currentTimeMillis() : this.getLastTransferred()) - this._transferStarted;
    }

    public long getLastTransferred() {
        return this._lastTransferred.get();
    }

    public synchronized long getAllocated() {
        return this._reserved;
    }

    private synchronized void preallocate(long pos) throws IOException {
        try {
            Preconditions.checkArgument((pos >= 0L ? 1 : 0) != 0);
            if (pos > this._reserved) {
                long delta = Math.max(pos - this._reserved, 0x3200000L);
                _logSpaceAllocation.trace("preallocate: {}", (Object)delta);
                this._allocator.allocate(delta);
                this._reserved += delta;
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        catch (IllegalStateException e) {
            throw new ClosedChannelException();
        }
    }
}

