/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.movers;

import diskCacheV111.util.CacheException;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.DCapClientPortAvailableMessage;
import diskCacheV111.vehicles.DCapClientProtocolInfo;
import diskCacheV111.vehicles.ProtocolInfo;
import diskCacheV111.vehicles.StorageInfo;
import diskCacheV111.vehicles.StorageInfos;
import dmg.cells.nucleus.CellEndpoint;
import dmg.cells.nucleus.CellMessage;
import dmg.cells.nucleus.CellPath;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.MoverProtocol;
import org.dcache.pool.repository.Allocator;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.util.NetworkUtils;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCapClientProtocol_1
implements MoverProtocol {
    private static final Logger _log = LoggerFactory.getLogger(DCapClientProtocol_1.class);
    public static final int READ = 1;
    public static final int WRITE = 2;
    private long last_transfer_time = System.currentTimeMillis();
    private final CellEndpoint cell;
    private DCapClientProtocolInfo dcapClient;
    private long starttime;
    private volatile long transfered;

    public DCapClientProtocol_1(CellEndpoint cell) {
        this.cell = cell;
        this.say("DCapClientProtocol_1 created");
    }

    private void say(String str) {
        _log.info(str);
    }

    private void esay(String str) {
        _log.error(str);
    }

    private void esay(Throwable t) {
        _log.error(t.toString());
    }

    @Override
    public void runIO(FileAttributes fileAttributes, RepositoryChannel fileChannel, ProtocolInfo protocol, Allocator allocator, IoMode access) throws Exception {
        ServerSocket serverSocket;
        PnfsId pnfsId = fileAttributes.getPnfsId();
        StorageInfo storage = StorageInfos.extractFrom(fileAttributes);
        this.say("runIO()\n\tprotocol=" + protocol + ",\n\tStorageInfo=" + storage + ",\n\tPnfsId=" + pnfsId + ",\n\taccess =" + (Object)((Object)access));
        if (!(protocol instanceof DCapClientProtocolInfo)) {
            throw new CacheException("protocol info is not RemoteGsiftpransferProtocolInfo");
        }
        this.starttime = System.currentTimeMillis();
        this.dcapClient = (DCapClientProtocolInfo)protocol;
        CellPath cellpath = new CellPath(this.dcapClient.getInitiatorCellName(), this.dcapClient.getInitiatorCellDomain());
        this.say(" runIO() RemoteGsiftpTranferManager cellpath=" + cellpath);
        try {
            serverSocket = new ServerSocket(0, 1);
        }
        catch (IOException ioe) {
            this.esay("exception while trying to create a server socket : " + ioe);
            throw ioe;
        }
        int port = serverSocket.getLocalPort();
        InetAddress localAddress = NetworkUtils.getLocalAddress((InetAddress)this.dcapClient.getSocketAddress().getAddress());
        DCapClientPortAvailableMessage cred_request = new DCapClientPortAvailableMessage(localAddress.getCanonicalHostName(), port, this.dcapClient.getId());
        this.say(" runIO() created message");
        this.cell.sendMessage(new CellMessage(cellpath, (Serializable)cred_request));
        this.say("waiting for dcap server connection");
        Socket dcap_socket = serverSocket.accept();
        this.say("connected");
        try {
            serverSocket.close();
        }
        catch (IOException ioe) {
            this.esay("failed to close server socket");
            this.esay(ioe);
        }
        if (access != IoMode.WRITE) {
            throw new IOException("read is not implemented");
        }
        this.dcapReadFile(dcap_socket, fileChannel, allocator);
        this.say(" runIO() done");
    }

    @Override
    public long getLastTransferred() {
        return this.last_transfer_time;
    }

    @Override
    public long getBytesTransferred() {
        return this.transfered;
    }

    @Override
    public long getTransferTime() {
        return System.currentTimeMillis() - this.starttime;
    }

    private void dcapReadFile(Socket _socket, RepositoryChannel fileChannel, Allocator allocator) throws Exception {
        int nextPacket;
        this.last_transfer_time = System.currentTimeMillis();
        DataInputStream in = new DataInputStream(_socket.getInputStream());
        DataOutputStream out = new DataOutputStream(_socket.getOutputStream());
        this.say("<init>");
        int _sessionId = in.readInt();
        for (int challengeSize = in.readInt(); challengeSize > 0; challengeSize -= in.skipBytes(challengeSize)) {
        }
        this.say("<gettingFilesize>");
        out.writeInt(4);
        out.writeInt(9);
        int following = in.readInt();
        if (following < 28) {
            throw new IOException("Protocol Violation : ack too small : " + following);
        }
        int type = in.readInt();
        if (type != 6) {
            throw new IOException("Protocol Violation : NOT REQUEST_ACK : " + type);
        }
        int mode = in.readInt();
        if (mode != 9) {
            throw new IOException("Protocol Violation : NOT SEEK : " + mode);
        }
        int returnCode = in.readInt();
        if (returnCode != 0) {
            String error = in.readUTF();
            throw new IOException("Seek Request Failed : (" + returnCode + ") " + error);
        }
        long filesize = in.readLong();
        this.say("<WaitingForSpace-" + filesize + ">");
        allocator.allocate(filesize);
        in.readLong();
        this.say("<StartingIO>");
        out.writeInt(12);
        out.writeInt(2);
        out.writeLong(filesize);
        following = in.readInt();
        if (following < 12) {
            throw new IOException("Protocol Violation : ack too small : " + following);
        }
        type = in.readInt();
        if (type != 6) {
            throw new IOException("Protocol Violation : NOT REQUEST_ACK : " + type);
        }
        mode = in.readInt();
        if (mode != 2) {
            throw new IOException("Protocol Violation : NOT SEEK : " + mode);
        }
        returnCode = in.readInt();
        if (returnCode != 0) {
            String error = in.readUTF();
            throw new IOException("Read Request Failed : (" + returnCode + ") " + error);
        }
        this.say("<RunningIO>");
        following = in.readInt();
        if (following < 4) {
            throw new IOException("Protocol Violation : ack too small : " + following);
        }
        type = in.readInt();
        if (type != 8) {
            throw new IOException("Protocol Violation : NOT DATA : " + type);
        }
        byte[] data = new byte[262144];
        ByteBuffer bb = ByteBuffer.wrap(data);
        while ((nextPacket = in.readInt()) >= 0) {
            int block;
            for (int restPacket = nextPacket; restPacket > 0; restPacket -= block) {
                bb.clear();
                block = Math.min(restPacket, data.length);
                int position = 0;
                int rest = block;
                while (rest > 0) {
                    int rc = in.read(data, position, rest);
                    this.last_transfer_time = System.currentTimeMillis();
                    if (rc < 0) {
                        throw new IOException("Premature EOF");
                    }
                    rest -= rc;
                    position += rc;
                }
                this.transfered += (long)block;
                bb.limit(block);
                fileChannel.write(bb);
            }
        }
        this.say("<WaitingForReadAck>");
        following = in.readInt();
        if (following < 12) {
            throw new IOException("Protocol Violation : ack too small : " + following);
        }
        type = in.readInt();
        if (type != 7) {
            throw new IOException("Protocol Violation : NOT REQUEST_ACK : " + type);
        }
        mode = in.readInt();
        if (mode != 2) {
            throw new IOException("Protocol Violation : NOT SEEK : " + mode);
        }
        returnCode = in.readInt();
        if (returnCode != 0) {
            String error = in.readUTF();
            throw new IOException("Read Fin Failed : (" + returnCode + ") " + error);
        }
        this.say("<WaitingForCloseAck>");
        out.writeInt(4);
        out.writeInt(4);
        following = in.readInt();
        if (following < 12) {
            throw new IOException("Protocol Violation : ack too small : " + following);
        }
        type = in.readInt();
        if (type != 6) {
            throw new IOException("Protocol Violation : NOT REQUEST_ACK : " + type);
        }
        mode = in.readInt();
        if (mode != 4) {
            throw new IOException("Protocol Violation : NOT SEEK : " + mode);
        }
        returnCode = in.readInt();
        if (returnCode != 0) {
            String error = in.readUTF();
            throw new IOException("Close ack Failed : (" + returnCode + ") " + error);
        }
        this.say("<Done>");
    }
}

