/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.movers;

import diskCacheV111.util.ChecksumFactory;
import java.io.IOException;
import java.io.SyncFailedException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.security.MessageDigest;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.util.Checksum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumChannel
implements RepositoryChannel {
    private static final Logger _log = LoggerFactory.getLogger(ChecksumChannel.class);
    private final RepositoryChannel _channel;
    private final ChecksumFactory _checksumFactory;
    private MessageDigest _digest;
    private long _digestPosition;

    public ChecksumChannel(RepositoryChannel inner, ChecksumFactory checksumFactory) {
        this._channel = inner;
        this._checksumFactory = checksumFactory;
        this._digest = this._checksumFactory.create();
    }

    @Override
    public long position() throws IOException {
        return this._channel.position();
    }

    @Override
    public RepositoryChannel position(long position) throws IOException {
        return this._channel.position(position);
    }

    @Override
    public long size() throws IOException {
        return this._channel.size();
    }

    @Override
    public int write(ByteBuffer buffer, long position) throws IOException {
        int bytes;
        this.abortIfOutOfOrder(position);
        if (this._digest != null) {
            ByteBuffer readOnly = buffer.asReadOnlyBuffer();
            bytes = this._channel.write(buffer, position);
            this.update(readOnly, bytes);
        } else {
            bytes = this._channel.write(buffer, position);
        }
        return bytes;
    }

    @Override
    public int read(ByteBuffer buffer, long position) throws IOException {
        return this._channel.read(buffer, position);
    }

    @Override
    public RepositoryChannel truncate(long size) throws IOException {
        return this._channel.truncate(size);
    }

    @Override
    public void sync() throws SyncFailedException, IOException {
        this._channel.sync();
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        return this._channel.transferTo(position, count, target);
    }

    @Override
    public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
        this._digest = null;
        return this._channel.transferFrom(src, position, count);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long bytes;
        this.abortIfOutOfOrder(this.position());
        if (this._digest != null) {
            ByteBuffer[] readOnly = new ByteBuffer[srcs.length];
            for (int i = offset; i < offset + length; ++i) {
                readOnly[i] = srcs[i].asReadOnlyBuffer();
            }
            long remaining = bytes = this._channel.write(srcs, offset, length);
            for (int i = offset; i < offset + length && remaining > 0L; remaining -= this.update(readOnly[i], remaining), ++i) {
            }
        } else {
            bytes = this._channel.write(srcs, offset, length);
        }
        return bytes;
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        long bytes;
        this.abortIfOutOfOrder(this.position());
        if (this._digest != null) {
            ByteBuffer[] readOnly = new ByteBuffer[srcs.length];
            for (int i = 0; i < srcs.length; ++i) {
                readOnly[i] = srcs[i].asReadOnlyBuffer();
            }
            long remaining = bytes = this._channel.write(srcs);
            for (int i = 0; i < readOnly.length && remaining > 0L; remaining -= this.update(readOnly[i], remaining), ++i) {
            }
        } else {
            bytes = this._channel.write(srcs);
        }
        return bytes;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int bytes;
        this.abortIfOutOfOrder(this.position());
        if (this._digest != null) {
            ByteBuffer readOnly = src.asReadOnlyBuffer();
            bytes = this._channel.write(src);
            this.update(readOnly, bytes);
        } else {
            bytes = this._channel.write(src);
        }
        return bytes;
    }

    @Override
    public boolean isOpen() {
        return this._channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this._channel.close();
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this._channel.read(dsts, offset, length);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this._channel.read(dsts);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this._channel.read(dst);
    }

    public Checksum getChecksum() {
        return this._digest == null ? null : this._checksumFactory.create(this._digest.digest());
    }

    private void abortIfOutOfOrder(long position) {
        if (position != this._digestPosition) {
            this._digest = null;
            _log.debug("On-transfer checksum not computed due to out-of-order upload");
        }
    }

    private long update(ByteBuffer buffer, long bytes) {
        if (bytes < (long)buffer.remaining()) {
            buffer.limit(buffer.position() + (int)bytes);
        }
        long actual = buffer.remaining();
        this._digest.update(buffer);
        this._digestPosition += actual;
        return actual;
    }
}

