/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.movers;

import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import diskCacheV111.util.TimeoutCacheException;
import diskCacheV111.vehicles.ProtocolInfo;
import dmg.cells.nucleus.CDC;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.CompletionHandler;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.dcache.pool.classic.Cancellable;
import org.dcache.pool.movers.AbstractNettyServer;
import org.dcache.pool.movers.MoverChannel;
import org.dcache.util.CDCThreadFactory;
import org.dcache.util.PortRange;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.execution.OrderedMemoryAwareThreadPoolExecutor;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.logging.Slf4JLoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNettyServer<T extends ProtocolInfo> {
    private static final Logger _logger = LoggerFactory.getLogger(AbstractNettyServer.class);
    private final Executor _acceptExecutor;
    private final Executor _socketExecutor;
    private final Executor _diskExecutor;
    private static final ScheduledExecutorService _timeoutScheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("netty-mover-connect-timeout").setDaemon(true).build());
    private final int _socketThreads;
    private Channel _serverChannel;
    private InetSocketAddress _lastServerAddress;
    private ChannelFactory _channelFactory;
    private PortRange _portRange = new PortRange(0);
    private final ConcurrentMap<UUID, Entry> _uuids = Maps.newConcurrentMap();
    private final ConcurrentMap<MoverChannel<T>, Entry> _channels = Maps.newConcurrentMap();

    public AbstractNettyServer(String name, int threadPoolSize, int memoryPerConnection, int maxMemory, int socketThreads) {
        CDCThreadFactory factory = new CDCThreadFactory(Executors.defaultThreadFactory(), CDC.getCellName(), CDC.getDomainName());
        this._diskExecutor = new OrderedMemoryAwareThreadPoolExecutor(threadPoolSize, (long)memoryPerConnection, (long)maxMemory, 30L, TimeUnit.SECONDS, new ThreadFactoryBuilder().setDaemon(true).setNameFormat(name + "-disk-%d").setThreadFactory((ThreadFactory)factory).build());
        this._acceptExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat(name + "-listen-%d").setThreadFactory((ThreadFactory)factory).build());
        this._socketExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat(name + "-net-%d").setThreadFactory((ThreadFactory)factory).build());
        this._socketThreads = socketThreads;
    }

    protected synchronized void startServer() throws IOException {
        if (this._serverChannel == null) {
            if (this._channelFactory == null) {
                this._channelFactory = this._socketThreads == -1 ? new NioServerSocketChannelFactory(this._acceptExecutor, this._socketExecutor) : new NioServerSocketChannelFactory(this._acceptExecutor, this._socketExecutor, this._socketThreads);
            }
            ServerBootstrap bootstrap = new ServerBootstrap(this._channelFactory);
            bootstrap.setOption("child.tcpNoDelay", (Object)false);
            bootstrap.setOption("child.keepAlive", (Object)true);
            bootstrap.setPipelineFactory(this.newPipelineFactory());
            this._serverChannel = this._portRange.bind(bootstrap);
            this._lastServerAddress = (InetSocketAddress)this._serverChannel.getLocalAddress();
            _logger.debug("Started {} on {}", (Object)this.getClass().getSimpleName(), (Object)this._lastServerAddress);
        }
    }

    protected synchronized void stopServer() {
        if (this._serverChannel != null) {
            _logger.debug("Stopping {} on {}", (Object)this.getClass().getSimpleName(), (Object)this._lastServerAddress);
            this._serverChannel.close();
            this._serverChannel = null;
        }
    }

    protected synchronized void conditionallyStartServer() throws IOException {
        if (!this._uuids.isEmpty()) {
            this.startServer();
        }
    }

    protected synchronized void conditionallyStopServer() {
        if (this._uuids.isEmpty()) {
            this.stopServer();
        }
    }

    public synchronized InetSocketAddress getServerAddress() {
        return this._lastServerAddress;
    }

    public synchronized Cancellable register(MoverChannel<T> channel, UUID uuid, long connectTimeout, CompletionHandler<Void, Void> completionHandler) throws IOException {
        Entry entry = new Entry(channel, uuid, connectTimeout, completionHandler);
        if (this._uuids.putIfAbsent(uuid, entry) != null) {
            throw new IllegalStateException("UUID conflict");
        }
        if (this._channels.putIfAbsent(channel, entry) != null) {
            this._uuids.remove(uuid);
            throw new IllegalStateException("Mover is already registered");
        }
        this.conditionallyStartServer();
        return entry;
    }

    private synchronized void unregister(Entry entry) {
        this._channels.remove(entry._channel);
        this._uuids.remove(entry._uuid);
        this.conditionallyStopServer();
    }

    public MoverChannel<T> open(UUID uuid, boolean exclusive) {
        Entry entry = (Entry)this._uuids.get(uuid);
        return entry == null ? null : entry.open(exclusive);
    }

    public void close(MoverChannel<T> channel) {
        Entry entry = (Entry)this._channels.get(channel);
        if (entry != null) {
            entry.close();
        }
    }

    public void close(MoverChannel<T> channel, Exception exception) {
        Entry entry = (Entry)this._channels.get(channel);
        if (entry != null) {
            entry.close(exception);
        }
    }

    protected abstract ChannelPipelineFactory newPipelineFactory();

    protected Executor getDiskExecutor() {
        return this._diskExecutor;
    }

    protected Executor getAcceptExecutor() {
        return this._acceptExecutor;
    }

    protected Executor getSocketExecutor() {
        return this._socketExecutor;
    }

    public PortRange getPortRange() {
        return this._portRange;
    }

    public void setPortRange(PortRange portRange) {
        this._portRange = portRange;
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)new Slf4JLoggerFactory());
    }

    private class Entry
    implements Cancellable {
        private final org.dcache.pool.movers.AbstractNettyServer$Entry.Sync _sync = new Sync();
        private final MoverChannel<T> _channel;
        private final UUID _uuid;
        private final Future<?> _timeout;
        private final CompletionHandler<Void, Void> _completionHandler;
        private final CDC _cdc = new CDC();

        Entry(MoverChannel<T> channel, UUID uuid, final long connectTimeout, CompletionHandler<Void, Void> completionHandler) {
            this._channel = channel;
            this._uuid = uuid;
            this._completionHandler = completionHandler;
            this._timeout = _timeoutScheduler.schedule(new Runnable(){

                @Override
                public void run() {
                    if (Entry.this._sync.timeout()) {
                        try (CDC ignored = Entry.this._cdc.restore();){
                            Entry.this._completionHandler.failed(new TimeoutCacheException("No connection from client after " + TimeUnit.MILLISECONDS.toSeconds(connectTimeout) + " seconds. Giving up."), null);
                        }
                    }
                }
            }, connectTimeout, TimeUnit.MILLISECONDS);
        }

        MoverChannel<T> open(boolean exclusive) {
            return this._sync.open(exclusive);
        }

        void close() {
            this.close(null);
        }

        void close(Exception exception) {
            if (this._sync.close(exception)) {
                try (CDC ignored = this._cdc.restore();){
                    if (exception != null) {
                        this._completionHandler.failed(exception, null);
                    } else {
                        this._completionHandler.completed(null, null);
                    }
                }
            }
        }

        @Override
        public void cancel() {
            if (this._sync.cancel()) {
                try (CDC ignored = this._cdc.restore();){
                    this._completionHandler.failed(new InterruptedException("Transfer was interrupted"), null);
                }
            }
        }

        private class Sync {
            private int _open;
            private boolean _isExclusive;
            private boolean _isClosed;

            private Sync() {
            }

            synchronized MoverChannel<T> open(boolean exclusive) {
                if (this._isExclusive || this._isClosed) {
                    return null;
                }
                this._isExclusive = exclusive;
                ++this._open;
                Entry.this._timeout.cancel(false);
                return Entry.this._channel;
            }

            synchronized boolean close(Exception exception) {
                --this._open;
                return (exception != null || this._open <= 0) && this.close();
            }

            synchronized boolean cancel() {
                return this.close();
            }

            synchronized boolean timeout() {
                return this._open == 0 && this.close();
            }

            private boolean close() {
                if (!this._isClosed) {
                    this._isClosed = true;
                    Entry.this._timeout.cancel(false);
                    AbstractNettyServer.this.unregister(Entry.this);
                    return true;
                }
                return false;
            }
        }
    }
}

