/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.movers;

import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import diskCacheV111.util.CacheException;
import diskCacheV111.util.DiskErrorCacheException;
import diskCacheV111.vehicles.PoolAcceptFileMessage;
import diskCacheV111.vehicles.PoolIoFileMessage;
import diskCacheV111.vehicles.ProtocolInfo;
import dmg.cells.nucleus.CellPath;
import java.io.FileNotFoundException;
import java.io.InterruptedIOException;
import java.nio.channels.CompletionHandler;
import javax.security.auth.Subject;
import org.dcache.pool.classic.Cancellable;
import org.dcache.pool.classic.PostTransferService;
import org.dcache.pool.classic.TransferService;
import org.dcache.pool.movers.IoMode;
import org.dcache.pool.movers.Mover;
import org.dcache.pool.repository.FileRepositoryChannel;
import org.dcache.pool.repository.ReplicaDescriptor;
import org.dcache.pool.repository.RepositoryChannel;
import org.dcache.util.TryCatchTemplate;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMover<P extends ProtocolInfo, M extends Mover<P>>
implements Mover<P> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMover.class);
    private final TypeToken<P> type = new TypeToken<P>(this.getClass()){};
    protected final long _id;
    protected final String _queue;
    protected final String _initiator;
    protected final boolean _isPoolToPoolTransfer;
    protected final CellPath _pathToDoor;
    protected final P _protocolInfo;
    protected final Subject _subject;
    protected final ReplicaDescriptor _handle;
    protected final IoMode _ioMode;
    protected final TransferService<Mover<P>> _transferService;
    protected final PostTransferService _postTransferService;
    protected volatile int _errorCode;
    protected volatile String _errorMessage = "";

    public AbstractMover(ReplicaDescriptor handle, PoolIoFileMessage message, CellPath pathToDoor, TransferService<M> transferService, PostTransferService postTransferService) {
        Preconditions.checkArgument((boolean)this.type.isAssignableFrom(message.getProtocolInfo().getClass()));
        this._queue = message.getIoQueueName();
        this._protocolInfo = message.getProtocolInfo();
        this._initiator = message.getInitiator();
        this._isPoolToPoolTransfer = message.isPool2Pool();
        this._ioMode = message instanceof PoolAcceptFileMessage ? IoMode.WRITE : IoMode.READ;
        this._subject = message.getSubject();
        this._id = message.getId();
        this._pathToDoor = pathToDoor;
        this._handle = handle;
        this._transferService = transferService;
        this._postTransferService = postTransferService;
    }

    @Override
    public FileAttributes getFileAttributes() {
        return this._handle.getFileAttributes();
    }

    @Override
    public P getProtocolInfo() {
        return this._protocolInfo;
    }

    @Override
    public long getClientId() {
        return this._id;
    }

    @Override
    public void setTransferStatus(int errorCode, String errorMessage) {
        if (this._errorCode == 0) {
            this._errorCode = errorCode;
            this._errorMessage = errorMessage;
        }
    }

    @Override
    public String getQueueName() {
        return this._queue;
    }

    @Override
    public int getErrorCode() {
        return this._errorCode;
    }

    @Override
    public String getErrorMessage() {
        return this._errorMessage;
    }

    @Override
    public String getInitiator() {
        return this._initiator;
    }

    @Override
    public boolean isPoolToPoolTransfer() {
        return this._isPoolToPoolTransfer;
    }

    @Override
    public ReplicaDescriptor getIoHandle() {
        return this._handle;
    }

    @Override
    public IoMode getIoMode() {
        return this._ioMode;
    }

    @Override
    public CellPath getPathToDoor() {
        return this._pathToDoor;
    }

    @Override
    public Subject getSubject() {
        return this._subject;
    }

    @Override
    public void postprocess(CompletionHandler<Void, Void> completionHandler) {
        this._postTransferService.execute(this, completionHandler);
    }

    @Override
    public Cancellable execute(CompletionHandler<Void, Void> completionHandler) {
        return new TryCatchTemplate<Void, Void>(completionHandler){

            @Override
            public Cancellable executeWithCancellable() throws Exception {
                return AbstractMover.this._transferService.execute(AbstractMover.this, this);
            }

            @Override
            public synchronized void onFailure(Throwable t, Void attachment) {
                try {
                    throw t;
                }
                catch (DiskErrorCacheException e) {
                    LOGGER.error("Transfer failed due to a disk error: {}", (Object)e.toString());
                    AbstractMover.this.setTransferStatus(10011, e.getMessage());
                }
                catch (CacheException e) {
                    LOGGER.error("Transfer failed: {}", (Object)e.getMessage());
                    AbstractMover.this.setTransferStatus(e.getRc(), e.getMessage());
                }
                catch (InterruptedIOException | InterruptedException e) {
                    LOGGER.error("Transfer was forcefully killed");
                    AbstractMover.this.setTransferStatus(666, "Transfer was forcefully killed");
                }
                catch (RuntimeException e) {
                    LOGGER.error("Transfer failed due to a bug", (Throwable)e);
                    AbstractMover.this.setTransferStatus(10011, e.getMessage());
                }
                catch (Exception e) {
                    LOGGER.error("Transfer failed: {}", (Object)e.toString());
                    AbstractMover.this.setTransferStatus(666, e.getMessage());
                }
                catch (Throwable e) {
                    LOGGER.error("Transfer failed:", e);
                    Thread thread = Thread.currentThread();
                    thread.getUncaughtExceptionHandler().uncaughtException(thread, e);
                    AbstractMover.this.setTransferStatus(10011, e.getMessage());
                }
            }
        };
    }

    public RepositoryChannel openChannel() throws DiskErrorCacheException {
        FileRepositoryChannel channel;
        switch (this.getIoMode()) {
            case WRITE: {
                try {
                    channel = new FileRepositoryChannel(this._handle.getFile(), "rw");
                    break;
                }
                catch (FileNotFoundException e) {
                    throw new DiskErrorCacheException("File could not be created; please check the file system", e);
                }
            }
            case READ: {
                try {
                    channel = new FileRepositoryChannel(this._handle.getFile(), "r");
                    break;
                }
                catch (FileNotFoundException e) {
                    throw new DiskErrorCacheException("File could not be opened  [" + e.getMessage() + "]; please check the file system", e);
                }
            }
            default: {
                throw new RuntimeException("Invalid I/O mode");
            }
        }
        return channel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFileAttributes().getPnfsId());
        sb.append(" h={").append(this.getStatus()).append("} bytes=").append(this.getBytesTransferred()).append(" time/sec=").append(this.getTransferTime() / 1000L).append(" LM=");
        long lastTransferTime = this.getLastTransferred();
        if (lastTransferTime == 0L) {
            sb.append(0);
        } else {
            sb.append((System.currentTimeMillis() - lastTransferTime) / 1000L);
        }
        return sb.toString();
    }

    protected abstract String getStatus();
}

