/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.migration;

import org.dcache.pool.migration.PoolMigrationCopyFinishedMessage;
import org.dcache.pool.migration.Task;
import statemap.FSMContext;
import statemap.State;
import statemap.StateUndefinedException;
import statemap.TransitionUndefinedException;

public class TaskContext
extends FSMContext {
    private transient Task _owner;

    public TaskContext(Task owner) {
        super((State)TASK.Queued);
        this._owner = owner;
    }

    public TaskContext(Task owner, TaskState initState) {
        super((State)initState);
        this._owner = owner;
    }

    public void enterStartState() {
        this.getState().Entry(this);
    }

    public void cancel() {
        this._transition = "cancel";
        this.getState().cancel(this);
        this._transition = "";
    }

    public void cancel_failure(Integer rc, Object cause) {
        this._transition = "cancel_failure";
        this.getState().cancel_failure(this, rc, cause);
        this._transition = "";
    }

    public void cancel_noroute() {
        this._transition = "cancel_noroute";
        this.getState().cancel_noroute(this);
        this._transition = "";
    }

    public void cancel_success() {
        this._transition = "cancel_success";
        this.getState().cancel_success(this);
        this._transition = "";
    }

    public void cancel_timeout() {
        this._transition = "cancel_timeout";
        this.getState().cancel_timeout(this);
        this._transition = "";
    }

    public void copy_failure(Integer rc, Object cause) {
        this._transition = "copy_failure";
        this.getState().copy_failure(this, rc, cause);
        this._transition = "";
    }

    public void copy_nopools() {
        this._transition = "copy_nopools";
        this.getState().copy_nopools(this);
        this._transition = "";
    }

    public void copy_noroute() {
        this._transition = "copy_noroute";
        this.getState().copy_noroute(this);
        this._transition = "";
    }

    public void copy_success() {
        this._transition = "copy_success";
        this.getState().copy_success(this);
        this._transition = "";
    }

    public void copy_timeout() {
        this._transition = "copy_timeout";
        this.getState().copy_timeout(this);
        this._transition = "";
    }

    public void messageArrived(PoolMigrationCopyFinishedMessage message) {
        this._transition = "messageArrived";
        this.getState().messageArrived(this, message);
        this._transition = "";
    }

    public void move_failure(Integer rc, Object cause) {
        this._transition = "move_failure";
        this.getState().move_failure(this, rc, cause);
        this._transition = "";
    }

    public void move_noroute() {
        this._transition = "move_noroute";
        this.getState().move_noroute(this);
        this._transition = "";
    }

    public void move_success() {
        this._transition = "move_success";
        this.getState().move_success(this);
        this._transition = "";
    }

    public void move_timeout() {
        this._transition = "move_timeout";
        this.getState().move_timeout(this);
        this._transition = "";
    }

    public void ping_failure(Integer rc, Object cause) {
        this._transition = "ping_failure";
        this.getState().ping_failure(this, rc, cause);
        this._transition = "";
    }

    public void ping_noroute() {
        this._transition = "ping_noroute";
        this.getState().ping_noroute(this);
        this._transition = "";
    }

    public void ping_success() {
        this._transition = "ping_success";
        this.getState().ping_success(this);
        this._transition = "";
    }

    public void ping_timeout() {
        this._transition = "ping_timeout";
        this.getState().ping_timeout(this);
        this._transition = "";
    }

    public void query_failure(Integer rc, Object cause) {
        this._transition = "query_failure";
        this.getState().query_failure(this, rc, cause);
        this._transition = "";
    }

    public void query_noroute() {
        this._transition = "query_noroute";
        this.getState().query_noroute(this);
        this._transition = "";
    }

    public void query_success() {
        this._transition = "query_success";
        this.getState().query_success(this);
        this._transition = "";
    }

    public void query_timeout() {
        this._transition = "query_timeout";
        this.getState().query_timeout(this);
        this._transition = "";
    }

    public void run() {
        this._transition = "run";
        this.getState().run(this);
        this._transition = "";
    }

    public void timer() {
        this._transition = "timer";
        this.getState().timer(this);
        this._transition = "";
    }

    public TaskState getState() throws StateUndefinedException {
        if (this._state == null) {
            throw new StateUndefinedException();
        }
        return (TaskState)this._state;
    }

    protected Task getOwner() {
        return this._owner;
    }

    public void setOwner(Task owner) {
        if (owner == null) {
            throw new NullPointerException("null owner");
        }
        this._owner = owner;
    }

    private static final class TASK_Done
    extends TASK_Default {
        private TASK_Done(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(TaskContext context) {
            Task ctxt = context.getOwner();
            ctxt.notifyCompleted();
        }
    }

    private static final class TASK_Failed
    extends TASK_Default {
        private TASK_Failed(String name, int id) {
            super(name, id);
        }
    }

    private static final class TASK_Cancelled
    extends TASK_Default {
        private TASK_Cancelled(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(TaskContext context) {
            Task ctxt = context.getOwner();
            ctxt.notifyCancelled();
        }
    }

    private static final class TASK_Cancelling
    extends TASK_Default {
        private TASK_Cancelling(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(TaskContext context) {
            Task ctxt = context.getOwner();
            ctxt.cancelCopy();
            ctxt.startTimer(ctxt.getTaskDeadTimeout());
        }

        @Override
        protected void Exit(TaskContext context) {
            Task ctxt = context.getOwner();
            ctxt.stopTimer();
        }

        @Override
        protected void cancel_failure(TaskContext context, Integer rc, Object cause) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel_noroute(TaskContext context) {
            Task ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.fail("Failed to cancel task (no route)");
            }
            finally {
                context.setState(TASK.Failed);
                context.getState().Entry(context);
            }
        }

        @Override
        protected void cancel_success(TaskContext context) {
        }

        @Override
        protected void cancel_timeout(TaskContext context) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void messageArrived(TaskContext context, PoolMigrationCopyFinishedMessage message) {
            Task ctxt = context.getOwner();
            if (message.getReturnCode() != 0) {
                context.getState().Exit(context);
                context.setState(TASK.Cancelled);
                context.getState().Entry(context);
            } else if (message.getReturnCode() == 0 && ctxt.getMustMovePins()) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.fail("Failed to cancel task");
                }
                finally {
                    context.setState(TASK.Failed);
                    context.getState().Entry(context);
                }
            } else if (message.getReturnCode() == 0) {
                context.getState().Exit(context);
                context.setState(TASK.Done);
                context.getState().Entry(context);
            } else {
                super.messageArrived(context, message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void timer(TaskContext context) {
            Task ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.fail(String.format("Failed to cancel task (no response from %s)", ctxt.getTarget()));
            }
            finally {
                context.setState(TASK.Failed);
                context.getState().Entry(context);
            }
        }
    }

    private static final class TASK_MovingPin
    extends TASK_Default {
        private TASK_MovingPin(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(TaskContext context) {
            Task ctxt = context.getOwner();
            ctxt.movePin();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void cancel(TaskContext context) {
            Task ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.fail("Failed to cancel task");
            }
            finally {
                context.setState(TASK.Failed);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void move_failure(TaskContext context, Integer rc, Object cause) {
            Task ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.fail("Pin manager failed (" + cause + ")");
            }
            finally {
                context.setState(TASK.Failed);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void move_noroute(TaskContext context) {
            Task ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.fail("Pin manager failed (no route to cell)");
            }
            finally {
                context.setState(TASK.Failed);
                context.getState().Entry(context);
            }
        }

        @Override
        protected void move_success(TaskContext context) {
            context.getState().Exit(context);
            context.setState(TASK.Done);
            context.getState().Entry(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void move_timeout(TaskContext context) {
            Task ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.fail("Pin manager failed (timeout)");
            }
            finally {
                context.setState(TASK.Failed);
                context.getState().Entry(context);
            }
        }
    }

    private static final class TASK_Waiting
    extends TASK_Default {
        private TASK_Waiting(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(TaskContext context) {
            Task ctxt = context.getOwner();
            ctxt.startTimer(ctxt.getTaskDeadTimeout());
        }

        @Override
        protected void Exit(TaskContext context) {
            Task ctxt = context.getOwner();
            ctxt.stopTimer();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void messageArrived(TaskContext context, PoolMigrationCopyFinishedMessage message) {
            Task ctxt = context.getOwner();
            if (message.getReturnCode() == 10001) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.failPermanently(String.format("Transfer to %s failed (%s); will not be retried", ctxt.getTarget(), message.getErrorObject()));
                }
                finally {
                    context.setState(TASK.Failed);
                    context.getState().Entry(context);
                }
            } else if (message.getReturnCode() != 0) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.fail(String.format("Transfer to %s failed (%s)", ctxt.getTarget(), message.getErrorObject()));
                }
                finally {
                    context.setState(TASK.Failed);
                    context.getState().Entry(context);
                }
            } else if (message.getReturnCode() == 0 && ctxt.getMustMovePins()) {
                context.getState().Exit(context);
                context.setState(TASK.MovingPin);
                context.getState().Entry(context);
            } else if (message.getReturnCode() == 0) {
                context.getState().Exit(context);
                context.setState(TASK.Done);
                context.getState().Entry(context);
            } else {
                super.messageArrived(context, message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void timer(TaskContext context) {
            Task ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.fail(String.format("Pool %s failed (no response)", ctxt.getTarget()));
            }
            finally {
                context.setState(TASK.Failed);
                context.getState().Entry(context);
            }
        }
    }

    private static final class TASK_NoResponse
    extends TASK_Default {
        private TASK_NoResponse(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(TaskContext context) {
            Task ctxt = context.getOwner();
            ctxt.startTimer(ctxt.getNoResponseTimeout());
        }

        @Override
        protected void Exit(TaskContext context) {
            Task ctxt = context.getOwner();
            ctxt.stopTimer();
        }

        @Override
        protected void cancel(TaskContext context) {
            context.getState().Exit(context);
            context.setState(TASK.Cancelling);
            context.getState().Entry(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void messageArrived(TaskContext context, PoolMigrationCopyFinishedMessage message) {
            Task ctxt = context.getOwner();
            if (message.getReturnCode() == 10001) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.failPermanently(String.format("Transfer to %s failed (%s); will not be retried", ctxt.getTarget(), message.getErrorObject()));
                }
                finally {
                    context.setState(TASK.Failed);
                    context.getState().Entry(context);
                }
            } else if (message.getReturnCode() != 0) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.fail(String.format("Transfer to %s failed (%s)", ctxt.getTarget(), message.getErrorObject()));
                }
                finally {
                    context.setState(TASK.Failed);
                    context.getState().Entry(context);
                }
            } else if (message.getReturnCode() == 0 && ctxt.getMustMovePins()) {
                context.getState().Exit(context);
                context.setState(TASK.MovingPin);
                context.getState().Entry(context);
            } else if (message.getReturnCode() == 0) {
                context.getState().Exit(context);
                context.setState(TASK.Done);
                context.getState().Entry(context);
            } else {
                super.messageArrived(context, message);
            }
        }

        @Override
        protected void ping_failure(TaskContext context, Integer rc, Object cause) {
            context.getState().Exit(context);
            context.setState(TASK.Waiting);
            context.getState().Entry(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void ping_noroute(TaskContext context) {
            Task ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.fail(String.format("Pool %s failed (no route to cell)", ctxt.getTarget()));
            }
            finally {
                context.setState(TASK.Failed);
                context.getState().Entry(context);
            }
        }

        @Override
        protected void ping_success(TaskContext context) {
            context.getState().Exit(context);
            context.setState(TASK.Copying);
            context.getState().Entry(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void ping_timeout(TaskContext context) {
            Task ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.fail(String.format("Pool %s failed (no response)", ctxt.getTarget()));
            }
            finally {
                context.setState(TASK.Failed);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void timer(TaskContext context) {
            Task ctxt = context.getOwner();
            TaskState endState = context.getState();
            context.clearState();
            try {
                ctxt.ping();
            }
            finally {
                context.setState(endState);
            }
        }
    }

    private static final class TASK_Pinging
    extends TASK_Default {
        private TASK_Pinging(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(TaskContext context) {
            Task ctxt = context.getOwner();
            ctxt.ping();
        }

        @Override
        protected void cancel(TaskContext context) {
            context.getState().Exit(context);
            context.setState(TASK.Cancelling);
            context.getState().Entry(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void messageArrived(TaskContext context, PoolMigrationCopyFinishedMessage message) {
            Task ctxt = context.getOwner();
            if (message.getReturnCode() == 10001) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.failPermanently(String.format("Transfer to %s failed (%s); will not be retried", ctxt.getTarget(), message.getErrorObject()));
                }
                finally {
                    context.setState(TASK.Failed);
                    context.getState().Entry(context);
                }
            } else if (message.getReturnCode() != 0) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.fail(String.format("Transfer to %s failed (%s)", ctxt.getTarget(), message.getErrorObject()));
                }
                finally {
                    context.setState(TASK.Failed);
                    context.getState().Entry(context);
                }
            } else if (message.getReturnCode() == 0 && ctxt.getMustMovePins()) {
                context.getState().Exit(context);
                context.setState(TASK.MovingPin);
                context.getState().Entry(context);
            } else if (message.getReturnCode() == 0) {
                context.getState().Exit(context);
                context.setState(TASK.Done);
                context.getState().Entry(context);
            } else {
                super.messageArrived(context, message);
            }
        }

        @Override
        protected void ping_failure(TaskContext context, Integer rc, Object cause) {
            context.getState().Exit(context);
            context.setState(TASK.Waiting);
            context.getState().Entry(context);
        }

        @Override
        protected void ping_noroute(TaskContext context) {
            context.getState().Exit(context);
            context.setState(TASK.NoResponse);
            context.getState().Entry(context);
        }

        @Override
        protected void ping_success(TaskContext context) {
            context.getState().Exit(context);
            context.setState(TASK.Copying);
            context.getState().Entry(context);
        }

        @Override
        protected void ping_timeout(TaskContext context) {
            context.getState().Exit(context);
            context.setState(TASK.NoResponse);
            context.getState().Entry(context);
        }
    }

    private static final class TASK_Copying
    extends TASK_Default {
        private TASK_Copying(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(TaskContext context) {
            Task ctxt = context.getOwner();
            ctxt.startTimer(ctxt.getPingPeriod());
        }

        @Override
        protected void Exit(TaskContext context) {
            Task ctxt = context.getOwner();
            ctxt.stopTimer();
        }

        @Override
        protected void cancel(TaskContext context) {
            context.getState().Exit(context);
            context.setState(TASK.Cancelling);
            context.getState().Entry(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void messageArrived(TaskContext context, PoolMigrationCopyFinishedMessage message) {
            Task ctxt = context.getOwner();
            if (message.getReturnCode() == 10001) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.failPermanently(String.format("Transfer to %s failed (%s); will not be retried", ctxt.getTarget(), message.getErrorObject()));
                }
                finally {
                    context.setState(TASK.Failed);
                    context.getState().Entry(context);
                }
            } else if (message.getReturnCode() != 0) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.fail(String.format("Transfer to %s failed (%s)", ctxt.getTarget(), message.getErrorObject()));
                }
                finally {
                    context.setState(TASK.Failed);
                    context.getState().Entry(context);
                }
            } else if (message.getReturnCode() == 0 && ctxt.getMustMovePins()) {
                context.getState().Exit(context);
                context.setState(TASK.MovingPin);
                context.getState().Entry(context);
            } else if (message.getReturnCode() == 0) {
                context.getState().Exit(context);
                context.setState(TASK.Done);
                context.getState().Entry(context);
            } else {
                super.messageArrived(context, message);
            }
        }

        @Override
        protected void timer(TaskContext context) {
            context.getState().Exit(context);
            context.setState(TASK.Pinging);
            context.getState().Entry(context);
        }
    }

    private static final class TASK_InitiatingCopy
    extends TASK_Default {
        private TASK_InitiatingCopy(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(TaskContext context) {
            Task ctxt = context.getOwner();
            ctxt.initiateCopy();
        }

        @Override
        protected void cancel(TaskContext context) {
            context.getState().Exit(context);
            context.setState(TASK.Cancelling);
            context.getState().Entry(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void copy_failure(TaskContext context, Integer rc, Object cause) {
            Task ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.fail(String.format("Pool %s failed (%s)", ctxt.getTarget(), cause));
            }
            finally {
                context.setState(TASK.Failed);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void copy_nopools(TaskContext context) {
            Task ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.fail(String.format("No targets", new Object[0]));
            }
            finally {
                context.setState(TASK.Failed);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void copy_noroute(TaskContext context) {
            Task ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.fail(String.format("Pool %s failed (no route to cell)", ctxt.getTarget()));
            }
            finally {
                context.setState(TASK.Failed);
                context.getState().Entry(context);
            }
        }

        @Override
        protected void copy_success(TaskContext context) {
            context.getState().Exit(context);
            context.setState(TASK.Copying);
            context.getState().Entry(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void copy_timeout(TaskContext context) {
            Task ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.cancelCopy();
            }
            finally {
                context.setState(TASK.Waiting);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void messageArrived(TaskContext context, PoolMigrationCopyFinishedMessage message) {
            Task ctxt = context.getOwner();
            if (message.getReturnCode() == 10001) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.failPermanently(String.format("Transfer to %s failed (%s); will not be retried", ctxt.getTarget(), message.getErrorObject()));
                }
                finally {
                    context.setState(TASK.Failed);
                    context.getState().Entry(context);
                }
            } else if (message.getReturnCode() != 0) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.fail(String.format("Transfer to %s failed (%s)", ctxt.getTarget(), message.getErrorObject()));
                }
                finally {
                    context.setState(TASK.Failed);
                    context.getState().Entry(context);
                }
            } else if (message.getReturnCode() == 0 && ctxt.getMustMovePins()) {
                context.getState().Exit(context);
                context.setState(TASK.MovingPin);
                context.getState().Entry(context);
            } else if (message.getReturnCode() == 0) {
                context.getState().Exit(context);
                context.setState(TASK.Done);
                context.getState().Entry(context);
            } else {
                super.messageArrived(context, message);
            }
        }
    }

    private static final class TASK_UpdatingExistingFile
    extends TASK_Default {
        private TASK_UpdatingExistingFile(String name, int id) {
            super(name, id);
        }

        @Override
        protected void cancel(TaskContext context) {
            context.getState().Exit(context);
            context.setState(TASK.Cancelling);
            context.getState().Entry(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void copy_failure(TaskContext context, Integer rc, Object cause) {
            Task ctxt = context.getOwner();
            if (rc == 10020) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.fail("Replica is locked on target pool");
                }
                finally {
                    context.setState(TASK.Failed);
                    context.getState().Entry(context);
                }
            } else if (ctxt.hasMoreLocations()) {
                TaskState endState = context.getState();
                context.clearState();
                try {
                    ctxt.updateExistingReplica();
                }
                finally {
                    context.setState(endState);
                }
            } else {
                context.getState().Exit(context);
                context.setState(TASK.InitiatingCopy);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void copy_noroute(TaskContext context) {
            Task ctxt = context.getOwner();
            if (ctxt.hasMoreLocations()) {
                TaskState endState = context.getState();
                context.clearState();
                try {
                    ctxt.updateExistingReplica();
                }
                finally {
                    context.setState(endState);
                }
            }
            if (ctxt.isEager()) {
                context.getState().Exit(context);
                context.setState(TASK.InitiatingCopy);
                context.getState().Entry(context);
            } else {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.fail("Remote pool failed (no route to cell)");
                }
                finally {
                    context.setState(TASK.Failed);
                    context.getState().Entry(context);
                }
            }
        }

        @Override
        protected void copy_success(TaskContext context) {
            context.getState().Exit(context);
            context.setState(TASK.Copying);
            context.getState().Entry(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void copy_timeout(TaskContext context) {
            Task ctxt = context.getOwner();
            if (ctxt.hasMoreLocations()) {
                TaskState endState = context.getState();
                context.clearState();
                try {
                    ctxt.updateExistingReplica();
                }
                finally {
                    context.setState(endState);
                }
            }
            if (ctxt.isEager()) {
                context.getState().Exit(context);
                context.setState(TASK.InitiatingCopy);
                context.getState().Entry(context);
            } else {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.fail("Remote pool failed (no response)");
                }
                finally {
                    context.setState(TASK.Failed);
                    context.getState().Entry(context);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void messageArrived(TaskContext context, PoolMigrationCopyFinishedMessage message) {
            Task ctxt = context.getOwner();
            if (message.getReturnCode() == 10001) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.failPermanently(String.format("Transfer to %s failed (%s); will not be retried", ctxt.getTarget(), message.getErrorObject()));
                }
                finally {
                    context.setState(TASK.Failed);
                    context.getState().Entry(context);
                }
            } else if (message.getReturnCode() != 0) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.fail(String.format("Transfer to %s failed (%s)", ctxt.getTarget(), message.getErrorObject()));
                }
                finally {
                    context.setState(TASK.Failed);
                    context.getState().Entry(context);
                }
            } else if (message.getReturnCode() == 0 && ctxt.getMustMovePins()) {
                context.getState().Exit(context);
                context.setState(TASK.MovingPin);
                context.getState().Entry(context);
            } else if (message.getReturnCode() == 0) {
                context.getState().Exit(context);
                context.setState(TASK.Done);
                context.getState().Entry(context);
            } else {
                super.messageArrived(context, message);
            }
        }
    }

    private static final class TASK_GettingLocations
    extends TASK_Default {
        private TASK_GettingLocations(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Entry(TaskContext context) {
            Task ctxt = context.getOwner();
            ctxt.queryLocations();
        }

        @Override
        protected void cancel(TaskContext context) {
            context.getState().Exit(context);
            context.setState(TASK.Cancelled);
            context.getState().Entry(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void query_failure(TaskContext context, Integer rc, Object cause) {
            Task ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.fail("PnfsManager failed (" + cause + ")");
            }
            finally {
                context.setState(TASK.Failed);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void query_noroute(TaskContext context) {
            Task ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.fail("PnfsManager failed (no route to cell)");
            }
            finally {
                context.setState(TASK.Failed);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void query_success(TaskContext context) {
            Task ctxt = context.getOwner();
            if (ctxt.hasMoreLocations()) {
                context.getState().Exit(context);
                context.clearState();
                try {
                    ctxt.updateExistingReplica();
                }
                finally {
                    context.setState(TASK.UpdatingExistingFile);
                    context.getState().Entry(context);
                }
            } else {
                context.getState().Exit(context);
                context.setState(TASK.InitiatingCopy);
                context.getState().Entry(context);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void query_timeout(TaskContext context) {
            Task ctxt = context.getOwner();
            context.getState().Exit(context);
            context.clearState();
            try {
                ctxt.fail("PnfsManager failed (no response)");
            }
            finally {
                context.setState(TASK.Failed);
                context.getState().Entry(context);
            }
        }
    }

    private static final class TASK_Queued
    extends TASK_Default {
        private TASK_Queued(String name, int id) {
            super(name, id);
        }

        @Override
        protected void run(TaskContext context) {
            context.getState().Exit(context);
            context.setState(TASK.GettingLocations);
            context.getState().Entry(context);
        }
    }

    protected static class TASK_Default
    extends TaskState {
        protected TASK_Default(String name, int id) {
            super(name, id);
        }

        @Override
        protected void Default(TaskContext context) {
        }
    }

    static abstract class TASK {
        public static final TASK_Queued Queued = new TASK_Queued("TASK.Queued", 0);
        public static final TASK_GettingLocations GettingLocations = new TASK_GettingLocations("TASK.GettingLocations", 1);
        public static final TASK_UpdatingExistingFile UpdatingExistingFile = new TASK_UpdatingExistingFile("TASK.UpdatingExistingFile", 2);
        public static final TASK_InitiatingCopy InitiatingCopy = new TASK_InitiatingCopy("TASK.InitiatingCopy", 3);
        public static final TASK_Copying Copying = new TASK_Copying("TASK.Copying", 4);
        public static final TASK_Pinging Pinging = new TASK_Pinging("TASK.Pinging", 5);
        public static final TASK_NoResponse NoResponse = new TASK_NoResponse("TASK.NoResponse", 6);
        public static final TASK_Waiting Waiting = new TASK_Waiting("TASK.Waiting", 7);
        public static final TASK_MovingPin MovingPin = new TASK_MovingPin("TASK.MovingPin", 8);
        public static final TASK_Cancelling Cancelling = new TASK_Cancelling("TASK.Cancelling", 9);
        public static final TASK_Cancelled Cancelled = new TASK_Cancelled("TASK.Cancelled", 10);
        public static final TASK_Failed Failed = new TASK_Failed("TASK.Failed", 11);
        public static final TASK_Done Done = new TASK_Done("TASK.Done", 12);
        private static final TASK_Default Default = new TASK_Default("TASK.Default", -1);

        TASK() {
        }
    }

    public static abstract class TaskState
    extends State {
        protected TaskState(String name, int id) {
            super(name, id);
        }

        protected void Entry(TaskContext context) {
        }

        protected void Exit(TaskContext context) {
        }

        protected void cancel(TaskContext context) {
            this.Default(context);
        }

        protected void cancel_failure(TaskContext context, Integer rc, Object cause) {
            this.Default(context);
        }

        protected void cancel_noroute(TaskContext context) {
            this.Default(context);
        }

        protected void cancel_success(TaskContext context) {
            this.Default(context);
        }

        protected void cancel_timeout(TaskContext context) {
            this.Default(context);
        }

        protected void copy_failure(TaskContext context, Integer rc, Object cause) {
            this.Default(context);
        }

        protected void copy_nopools(TaskContext context) {
            this.Default(context);
        }

        protected void copy_noroute(TaskContext context) {
            this.Default(context);
        }

        protected void copy_success(TaskContext context) {
            this.Default(context);
        }

        protected void copy_timeout(TaskContext context) {
            this.Default(context);
        }

        protected void messageArrived(TaskContext context, PoolMigrationCopyFinishedMessage message) {
            this.Default(context);
        }

        protected void move_failure(TaskContext context, Integer rc, Object cause) {
            this.Default(context);
        }

        protected void move_noroute(TaskContext context) {
            this.Default(context);
        }

        protected void move_success(TaskContext context) {
            this.Default(context);
        }

        protected void move_timeout(TaskContext context) {
            this.Default(context);
        }

        protected void ping_failure(TaskContext context, Integer rc, Object cause) {
            this.Default(context);
        }

        protected void ping_noroute(TaskContext context) {
            this.Default(context);
        }

        protected void ping_success(TaskContext context) {
            this.Default(context);
        }

        protected void ping_timeout(TaskContext context) {
            this.Default(context);
        }

        protected void query_failure(TaskContext context, Integer rc, Object cause) {
            this.Default(context);
        }

        protected void query_noroute(TaskContext context) {
            this.Default(context);
        }

        protected void query_success(TaskContext context) {
            this.Default(context);
        }

        protected void query_timeout(TaskContext context) {
            this.Default(context);
        }

        protected void run(TaskContext context) {
            this.Default(context);
        }

        protected void timer(TaskContext context) {
            this.Default(context);
        }

        protected void Default(TaskContext context) {
            throw new TransitionUndefinedException("State: " + context.getState().getName() + ", Transition: " + context.getTransition());
        }
    }
}

