/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.migration;

import com.google.common.collect.ImmutableList;
import diskCacheV111.util.PnfsId;
import diskCacheV111.vehicles.Message;
import diskCacheV111.vehicles.PnfsGetCacheLocationsMessage;
import diskCacheV111.vehicles.PoolManagerPoolInformation;
import dmg.cells.nucleus.CellPath;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcache.cells.AbstractMessageCallback;
import org.dcache.cells.CellStub;
import org.dcache.pool.migration.CacheEntryMode;
import org.dcache.pool.migration.Job;
import org.dcache.pool.migration.JobDefinition;
import org.dcache.pool.migration.PoolMigrationCancelMessage;
import org.dcache.pool.migration.PoolMigrationCopyFinishedMessage;
import org.dcache.pool.migration.PoolMigrationCopyReplicaMessage;
import org.dcache.pool.migration.PoolMigrationPingMessage;
import org.dcache.pool.migration.TaskContext;
import org.dcache.pool.repository.CacheEntry;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.services.pinmanager1.PinManagerMovePinMessage;
import org.dcache.util.ReflectionUtils;
import org.dcache.vehicles.FileAttributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import statemap.TransitionUndefinedException;

public class Task {
    private static final Logger _log = LoggerFactory.getLogger(Job.class);
    private static final AtomicInteger _counter = new AtomicInteger();
    private final TaskContext _fsm;
    private final Job _job;
    private final CellStub _pool;
    private final CellStub _pnfs;
    private final CellStub _pinManager;
    private final ScheduledExecutorService _executor;
    private final String _source;
    private final String _pinPrefix;
    private final JobDefinition _definition;
    private final long _id;
    private final UUID _uuid;
    private final CacheEntry _entry;
    private ScheduledFuture<?> _timerTask;
    private List<String> _locations = Collections.emptyList();
    private CellPath _target;

    public Task(Job job, CellStub pool, CellStub pnfs, CellStub pinManager, ScheduledExecutorService executor, String source, CacheEntry entry, JobDefinition definition) {
        this._id = _counter.getAndIncrement();
        this._uuid = UUID.randomUUID();
        this._fsm = new TaskContext(this);
        this._job = job;
        this._pool = pool;
        this._pnfs = pnfs;
        this._pinManager = pinManager;
        this._executor = executor;
        this._source = source;
        this._entry = entry;
        this._definition = definition;
        this._pinPrefix = this._pinManager.getDestinationPath().getDestinationAddress().getCellName();
    }

    public boolean getMustMovePins() {
        return this._definition.mustMovePins;
    }

    public long getId() {
        return this._id;
    }

    public PnfsId getPnfsId() {
        return this._entry.getPnfsId();
    }

    public long getFileSize() {
        return this._entry.getReplicaSize();
    }

    public long getPingPeriod() {
        return this._pool.getTimeout() * 2L;
    }

    public long getNoResponseTimeout() {
        return this._pool.getTimeout() * 2L;
    }

    public long getTaskDeadTimeout() {
        return this._pool.getTimeout();
    }

    public boolean isEager() {
        return this._definition.isEager;
    }

    synchronized String getTarget() {
        return this._target == null ? "" : this._target.toSmallString();
    }

    private boolean isPin(StickyRecord record) {
        return record.owner().startsWith(this._pinPrefix);
    }

    private EntryState getTargetState() {
        switch (this._definition.targetMode.state) {
            case SAME: {
                return this._entry.getState();
            }
            case CACHED: {
                return EntryState.CACHED;
            }
            case PRECIOUS: {
                return EntryState.PRECIOUS;
            }
        }
        throw new IllegalStateException("Unsupported target mode");
    }

    private List<StickyRecord> getTargetStickyRecords() {
        ArrayList<StickyRecord> result = new ArrayList<StickyRecord>();
        if (this._definition.targetMode.state == CacheEntryMode.State.SAME) {
            for (StickyRecord record : this._entry.getStickyRecords()) {
                if (this.isPin(record)) continue;
                result.add(record);
            }
        }
        result.addAll(this._definition.targetMode.stickyRecords);
        return result;
    }

    private Collection<String> getPools() {
        HashSet<String> pools = new HashSet<String>();
        for (PoolManagerPoolInformation pool : this._definition.poolList.getPools()) {
            pools.add(pool.getName());
        }
        return pools;
    }

    private CellPath selectPool() throws NoSuchElementException {
        ImmutableList<PoolManagerPoolInformation> pools = this._definition.poolList.getPools();
        if (pools.isEmpty()) {
            throw new NoSuchElementException("No pools available");
        }
        return new CellPath(this._definition.selectionStrategy.select((List<PoolManagerPoolInformation>)pools).getName());
    }

    synchronized void getInfo(PrintWriter pw) {
        if (this._target != null) {
            pw.println(String.format("[%d] %s: %s -> %s", new Object[]{this._id, this._entry.getPnfsId(), this._fsm.getState(), this._target.toSmallString()}));
        } else {
            pw.println(String.format("[%d] %s: %s", new Object[]{this._id, this._entry.getPnfsId(), this._fsm.getState()}));
        }
    }

    public synchronized void messageArrived(PoolMigrationCopyFinishedMessage message) {
        if (this._uuid.equals(message.getUUID())) {
            this._fsm.messageArrived(message);
        }
    }

    synchronized void queryLocations() {
        this._pnfs.send(new PnfsGetCacheLocationsMessage(this.getPnfsId()), PnfsGetCacheLocationsMessage.class, new Callback<PnfsGetCacheLocationsMessage>("query_"){

            @Override
            public void success(PnfsGetCacheLocationsMessage msg) {
                Task.this.setLocations(msg.getCacheLocations());
                super.success(msg);
            }
        });
    }

    private synchronized void setLocations(List<String> locations) {
        this._locations = new ArrayList<String>(locations);
        this._locations.retainAll(this.getPools());
    }

    synchronized boolean hasMoreLocations() {
        return !this._locations.isEmpty();
    }

    synchronized void updateExistingReplica() {
        assert (!this._locations.isEmpty());
        this.initiateCopy(new CellPath(this._locations.remove(0)));
        if (this._locations.isEmpty()) {
            this._locations = Collections.emptyList();
        }
    }

    synchronized void initiateCopy() {
        try {
            this.initiateCopy(this.selectPool());
        }
        catch (NoSuchElementException e) {
            this._target = null;
            this._executor.execute(new LoggingTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Task task = Task.this;
                    synchronized (task) {
                        Task.this._fsm.copy_nopools();
                    }
                }
            }));
        }
    }

    private synchronized void initiateCopy(CellPath target) {
        FileAttributes fileAttributes = this._entry.getFileAttributes();
        this._target = target;
        this._pool.send(this._target, new PoolMigrationCopyReplicaMessage(this._uuid, this._source, fileAttributes, this.getTargetState(), this.getTargetStickyRecords(), this._definition.computeChecksumOnUpdate, this._definition.forceSourceMode), PoolMigrationCopyReplicaMessage.class, new Callback("copy_"));
    }

    synchronized void cancelCopy() {
        this._pool.send(this._target, new PoolMigrationCancelMessage(this._uuid, this._source, this.getPnfsId()), PoolMigrationCancelMessage.class, new Callback("cancel_"));
    }

    synchronized void movePin() {
        ArrayList<StickyRecord> records = new ArrayList<StickyRecord>();
        for (StickyRecord record : this._entry.getStickyRecords()) {
            if (!this.isPin(record)) continue;
            records.add(record);
        }
        Callback<Object> callback = new Callback<Object>("move_");
        if (records.isEmpty()) {
            callback.success((Object)null);
        } else {
            String target = this._target.getDestinationAddress().getCellName();
            PinManagerMovePinMessage message = new PinManagerMovePinMessage(this.getPnfsId(), records, this._source, target);
            this._pinManager.send(message, PinManagerMovePinMessage.class, callback);
        }
    }

    void notifyCancelled() {
        this._executor.execute(new LoggingTask(new Runnable(){

            @Override
            public void run() {
                Task.this._job.taskCancelled(Task.this);
            }
        }));
    }

    void fail(final String message) {
        this._executor.execute(new LoggingTask(new Runnable(){

            @Override
            public void run() {
                Task.this._job.taskFailed(Task.this, message);
            }
        }));
    }

    void failPermanently(final String message) {
        this._executor.execute(new LoggingTask(new Runnable(){

            @Override
            public void run() {
                Task.this._job.taskFailedPermanently(Task.this, message);
            }
        }));
    }

    void notifyCompleted() {
        this._executor.execute(new LoggingTask(new Runnable(){

            @Override
            public void run() {
                Task.this._job.taskCompleted(Task.this);
            }
        }));
    }

    synchronized void startTimer(long delay) {
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Task task = Task.this;
                synchronized (task) {
                    if (Task.this._timerTask != null) {
                        Task.this._fsm.timer();
                        Task.this._timerTask = null;
                    }
                }
            }
        };
        this._timerTask = this._executor.schedule(new LoggingTask(task), delay, TimeUnit.MILLISECONDS);
    }

    synchronized void stopTimer() {
        if (this._timerTask != null) {
            this._timerTask.cancel(false);
            this._timerTask = null;
        }
    }

    synchronized void ping() {
        this._pool.send(this._target, new PoolMigrationPingMessage(this._uuid, this._source, this.getPnfsId()), PoolMigrationPingMessage.class, new Callback("ping_"));
    }

    public synchronized void run() {
        this._fsm.run();
    }

    public synchronized void cancel() {
        this._fsm.cancel();
    }

    protected class LoggingTask
    implements Runnable {
        private final Runnable _inner;

        public LoggingTask(Runnable r) {
            this._inner = r;
        }

        @Override
        public void run() {
            try {
                this._inner.run();
            }
            catch (Error | RuntimeException e) {
                Thread me = Thread.currentThread();
                me.getUncaughtExceptionHandler().uncaughtException(me, e);
                Task.this.fail(e.getMessage());
            }
        }
    }

    class Callback<T extends Message>
    extends AbstractMessageCallback<T> {
        private final String _prefix;

        public Callback() {
            this._prefix = "";
        }

        public Callback(String prefix) {
            this._prefix = prefix;
        }

        protected void transition(String name, final Object ... arguments) {
            Class[] parameterTypes = new Class[arguments.length];
            for (int i = 0; i < arguments.length; ++i) {
                parameterTypes[i] = arguments[i].getClass();
            }
            final Method m = ReflectionUtils.resolve(((Object)((Object)Task.this._fsm)).getClass(), this._prefix + name, parameterTypes);
            if (m != null) {
                Task.this._executor.execute(new LoggingTask(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            Task task = Task.this;
                            synchronized (task) {
                                m.invoke((Object)Task.this._fsm, arguments);
                            }
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException("Bug detected", e);
                        }
                        catch (TransitionUndefinedException e) {
                            throw new RuntimeException("State machine is incomplete", e);
                        }
                    }
                }));
            }
        }

        @Override
        public void success(T message) {
            this.transition("success", new Object[0]);
        }

        @Override
        public void failure(int rc, Object cause) {
            this.transition("failure", rc, cause);
        }

        @Override
        public void timeout(CellPath path) {
            this.transition("timeout", new Object[0]);
        }

        @Override
        public void noroute(CellPath path) {
            this.transition("noroute", new Object[0]);
        }
    }
}

