/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.migration;

import diskCacheV111.pools.PoolCostInfo;
import diskCacheV111.vehicles.PoolManagerPoolInformation;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.dcache.pool.migration.PoolSelectionStrategy;

public class ProportionalPoolSelectionStrategy
implements PoolSelectionStrategy {
    private static final double SECONDS_IN_WEEK = TimeUnit.DAYS.toSeconds(7L);
    private static final double LOG2 = Math.log(2.0);
    private final Random _random = new Random();

    private synchronized double random() {
        return this._random.nextDouble();
    }

    double getAvailable(PoolCostInfo.PoolSpaceInfo space) {
        double halflife;
        long free = space.getFreeSpace();
        double removable = space.getRemovableSpace();
        double breakeven = space.getBreakEven();
        double lru = space.getLRUSeconds();
        long gap = space.getGap();
        if (breakeven >= 1.0) {
            halflife = SECONDS_IN_WEEK * 2.0;
        } else if (breakeven > 0.0) {
            halflife = SECONDS_IN_WEEK * -LOG2 / Math.log(breakeven);
        } else {
            long available = free + (long)removable;
            return available > gap ? (double)available : 0.0;
        }
        double undecayed = lru > 0.0 ? removable * halflife * (1.0 - Math.pow(2.0, -lru / halflife)) / (lru * LOG2) : removable;
        double decayed = removable - undecayed;
        double available = (double)free + decayed;
        return available > (double)gap ? available : 0.0;
    }

    double getWeightedAvailable(PoolCostInfo info) {
        double available = this.getAvailable(info.getSpaceInfo());
        double load = info.getMoverCostFactor() * (double)info.getWriters();
        return available / Math.pow(2.0, load);
    }

    @Override
    public PoolManagerPoolInformation select(List<PoolManagerPoolInformation> pools) {
        double[] available = new double[pools.size()];
        double sum = 0.0;
        for (int i = 0; i < available.length; ++i) {
            PoolCostInfo cost = pools.get(i).getPoolCostInfo();
            if (cost == null) continue;
            available[i] = this.getWeightedAvailable(cost);
            sum += available[i];
        }
        double threshold = this.random() * sum;
        sum = 0.0;
        for (int i = 0; i < available.length; ++i) {
            if (!((sum += available[i]) >= threshold)) continue;
            return pools.get(i);
        }
        return pools.get(pools.size() - 1);
    }
}

