/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.migration;

import com.google.common.base.Preconditions;
import diskCacheV111.vehicles.StorageInfo;
import diskCacheV111.vehicles.StorageInfos;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.List;
import java.util.UUID;
import org.dcache.pool.migration.PoolMigrationMessage;
import org.dcache.pool.repository.EntryState;
import org.dcache.pool.repository.StickyRecord;
import org.dcache.vehicles.FileAttributes;

public class PoolMigrationCopyReplicaMessage
extends PoolMigrationMessage {
    private static final long serialVersionUID = 6328444770149191656L;
    private FileAttributes _fileAttributes;
    @Deprecated
    private StorageInfo _storageInfo;
    private final EntryState _state;
    private final List<StickyRecord> _stickyRecords;
    private final boolean _computeChecksumOnUpdate;
    private final boolean _forceSourceMode;

    public PoolMigrationCopyReplicaMessage(UUID uuid, String pool, FileAttributes fileAttributes, EntryState state, List<StickyRecord> stickyRecords, boolean computeChecksumOnUpdate, boolean forceSourceMode) {
        super(uuid, pool, fileAttributes.getPnfsId());
        Preconditions.checkNotNull((Object)((Object)state));
        Preconditions.checkNotNull(stickyRecords);
        this._fileAttributes = fileAttributes;
        this._storageInfo = StorageInfos.extractFrom(fileAttributes);
        this._state = state;
        this._stickyRecords = stickyRecords;
        this._computeChecksumOnUpdate = computeChecksumOnUpdate;
        this._forceSourceMode = forceSourceMode;
    }

    public EntryState getState() {
        return this._state;
    }

    public List<StickyRecord> getStickyRecords() {
        return this._stickyRecords;
    }

    public boolean getComputeChecksumOnUpdate() {
        return this._computeChecksumOnUpdate;
    }

    public FileAttributes getFileAttributes() {
        return this._fileAttributes;
    }

    public boolean isForceSourceMode() {
        return this._forceSourceMode;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this._fileAttributes == null) {
            this._fileAttributes = new FileAttributes();
            if (this._storageInfo != null) {
                StorageInfos.injectInto(this._storageInfo, this._fileAttributes);
            }
            this._fileAttributes.setPnfsId(this.getPnfsId());
        }
    }
}

