/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.pool.migration;

import com.google.common.collect.ImmutableList;
import diskCacheV111.vehicles.PoolManagerPoolInformation;
import java.util.Collection;
import java.util.regex.Pattern;
import org.dcache.pool.migration.RefreshablePoolList;
import org.dcache.pool.migration.SymbolTable;
import org.dcache.util.expression.Expression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoolListFilter
implements RefreshablePoolList {
    private static final Logger _log = LoggerFactory.getLogger(PoolListFilter.class);
    private static final ImmutableList<PoolManagerPoolInformation> EMPTY_LIST = ImmutableList.of();
    private final Collection<Pattern> _exclude;
    private final Expression _excludeWhen;
    private final Collection<Pattern> _include;
    private final Expression _includeWhen;
    private final RefreshablePoolList _sourceList;
    private final RefreshablePoolList _poolList;
    private ImmutableList<PoolManagerPoolInformation> _cachedList;
    private ImmutableList<PoolManagerPoolInformation> _filteredList;

    public PoolListFilter(RefreshablePoolList poolList, Collection<Pattern> exclude, Expression excludeWhen, Collection<Pattern> include, Expression includeWhen, RefreshablePoolList sourceList) {
        this._poolList = poolList;
        this._exclude = exclude;
        this._excludeWhen = excludeWhen;
        this._include = include;
        this._includeWhen = includeWhen;
        this._sourceList = sourceList;
    }

    @Override
    public boolean isValid() {
        return this._sourceList.isValid() && this._poolList.isValid();
    }

    @Override
    public void refresh() {
        this._poolList.refresh();
    }

    @Override
    public synchronized ImmutableList<PoolManagerPoolInformation> getPools() {
        if (!this.isValid()) {
            return EMPTY_LIST;
        }
        ImmutableList<PoolManagerPoolInformation> list = this._poolList.getPools();
        if (!list.equals(this._cachedList)) {
            ImmutableList.Builder filteredList = ImmutableList.builder();
            for (PoolManagerPoolInformation pool : list) {
                if (this.isExcluded(pool) || !this.isIncluded(pool)) continue;
                filteredList.add((Object)pool);
            }
            this._filteredList = filteredList.build();
        }
        this._cachedList = list;
        return this._filteredList;
    }

    private boolean matchesAny(Collection<Pattern> patterns, String s) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(s).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isExcluded(PoolManagerPoolInformation pool) {
        if (this.matchesAny(this._exclude, pool.getName())) {
            return true;
        }
        return this.evaluate(this._excludeWhen, pool);
    }

    private boolean isIncluded(PoolManagerPoolInformation pool) {
        if (!this._include.isEmpty()) {
            return this.matchesAny(this._include, pool.getName());
        }
        return this.evaluate(this._includeWhen, pool);
    }

    private PoolManagerPoolInformation getSource() {
        ImmutableList<PoolManagerPoolInformation> list = this._sourceList.getPools();
        if (list.size() != 1) {
            throw new IllegalStateException("Unexpected source pool list: Exactly one item was expected, but it contained " + list.size());
        }
        return (PoolManagerPoolInformation)list.get(0);
    }

    private boolean evaluate(Expression expression, PoolManagerPoolInformation pool) {
        SymbolTable symbols = new SymbolTable();
        symbols.put("target", pool);
        symbols.put("source", this.getSource());
        return expression.evaluateBoolean(symbols);
    }

    public String toString() {
        ImmutableList<PoolManagerPoolInformation> pools = this.getPools();
        if (pools.isEmpty()) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        s.append(((PoolManagerPoolInformation)pools.get(0)).getName());
        for (int i = 1; i < pools.size(); ++i) {
            s.append(',').append(((PoolManagerPoolInformation)pools.get(i)).getName());
        }
        return s.toString();
    }
}

